SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

create view [System.Activities.DurableInstancing].[ServiceDeployments] as
      select [Id] as [ServiceDeploymentId],
             [SiteName],
             [RelativeServicePath],
             [RelativeApplicationPath],
             [ServiceName],
             [ServiceNamespace]
      from [System.Activities.DurableInstancing].[ServiceDeploymentsTable]
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

create trigger [System.Activities.DurableInstancing].[DeleteServiceDeploymentTrigger] on [System.Activities.DurableInstancing].[ServiceDeployments]
instead of delete
as
begin	
	if (@@rowcount = 0)
		return	
		
	set nocount on
	set transaction isolation level read committed		
	set xact_abort on;	
	
	declare @lockAcquired bigint
	declare @candidateDeploymentIdsPass1 table([Id] bigint primary key)
	
	exec @lockAcquired = sp_getapplock @Resource = 'InstanceStoreLock', @LockMode = 'Exclusive', @LockTimeout = 25000
	
	if (@lockAcquired < 0)
		return

	insert into @candidateDeploymentIdsPass1
	select [ServiceDeploymentId] from deleted
	except
	select [ServiceDeploymentId] from [InstancesTable]
	
	delete [ServiceDeploymentsTable]
	from [ServiceDeploymentsTable]
	join @candidateDeploymentIdsPass1 as [OrphanedIds] on [OrphanedIds].[Id] = [ServiceDeploymentsTable].[Id]
	
	exec sp_releaseapplock @Resource = 'InstanceStoreLock'
end
GO
EXEC sp_addextendedproperty N'MS_Description', N'The ServiceDeployments view contains deployment information for all Web (IIS/WAS) hosted workflow services. Each workflow instance that is Web-hosted will contain a ServiceDeploymentId that refers to a row in this view.', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'ServiceDeployments', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'Represents the virtual path relative to the site that points to an application that contains the workflow service. (e.g. /app1).', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'ServiceDeployments', 'COLUMN', N'RelativeApplicationPath'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Represents the virtual path relative to the site that points to the workflow service. (e.g. /app1/PurchaseOrderService.svc).', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'ServiceDeployments', 'COLUMN', N'RelativeServicePath'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The primary key for this view.', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'ServiceDeployments', 'COLUMN', N'ServiceDeploymentId'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Represents the name of the workflow Service. (e.g. PurchaseOrderService).', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'ServiceDeployments', 'COLUMN', N'ServiceName'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Represents the namespace of the workflow Service. (e.g. MyCompany).', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'ServiceDeployments', 'COLUMN', N'ServiceNamespace'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Represents the name of the site that contains the workflow service (e.g. Default Web Site).', 'SCHEMA', N'System.Activities.DurableInstancing', 'VIEW', N'ServiceDeployments', 'COLUMN', N'SiteName'
GO
