CREATE TABLE [System.Activities.DurableInstancing].[KeysTable]
(
[Id] [uniqueidentifier] NOT NULL,
[SurrogateKeyId] [bigint] NOT NULL IDENTITY(1, 1),
[SurrogateInstanceId] [bigint] NULL,
[EncodingOption] [tinyint] NULL,
[Properties] [varbinary] (max) NULL,
[IsAssociated] [bit] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE UNIQUE CLUSTERED INDEX [CIX_KeysTable] ON [System.Activities.DurableInstancing].[KeysTable] ([Id]) WITH (IGNORE_DUP_KEY=ON, ALLOW_PAGE_LOCKS=OFF) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [NCIX_KeysTable_SurrogateInstanceId] ON [System.Activities.DurableInstancing].[KeysTable] ([SurrogateInstanceId]) WITH (ALLOW_PAGE_LOCKS=OFF) ON [PRIMARY]
GO
