IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Get_Bed_Staff]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Get_Bed_Staff]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[usp_Get_Bed_Staff]
	@BED_UID UNIQUEIDENTIFIER
AS
BEGIN	

	SELECT TOP 2 FIRST_ROW_COMPARED.PK, FIRST_ROW_COMPARED.BED_UID, FIRST_ROW_COMPARED.DIVISION_UID, FIRST_ROW_COMPARED.STAFF,
		   FIRST_ROW_COMPARED.PATIENT_UID, FIRST_ROW_COMPARED.FACILITY_UID, FIRST_ROW_COMPARED.TRANSACTION_TYPE_CODE,
		   FIRST_ROW_COMPARED.[DATE] AS [CREATED_DATE], [dbo].[ufn_GetUsernameBySID](FIRST_ROW_COMPARED.CREATED_BY) AS [CREATED_BY] 
	FROM BED_STAFF_H AS FIRST_ROW_COMPARED
	LEFT OUTER JOIN BED_STAFF_H AS SECOND_ROW_COMPARED ON SECOND_ROW_COMPARED.PK = (SELECT MAX(NEXT_ROW_COMPARED.PK)
			FROM BED_STAFF_H AS NEXT_ROW_COMPARED WHERE  
			NEXT_ROW_COMPARED.BED_UID = FIRST_ROW_COMPARED.BED_UID AND  NEXT_ROW_COMPARED.PK < FIRST_ROW_COMPARED.PK AND NEXT_ROW_COMPARED.BED_UID = @BED_UID)
			AND FIRST_ROW_COMPARED.STAFF = SECOND_ROW_COMPARED.STAFF
			AND FIRST_ROW_COMPARED.FACILITY_UID = SECOND_ROW_COMPARED.FACILITY_UID
			AND FIRST_ROW_COMPARED.TRANSACTION_TYPE_CODE = 'U'
	WHERE SECOND_ROW_COMPARED.PK IS NULL AND FIRST_ROW_COMPARED.BED_UID = @BED_UID
	ORDER BY FIRST_ROW_COMPARED.PK DESC	

END
GO