IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ufn_GetOffsetByFacilityUID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[ufn_GetOffsetByFacilityUID]
GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE FUNCTION [dbo].[ufn_GetOffsetByFacilityUID](@FACILITY_UID UNIQUEIDENTIFIER)
RETURNS int
AS
BEGIN
	DECLARE @OFFSET NVARCHAR(200)
	
	SELECT @OFFSET = OFFSET
	FROM [CONFIG_EVS_H] AS CONFIG_EVS 
	INNER JOIN [CONFIG_H] AS CONFIG ON CONFIG_EVS.CONFIG_ID = CONFIG.ID
	INNER JOIN TIMEZONE_OFFSET AS TIME_OFFSET ON TIME_OFFSET.TIMEZONE = CONFIG_EVS.CODE
	WHERE CONFIG_EVS.CODE_SYSTEM_NAME = 'TimeZone' and CONFIG.CONFIG_KEY = 'facilitysitetimezone'
		and CONFIG.SECTION = 'FacilitySettings ' + cast(@facility_uid as nvarchar(50))

	RETURN @OFFSET

END

GO


