CREATE TABLE [dbo].[SECURITY_CONTEXT_H]
(
[PK] [int] NOT NULL IDENTITY(1, 1),
[SPID] [int] NOT NULL,
[USER_GROUP_ID] [varchar] (8000) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[DOMAIN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SUPERUSER] [bit] NULL,
[TRANSACTION_TYPE_CODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[DATE] [datetime] NOT NULL,
[CREATED_BY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
) ON [PRIMARY]
GO
ALTER TABLE [dbo].[SECURITY_CONTEXT_H] ADD CONSTRAINT [PK_SECURITY_CONTEXT_H] PRIMARY KEY CLUSTERED  ([PK]) ON [PRIMARY]
GO
EXEC sp_addextendedproperty N'MS_Description', N'Table that contains the security context.', 'SCHEMA', N'dbo', 'TABLE', N'SECURITY_CONTEXT_H', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'SECURITY_CONTEXT_H', 'COLUMN', N'CREATED_BY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'SECURITY_CONTEXT_H', 'COLUMN', N'DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Domain name.', 'SCHEMA', N'dbo', 'TABLE', N'SECURITY_CONTEXT_H', 'COLUMN', N'DOMAIN'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Primary key.', 'SCHEMA', N'dbo', 'TABLE', N'SECURITY_CONTEXT_H', 'COLUMN', N'PK'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Table''s identifier.', 'SCHEMA', N'dbo', 'TABLE', N'SECURITY_CONTEXT_H', 'COLUMN', N'SPID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'True or false if it is super user or not.', 'SCHEMA', N'dbo', 'TABLE', N'SECURITY_CONTEXT_H', 'COLUMN', N'SUPERUSER'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Code of transaction(I = Inserted, U = Updated, D = Deleted).', 'SCHEMA', N'dbo', 'TABLE', N'SECURITY_CONTEXT_H', 'COLUMN', N'TRANSACTION_TYPE_CODE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the user group.', 'SCHEMA', N'dbo', 'TABLE', N'SECURITY_CONTEXT_H', 'COLUMN', N'USER_GROUP_ID'
GO
