CREATE TABLE [dbo].[POLICY_H]
(
[PK] [int] NOT NULL IDENTITY(1, 1),
[PERMISSION_ID] [uniqueidentifier] NOT NULL,
[ROLE_ID] [uniqueidentifier] NOT NULL,
[TRANSACTION_TYPE_CODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[DATE] [datetime] NOT NULL,
[CREATED_BY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
) ON [PRIMARY]
GO
ALTER TABLE [dbo].[POLICY_H] ADD CONSTRAINT [PK_POLICY_H] PRIMARY KEY CLUSTERED  ([PK]) ON [PRIMARY]
GO
EXEC sp_addextendedproperty N'MS_Description', N'Table that contains permission policies.', 'SCHEMA', N'dbo', 'TABLE', N'POLICY_H', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'POLICY_H', 'COLUMN', N'CREATED_BY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'POLICY_H', 'COLUMN', N'DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the permission that is been associated to the role.', 'SCHEMA', N'dbo', 'TABLE', N'POLICY_H', 'COLUMN', N'PERMISSION_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Primary key.', 'SCHEMA', N'dbo', 'TABLE', N'POLICY_H', 'COLUMN', N'PK'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the role that is been associated to the permission.', 'SCHEMA', N'dbo', 'TABLE', N'POLICY_H', 'COLUMN', N'ROLE_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Code of transaction(I = Inserted, U = Updated, D = Deleted).', 'SCHEMA', N'dbo', 'TABLE', N'POLICY_H', 'COLUMN', N'TRANSACTION_TYPE_CODE'
GO
