CREATE TABLE [dbo].[MOVEMENT_EVN_H]
(
[PK] [int] NOT NULL IDENTITY(1, 1),
[ID] [int] NOT NULL,
[DOMAIN_ID] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[IEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PATIENT_UID] [UNIQUEIDENTIFIER] NOT NULL,
[ENTERED_DATE] DATETIME NOT NULL,
[WARD_UID] [uniqueidentifier] NULL,
[BED_UID] [uniqueidentifier] NULL,
[OLD_WARD_UID] [uniqueidentifier] NULL,
[OLD_BED_UID] [uniqueidentifier] NULL,
[VISTA_SITE_UID] [uniqueidentifier] NULL,
[TYPE_OF_MOVEMENT_ID] [int] NULL,
[MOVEMENT_DATE] [datetime] NULL,
[ENTERED_BY_UID] [uniqueidentifier] NULL,
[ADMISSION_ID] [int] NULL,
[TRANSACTION_TYPE_CODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[DATE] [datetime] NOT NULL,
[CREATED_BY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATION_UTC_DATE] DATETIME NOT NULL
) ON [PRIMARY]
GO
ALTER TABLE [dbo].[MOVEMENT_EVN_H] ADD CONSTRAINT [PK_MOVEMENT_EVN_H] PRIMARY KEY CLUSTERED  ([PK]) ON [PRIMARY]
GO
EXEC sp_addextendedproperty N'MS_Description', N'Movement event act(used to import VistA transfers data).', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN_H', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'ID of the movement event.', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN_H', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The bed id where the patient was moved.', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN_H', 'COLUMN', N'BED_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN_H', 'COLUMN', N'CREATED_BY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN_H', 'COLUMN', N'DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The id of the person who made the movement.', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN_H', 'COLUMN', N'ENTERED_BY_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date when the movement was made.', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN_H', 'COLUMN', N'ENTERED_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Primary key.', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN_H', 'COLUMN', N'PK'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Code of transaction(I = Inserted, U = Updated, D = Deleted).', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN_H', 'COLUMN', N'TRANSACTION_TYPE_CODE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indicates the type of movement(VistA data).', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN_H', 'COLUMN', N'TYPE_OF_MOVEMENT_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The ward id where the patient was moved.', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN_H', 'COLUMN', N'WARD_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The UTC date and time when the act was created.', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN_H', 'COLUMN', N'CREATION_UTC_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'A logical grouping of discharges.', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN_H', 'COLUMN', N'DOMAIN_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the patient.', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN_H', 'COLUMN', N'PATIENT_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indentity column imported from VistA(VistA IEN).', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN_H', 'COLUMN', N'IEN'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Date of movement.', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN_H', 'COLUMN', N'MOVEMENT_DATE'
GO