CREATE TABLE [dbo].[BED_CLEAN_H](
	[PK] [int] IDENTITY(1,1) NOT NULL,
	[ID] [int] NOT NULL,
	[DOMAIN_ID] [nvarchar] (50) NOT NULL,
	[BED_UID] [uniqueidentifier] NOT NULL,
	[WARD_UID] [uniqueidentifier] NULL,
	[DIVISION_UID] [uniqueidentifier] NULL,
	[VISTA_SITE_UID] [uniqueidentifier] NULL,
	[TYPE_OF_CLEAN_ID] [int] NULL,
	[MANUAL_REQUEST_ID] [int] NULL,
	[ACCEPTED_DATE] [datetime] NULL,
	[ACCEPTED_BY] [nvarchar](250) NULL,
	[COMPLETED_DATE] [datetime] NULL,
	[COMPLETED_BY] [nvarchar](250) NULL,
	[TRANSACTION_TYPE_CODE] [varchar](50) NOT NULL,
	[DATE] [datetime] NOT NULL,
	[CREATED_BY] [nvarchar](50) NULL,
	[LAST_EDITED_BY] [nvarchar](50) NULL,
	[LAST_EDIT_DATE] [datetime] NULL,
	[REQUESTED_DATE] [datetime] NULL,
	[EMS_NOTIFY] [nvarchar](10) NULL,
	[SPECIAL_INSTRUCTIONS] [nvarchar](500) NULL,
	[COMMENT] [nvarchar](500) NULL,
	[COMMENTED_BY] [nvarchar](250) NULL,
	[COMMENTED_DATE] [datetime] NULL,
	[VACATED_DATE] [datetime] NULL,
	[EVENT_TYPE] [nvarchar](3) NULL,
	[EVENT_IEN] [varchar] (50),
	[CREATION_UTC_DATE] [datetime] NOT NULL
) ON [PRIMARY]
GO
ALTER TABLE [dbo].[BED_CLEAN_H] ADD CONSTRAINT [PK_BED_CLEAN_H] PRIMARY KEY CLUSTERED  ([PK]) ON [PRIMARY]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Primary key.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_CLEAN_H', @level2type=N'COLUMN',@level2name=N'PK'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Bed clean table.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_CLEAN_H', @level2type=N'COLUMN',@level2name=N'ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Bed''s id.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_CLEAN_H', @level2type=N'COLUMN',@level2name=N'BED_UID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of cleaning id (concept).' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_CLEAN_H', @level2type=N'COLUMN',@level2name=N'TYPE_OF_CLEAN_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Indicates whether the cleaning request is manual or automatic.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_CLEAN_H', @level2type=N'COLUMN',@level2name=N'MANUAL_REQUEST_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date when the bed cleaning request was accepted by a EMS user.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_CLEAN_H', @level2type=N'COLUMN',@level2name=N'ACCEPTED_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The EMS user that accepted the bed cleaning request.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_CLEAN_H', @level2type=N'COLUMN',@level2name=N'ACCEPTED_BY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date when the bed cleaning request was completed.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_CLEAN_H', @level2type=N'COLUMN',@level2name=N'COMPLETED_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The EMS user that completed the bed cleaning request.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_CLEAN_H', @level2type=N'COLUMN',@level2name=N'COMPLETED_BY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Code of transaction(I = Inserted, U = Updated, D = Deleted).' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_CLEAN_H', @level2type=N'COLUMN',@level2name=N'TRANSACTION_TYPE_CODE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Datetime when record was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_CLEAN_H', @level2type=N'COLUMN',@level2name=N'DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User ID of user when record was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_CLEAN_H', @level2type=N'COLUMN',@level2name=N'CREATED_BY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User ID of user when record was last changed.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_CLEAN_H', @level2type=N'COLUMN',@level2name=N'LAST_EDITED_BY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Datetime when record was last changed.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_CLEAN_H', @level2type=N'COLUMN',@level2name=N'LAST_EDIT_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date of the the bed cleaning request.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_CLEAN_H', @level2type=N'COLUMN',@level2name=N'REQUESTED_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Field that contains special instructions.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_CLEAN_H', @level2type=N'COLUMN',@level2name=N'SPECIAL_INSTRUCTIONS'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Comments associated to bed clean.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_CLEAN_H', @level2type=N'COLUMN',@level2name=N'COMMENT'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User ID of the user when a comment was added and modified.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_CLEAN_H', @level2type=N'COLUMN',@level2name=N'COMMENTED_BY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date when a comment was added or modified.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_CLEAN_H', @level2type=N'COLUMN',@level2name=N'COMMENTED_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table storing information about bed cleaning. ' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_CLEAN_H'
GO