CREATE TABLE [dbo].[GROUP_ICON_ASSOCIATION_ETL](
	[BED_SOURCE_ID] [nvarchar](250) NULL,
	[PATIENT_SOURCE_ID] [nvarchar](250) NULL,
	[ICON_FLAG_ID] [int] NULL,
	[ICON_FLAG_FACILITY_ID] [int] NULL,
	[SOURCE_ID] [int] NOT NULL,
	[_ssis_timestamp] [datetime] NULL
) ON [PRIMARY]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Temporary table that associates icons with their corresponding bed or patient id. Used by reports full.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'GROUP_ICON_ASSOCIATION_ETL'
GO
CREATE NONCLUSTERED INDEX [idx_BED_SOURCE_ID] ON [dbo].[GROUP_ICON_ASSOCIATION_ETL] 
(
	[BED_SOURCE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_ICON_FLAG_FACILITY_ID] ON [dbo].[GROUP_ICON_ASSOCIATION_ETL] 
(
	[ICON_FLAG_FACILITY_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_ICON_FLAG_ID] ON [dbo].[GROUP_ICON_ASSOCIATION_ETL] 
(
	[ICON_FLAG_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_PATIENT_SOURCE_ID] ON [dbo].[GROUP_ICON_ASSOCIATION_ETL] 
(
	[PATIENT_SOURCE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON [dbo].[GROUP_ICON_ASSOCIATION_ETL] 
(
	[SOURCE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO