
CREATE TABLE [dbo].[FACT_WAITING_LIST_ETL](
	[SOURCE_ID] [int] NOT NULL,
	[FACILITY_ID] [nvarchar](250) NULL,
	[VISTA_SITE_ID] [nvarchar](250) NULL,
	[WAITING_AREA_CODE] [varchar](100) NULL,
	[PROBLEM] [nvarchar](max) NULL,
	[FEE_DISPOSITION_CODE] [varchar](100) NULL,
	[CONTRACT_FEE_CODE] [varchar](100) NULL,
	[AUTHORIZED_FEE_CODE] [varchar](100) NULL,
	[SERVICE_RECEIVING_FEE_CODE] [varchar](100) NULL,
	[DIM_REASON_USING_FEE_CODE] [varchar](100) NULL,
	[FEE_COMMENTS] [nvarchar](150) NULL,
	[REMOVED_DATE] [datetime] NULL,
	[TYPE_OF_BED_WARD] [nvarchar](250) NULL,
	[REQUESTED_BED_ID] [nvarchar](250) NULL,
	[REQUESTED_BED_DATE] [datetime] NULL,
	[REQUESTED_DATE] [datetime] NULL,
	[_SSIS_TIMESTAMP] [datetime] NULL,
	[IS_IN_HOUSE] [bit] NULL,
	[LAST_EDIT_BY] [nvarchar](100) NULL,
	[COMMENTS] [nvarchar](150) NULL,
	[IS_BED_IN_ISOLATION] [bit] NOT NULL,
	[WAIT_TIME_ALERT_DATE] [datetime] NULL,
	[IS_COMMUNITY_LIVING_CENTER] [bit] NULL,
	[IS_EVACUATION_PATIENT] [bit] NULL,
	[EVACUATION_DISPOSITION_STATUS_CODE] [varchar](100) NULL,
	[EVACUATION_EXPECTED_DATE] [datetime] NULL,
	[EVACUATION_ACTUAL_DATE] [datetime] NULL,
	[EVACUATION_REASON_FOR_DELAY] [nvarchar](250) NULL,
	[EVACUATION_TRANSFER_EVACUATE_TO] [nvarchar](250) NULL,
	[EVACUATION_EQUIP_SUPPLY_REQUIREMENTS] [nvarchar](250) NULL,
	[EVACUATION_TRANSPORTATION_CARE_LEVEL] [nvarchar](250) NULL,
	[EVACUATION_ENROUTE_MEDICAL_ATTENDANT] [nvarchar](250) NULL,
	[EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT] [nvarchar](250) NULL,
	[EVACUATION_TRANSPORTATION_TYPE_CODE] [varchar](100) NULL,
	[EVACUATION_TRANSPORTATION_PROVIDER_CODE] [varchar](100) NULL,
	[EVACUATION_TRANSPORTATION_COMMENTS] [nvarchar](250) NULL,
	[EVACUATION_DESTINATION_ADDRESS] [nvarchar](250) NULL,
	[EVACUATION_DESTINATION_CITY_STATE] [nvarchar](250) NULL,
	[EVACUATION_DESTINATION_POC_TELEPHONE] [nvarchar](100) NULL,
	[EVACUATION_ORIGINATOR_POC_TELEPHONE] [nvarchar](100) NULL,
	[EVACUATION_COMMENTS] [nvarchar](500) NULL,
	[EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER] [int] NULL,
	[EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER] [int] NULL,
	[DIM_PATIENT_ID] [nvarchar](250) NULL
) ON [PRIMARY]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Patient waiting list temporary table. Used by reports full and incremental job.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST_ETL'
GO
CREATE NONCLUSTERED INDEX [idx_AUTHORIZED_FEE_CODE] ON [dbo].[FACT_WAITING_LIST_ETL] 
(
	[AUTHORIZED_FEE_CODE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_CONTRACT_FEE_CODE] ON [dbo].[FACT_WAITING_LIST_ETL] 
(
	[CONTRACT_FEE_CODE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIM_PATIENT_ID] ON [dbo].[FACT_WAITING_LIST_ETL] 
(
	[DIM_PATIENT_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIM_REASON_USING_FEE_CODE] ON [dbo].[FACT_WAITING_LIST_ETL] 
(
	[DIM_REASON_USING_FEE_CODE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_EVACUATION_DISPOSITION_STATUS_CODE] ON [dbo].[FACT_WAITING_LIST_ETL] 
(
	[EVACUATION_DISPOSITION_STATUS_CODE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_EVACUATION_TRANSPORTATION_PROVIDER_CODE] ON [dbo].[FACT_WAITING_LIST_ETL] 
(
	[EVACUATION_TRANSPORTATION_PROVIDER_CODE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_EVACUATION_TRANSPORTATION_TYPE_CODE] ON [dbo].[FACT_WAITING_LIST_ETL] 
(
	[EVACUATION_TRANSPORTATION_TYPE_CODE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_FACILITY_ID] ON [dbo].[FACT_WAITING_LIST_ETL] 
(
	[FACILITY_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_FEE_DISPOSITION_CODE] ON [dbo].[FACT_WAITING_LIST_ETL] 
(
	[FEE_DISPOSITION_CODE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_REQUESTED_BED_ID] ON [dbo].[FACT_WAITING_LIST_ETL] 
(
	[REQUESTED_BED_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_SERVICE_RECEIVING_FEE_CODE] ON [dbo].[FACT_WAITING_LIST_ETL] 
(
	[SERVICE_RECEIVING_FEE_CODE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IDX_SOURCE_ID] ON [dbo].[FACT_WAITING_LIST_ETL] 
(
	[SOURCE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_VISTA_SITE_ID] ON [dbo].[FACT_WAITING_LIST_ETL] 
(
	[VISTA_SITE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_WAITING_AREA_CODE] ON [dbo].[FACT_WAITING_LIST_ETL] 
(
	[WAITING_AREA_CODE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO