CREATE TABLE [dbo].[HOSPITAL_LOCATION_APPOINTMENT]
(
	[ID] [int] NOT NULL IDENTITY(1, 1),
	[DOMAIN_ID] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[HOSPITAL_LOCATION_UID] [uniqueidentifier] NOT NULL,
	[FACILITY_UID] [uniqueidentifier] NOT NULL,
	[VISTA_SITE_UID] [uniqueidentifier] NOT NULL,
	[_ssis_timestamp] [datetime] NULL CONSTRAINT [DF_HOSPITAL_LOCATION_APPOINTMENT__ssis_timestamp] DEFAULT (getdate()),
	[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[CREATED] [datetime] NULL,
	[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[UPDATED] [datetime] NULL
)
GO
-- Triggers

CREATE TRIGGER [dbo].[HOSPITAL_LOCATION_APPOINTMENT_tgg_ssis_delete] on [dbo].[HOSPITAL_LOCATION_APPOINTMENT] after delete as begin  delete [dbo].[HOSPITAL_LOCATION_APPOINTMENT_ssisdel] from [deleted] _xyz where [dbo].[HOSPITAL_LOCATION_APPOINTMENT_ssisdel].[ID]=[_xyz].[ID];  insert into [dbo].[HOSPITAL_LOCATION_APPOINTMENT_ssisdel]([ID], _ssis_timestamp)  select [ID], current_timestamp from [deleted];  end
GO
CREATE TRIGGER [dbo].[HOSPITAL_LOCATION_APPOINTMENT_tgg_ssis_insert] on [dbo].[HOSPITAL_LOCATION_APPOINTMENT] after insert as begin delete [dbo].[HOSPITAL_LOCATION_APPOINTMENT_ssisdel]  from [inserted] _xyz where [dbo].[HOSPITAL_LOCATION_APPOINTMENT_ssisdel].[ID]=[_xyz].[ID] end
GO
CREATE TRIGGER [dbo].[utg_HOSPITAL_LOCATION_APPOINTMENT_AfterDelete] 
   ON  [dbo].[HOSPITAL_LOCATION_APPOINTMENT] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')
     INSERT INTO $(varBMS_HISTORY).[dbo].[HOSPITAL_LOCATION_APPOINTMENT_H]
			   (ID, DOMAIN_ID, HOSPITAL_LOCATION_UID, FACILITY_UID, VISTA_SITE_UID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
		SELECT	ID, DOMAIN_ID, HOSPITAL_LOCATION_UID, FACILITY_UID, VISTA_SITE_UID, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()				
		FROM deleted;

END
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE TRIGGER [dbo].[utg_HOSPITAL_LOCATION_APPOINTMENT_AfterInsert] 
   ON  [dbo].[HOSPITAL_LOCATION_APPOINTMENT] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[HOSPITAL_LOCATION_APPOINTMENT_H]
			   (ID, DOMAIN_ID, HOSPITAL_LOCATION_UID, FACILITY_UID, VISTA_SITE_UID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
		SELECT	ID, DOMAIN_ID, HOSPITAL_LOCATION_UID, FACILITY_UID, VISTA_SITE_UID, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
		FROM inserted; 
END
GO
CREATE TRIGGER [dbo].[utg_HOSPITAL_LOCATION_APPOINTMENT_AfterUpdate] 
   ON  [dbo].[HOSPITAL_LOCATION_APPOINTMENT] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @PK INT, @SID VARCHAR(250), @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

	IF (UPPER(@HISTORY_VALUE) = 'Y')
		INSERT INTO $(varBMS_HISTORY).[dbo].[HOSPITAL_LOCATION_APPOINTMENT_H]
			   (ID, DOMAIN_ID, HOSPITAL_LOCATION_UID, FACILITY_UID, VISTA_SITE_UID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
		SELECT	ID, DOMAIN_ID, HOSPITAL_LOCATION_UID, FACILITY_UID, VISTA_SITE_UID, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
		FROM inserted;	


END
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TRIGGER [dbo].[utg_HOSPITAL_LOCATION_APPOINTMENT_InsteadOfInsert] 
   ON  [dbo].[HOSPITAL_LOCATION_APPOINTMENT]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')
		INSERT INTO [dbo].[HOSPITAL_LOCATION_APPOINTMENT]
			(DOMAIN_ID, HOSPITAL_LOCATION_UID, FACILITY_UID, VISTA_SITE_UID, _ssis_timestamp, CREATED, CREATEDBY)
		SELECT	DOMAIN_ID, HOSPITAL_LOCATION_UID, FACILITY_UID, VISTA_SITE_UID, _ssis_timestamp, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
		FROM inserted;
	ELSE
		INSERT INTO [dbo].[HOSPITAL_LOCATION_APPOINTMENT]
			(DOMAIN_ID, HOSPITAL_LOCATION_UID, FACILITY_UID, VISTA_SITE_UID, _ssis_timestamp)
		SELECT	DOMAIN_ID, HOSPITAL_LOCATION_UID, FACILITY_UID, VISTA_SITE_UID, _ssis_timestamp
		FROM inserted;

END
GO
CREATE TRIGGER [dbo].[utg_HOSPITAL_LOCATION_APPOINTMENT_InsteadOfUpdate] 
   ON  [dbo].[HOSPITAL_LOCATION_APPOINTMENT] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')
	 	UPDATE [dbo].[HOSPITAL_LOCATION_APPOINTMENT]
		SET DOMAIN_ID = inserted.DOMAIN_ID, 
			HOSPITAL_LOCATION_UID = inserted.HOSPITAL_LOCATION_UID, 
			FACILITY_UID = inserted.FACILITY_UID, 
			VISTA_SITE_UID = inserted.VISTA_SITE_UID, 
			_ssis_timestamp = current_timestamp,																
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE()
		FROM [dbo].[HOSPITAL_LOCATION_APPOINTMENT]
			INNER JOIN inserted ON inserted.ID = [dbo].[HOSPITAL_LOCATION_APPOINTMENT].ID;
	 ELSE
	    UPDATE [dbo].[HOSPITAL_LOCATION_APPOINTMENT]
		SET DOMAIN_ID = inserted.DOMAIN_ID, 
			HOSPITAL_LOCATION_UID = inserted.HOSPITAL_LOCATION_UID, 
			FACILITY_UID = inserted.FACILITY_UID, 
			VISTA_SITE_UID = inserted.VISTA_SITE_UID, 
			_ssis_timestamp = current_timestamp
		FROM [dbo].[HOSPITAL_LOCATION_APPOINTMENT]
			INNER JOIN inserted ON inserted.ID = [dbo].[HOSPITAL_LOCATION_APPOINTMENT].ID;

END
GO

-- Indexes
CREATE NONCLUSTERED INDEX [idx_ssis_modify] ON [dbo].[HOSPITAL_LOCATION_APPOINTMENT] ([_ssis_timestamp])
GO
CREATE NONCLUSTERED INDEX [IDX_HL_ID_FAC_ID] ON [dbo].[HOSPITAL_LOCATION_APPOINTMENT] 
(
	[HOSPITAL_LOCATION_UID] ASC,
	[FACILITY_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IDX_HL_FAC_VISTA_SITE] ON [dbo].[HOSPITAL_LOCATION_APPOINTMENT] 
(
	[VISTA_SITE_UID] ASC,
	[ID] ASC,
	[FACILITY_UID] ASC,
	[HOSPITAL_LOCATION_UID] ASC
)
INCLUDE ( [DOMAIN_ID]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

-- Constraints
ALTER TABLE [dbo].[HOSPITAL_LOCATION_APPOINTMENT] ADD CONSTRAINT [PK_HOSPITAL_LOCATION_APPOINTMENT] PRIMARY KEY CLUSTERED  ([ID])
GO

-- Extended Properties
EXEC sp_addextendedproperty N'MS_Description', N'The date and time when the row has been inserted or modified.', 'SCHEMA', N'dbo', 'TABLE', N'HOSPITAL_LOCATION_APPOINTMENT', 'COLUMN', N'_ssis_timestamp'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'HOSPITAL_LOCATION_APPOINTMENT', 'COLUMN', N'CREATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'HOSPITAL_LOCATION_APPOINTMENT', 'COLUMN', N'CREATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was changed(updated).', 'SCHEMA', N'dbo', 'TABLE', N'HOSPITAL_LOCATION_APPOINTMENT', 'COLUMN', N'UPDATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was updated.', 'SCHEMA', N'dbo', 'TABLE', N'HOSPITAL_LOCATION_APPOINTMENT', 'COLUMN', N'UPDATEDBY'
GO