CREATE TABLE [dbo].[BED_STAFF]
(
	[BED_UID] [uniqueidentifier] NOT NULL,
	[DIVISION_UID] [uniqueidentifier] NOT NULL,
	[STAFF] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[PATIENT_UID] [uniqueidentifier] NULL,
	[FACILITY_UID] [uniqueidentifier] NULL,
	[_ssis_timestamp] [datetime] NULL CONSTRAINT [DF_BED_STAFF__ssis_timestamp] DEFAULT (getdate()),
	[CREATEDBY] [nvarchar](50) NULL,
	[CREATED] [datetime] NULL,
	[UPDATEDBY] [nvarchar](50) NULL,
	[UPDATED] [datetime] NULL,
)
GO

CREATE trigger [dbo].[BED_STAFF_tgg_ssis_delete] on [dbo].[BED_STAFF] after delete as begin  delete [dbo].[BED_STAFF_ssisdel] from [deleted] _xyz where [dbo].[BED_STAFF_ssisdel].[BED_UID]=[_xyz].[BED_UID];  insert into [dbo].[BED_STAFF_ssisdel]([BED_UID], _ssis_timestamp)  select [BED_UID], current_timestamp from [deleted];  end
GO

CREATE trigger [dbo].[BED_STAFF_tgg_ssis_insert] on [dbo].[BED_STAFF] after insert as begin delete [dbo].[BED_STAFF_ssisdel]  from [inserted] _xyz where [dbo].[BED_STAFF_ssisdel].[BED_UID]=[_xyz].[BED_UID] end
GO

CREATE TRIGGER [dbo].[utg_BED_STAFF_AfterDelete] 
	ON  [dbo].[BED_STAFF] 
	AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

	SELECT @HISTORY_VALUE=PARAMETER_VALUE
	FROM dbo.Options
	WHERE UPPER(PARAMETER) = 'HISTORY';

	IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[BED_STAFF_H]
				(BED_UID, DIVISION_UID, STAFF, PATIENT_UID, FACILITY_UID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT BED_UID, DIVISION_UID, STAFF, PATIENT_UID, FACILITY_UID, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM deleted;
END
GO

CREATE TRIGGER [dbo].[utg_BED_STAFF_AfterInsert] 
	ON  [dbo].[BED_STAFF] 
	AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

	SELECT @HISTORY_VALUE=PARAMETER_VALUE
	FROM dbo.Options
	WHERE UPPER(PARAMETER) = 'HISTORY';

	IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[BED_STAFF_H]
				(BED_UID, DIVISION_UID, STAFF, PATIENT_UID, FACILITY_UID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT BED_UID, DIVISION_UID, STAFF, PATIENT_UID, FACILITY_UID, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
END
GO

CREATE TRIGGER [dbo].[utg_BED_STAFF_AfterUpdate] 
	ON  [dbo].[BED_STAFF] 
	AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

	SELECT @HISTORY_VALUE=PARAMETER_VALUE
	FROM dbo.Options
	WHERE PARAMETER = 'HISTORY';

	IF (UPPER(@HISTORY_VALUE) = 'Y')
	 	INSERT INTO $(varBMS_HISTORY).[dbo].[BED_STAFF_H]
				(BED_UID, DIVISION_UID, STAFF, PATIENT_UID, FACILITY_UID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT BED_UID, DIVISION_UID, STAFF, PATIENT_UID, FACILITY_UID, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
END
GO
	
CREATE TRIGGER [dbo].[utg_BED_STAFF_InsteadOfInsert] 
	ON  [dbo].[BED_STAFF]
	INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';

	IF (UPPER(@AUDIT_VALUE) = 'Y')
 		INSERT INTO [dbo].[BED_STAFF]
				(BED_UID, DIVISION_UID, STAFF, PATIENT_UID, FACILITY_UID, _ssis_timestamp, CREATED, CREATEDBY)
			SELECT BED_UID, DIVISION_UID, STAFF, PATIENT_UID, FACILITY_UID, _ssis_timestamp, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;		
	ELSE
	 		INSERT INTO [dbo].[BED_STAFF]
				(BED_UID, DIVISION_UID, STAFF, PATIENT_UID, FACILITY_UID, _ssis_timestamp)
			SELECT BED_UID, DIVISION_UID, STAFF, PATIENT_UID, FACILITY_UID, _ssis_timestamp
				FROM inserted;	
END
GO

CREATE TRIGGER [dbo].[utg_BED_STAFF_InsteadOfUpdate] 
   ON  [dbo].[BED_STAFF] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')
		UPDATE [dbo].[BED_STAFF]
		SET DIVISION_UID = inserted.DIVISION_UID,
			STAFF = inserted.STAFF,
			PATIENT_UID = inserted.PATIENT_UID, 
			FACILITY_UID = inserted.FACILITY_UID, 
			_ssis_timestamp = current_timestamp,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE()
		FROM [dbo].[BED_STAFF]
			INNER JOIN inserted ON inserted.BED_UID = [dbo].[BED_STAFF].BED_UID;	
	ELSE
		UPDATE [dbo].[BED_STAFF]
		SET DIVISION_UID = inserted.DIVISION_UID,
			STAFF = inserted.STAFF,
			PATIENT_UID = inserted.PATIENT_UID, 
			FACILITY_UID = inserted.FACILITY_UID, 
			_ssis_timestamp = current_timestamp
		FROM [dbo].[BED_STAFF]
			INNER JOIN inserted ON inserted.BED_UID = [dbo].[BED_STAFF].BED_UID;
			
END
GO

--Constraints
ALTER TABLE [dbo].[BED_STAFF] ADD CONSTRAINT [PK_BED_STAFF] PRIMARY KEY CLUSTERED  ([BED_UID])
GO

--Indexes
CREATE NONCLUSTERED INDEX [IDX_BED_UID] ON [dbo].[BED_STAFF] 
(
	[BED_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_SSIS_MODIFY] ON [dbo].[BED_STAFF] 
(
	[_ssis_timestamp] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

--Extended properties
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The bed id.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_STAFF', @level2type=N'COLUMN',@level2name=N'BED_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The division id.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_STAFF', @level2type=N'COLUMN',@level2name=N'DIVISION_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Bed staff name.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_STAFF', @level2type=N'COLUMN',@level2name=N'STAFF'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the patient.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_STAFF', @level2type=N'COLUMN',@level2name=N'PATIENT_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the faciity.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_STAFF', @level2type=N'COLUMN',@level2name=N'FACILITY_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the row has been inserted or modified.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_STAFF', @level2type=N'COLUMN',@level2name=N'_ssis_timestamp'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table that contains bed staff names and related information. ' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_STAFF'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The User ID of the user who created the record.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_STAFF', @level2type=N'COLUMN',@level2name=N'CREATEDBY'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the record was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_STAFF', @level2type=N'COLUMN',@level2name=N'CREATED'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The User ID of the user who updated the record.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_STAFF', @level2type=N'COLUMN',@level2name=N'UPDATEDBY'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the record was edited.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_STAFF', @level2type=N'COLUMN',@level2name=N'UPDATED'
GO