CREATE TABLE [dbo].[POLICY]
(
[PERMISSION_ID] [uniqueidentifier] NOT NULL,
[ROLE_ID] [uniqueidentifier] NOT NULL,
[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL
) ON [PRIMARY]
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Policy_AfterDelete] 
   ON  [dbo].[POLICY] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)
	
	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[Policy_H]
			   (PERMISSION_ID, ROLE_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT PERMISSION_ID, ROLE_ID, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM deleted;
	 		
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Policy_AfterInsert] 
   ON  [dbo].[POLICY] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[Policy_H]
			   (PERMISSION_ID, ROLE_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT PERMISSION_ID, ROLE_ID, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
     
	
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Policy_AfterUpdate] 
   ON  [dbo].[POLICY] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
	    
	IF (UPPER(@HISTORY_VALUE) = 'Y')
	 	INSERT INTO $(varBMS_HISTORY).[dbo].[Policy_H]
			   (PERMISSION_ID, ROLE_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT PERMISSION_ID, ROLE_ID, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_Policy_InsteadOfInsert] 
   ON  [dbo].[POLICY]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
     	INSERT INTO [dbo].[Policy]
			   (PERMISSION_ID, ROLE_ID, CREATED, CREATEDBY)
			SELECT PERMISSION_ID, ROLE_ID, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			  FROM inserted;
	    
	 
	ELSE
		INSERT INTO [dbo].[Policy]
			   (PERMISSION_ID, ROLE_ID)
			SELECT PERMISSION_ID, ROLE_ID
			  FROM inserted;
	
END
GO

--Constraints
ALTER TABLE [dbo].[POLICY] ADD CONSTRAINT [PK_POLICY1] PRIMARY KEY CLUSTERED  ([PERMISSION_ID], [ROLE_ID]) ON [PRIMARY]
GO
ALTER TABLE [dbo].[POLICY] WITH NOCHECK ADD CONSTRAINT [FK_POLICY_PERMISSION] FOREIGN KEY ([PERMISSION_ID]) REFERENCES [dbo].[PERMISSION] ([ID]) NOT FOR REPLICATION
GO
ALTER TABLE [dbo].[POLICY] WITH NOCHECK ADD CONSTRAINT [FK_POLICY_ROLE] FOREIGN KEY ([ROLE_ID]) REFERENCES [dbo].[ROLE] ([ID]) NOT FOR REPLICATION
GO
ALTER TABLE [dbo].[POLICY] NOCHECK CONSTRAINT [FK_POLICY_PERMISSION]
GO
ALTER TABLE [dbo].[POLICY] NOCHECK CONSTRAINT [FK_POLICY_ROLE]
GO

--Indexes
CREATE NONCLUSTERED INDEX [IDX_ROLE_POLICY] ON [dbo].[POLICY] 
(
	[ROLE_ID] ASC,
	[PERMISSION_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

--Extended properties
EXEC sp_addextendedproperty N'MS_Description', N'Table that contains permission policies.', 'SCHEMA', N'dbo', 'TABLE', N'POLICY', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'POLICY', 'COLUMN', N'CREATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'POLICY', 'COLUMN', N'CREATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the permission that is been associated to the role.', 'SCHEMA', N'dbo', 'TABLE', N'POLICY', 'COLUMN', N'PERMISSION_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the role that is been associated to the permission.', 'SCHEMA', N'dbo', 'TABLE', N'POLICY', 'COLUMN', N'ROLE_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was changed(updated).', 'SCHEMA', N'dbo', 'TABLE', N'POLICY', 'COLUMN', N'UPDATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was updated.', 'SCHEMA', N'dbo', 'TABLE', N'POLICY', 'COLUMN', N'UPDATEDBY'
GO
