CREATE TABLE [dbo].[CONFIG]
(
[ID] [int] NOT NULL IDENTITY(1, 1),
[DOMAIN_ID] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL CONSTRAINT [DF_Config_DOMAIN] DEFAULT (N'InfoWorld'),
[USER_NAME] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL CONSTRAINT [DF_Config_UserName] DEFAULT (' '),
[SECTION] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[CONFIG_KEY] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[CONFIG_VALUE] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CONFIG_TYPE] [nvarchar] (10) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[VALUE_TYPE] [varchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[FRIENDLY_NAME] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Config_AfterDelete] 
   ON  [dbo].[CONFIG] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)
	
	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[Config_H]
			   (ID, DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM deleted;
		
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Config_AfterInsert] 
   ON  [dbo].[CONFIG] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[Config_H]
			   (ID, DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
      
	
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Config_AfterUpdate] 
   ON  [dbo].[CONFIG] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
    
	IF (UPPER(@HISTORY_VALUE) = 'Y')
	    INSERT INTO $(varBMS_HISTORY).[dbo].[Config_H]
			   (ID, DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_Config_InsteadOfInsert] 
   ON  [dbo].[CONFIG]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
     INSERT INTO [dbo].[Config]
			   (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME, CREATED, CREATEDBY)
			SELECT DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			  FROM inserted;
	
	ELSE
		INSERT INTO [dbo].[Config]
			   (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			SELECT DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME
			  FROM inserted;
	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_Config_InsteadOfUpdate] 
   ON  [dbo].[CONFIG] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
	 	UPDATE [dbo].[Config]
		SET DOMAIN_ID = inserted.DOMAIN_ID,
			USER_NAME = inserted.USER_NAME,
			SECTION = inserted.SECTION,
			CONFIG_KEY = inserted.CONFIG_KEY,
			CONFIG_VALUE = inserted.CONFIG_VALUE,
			CONFIG_TYPE = inserted.CONFIG_TYPE,
			VALUE_TYPE = inserted.VALUE_TYPE,
			FRIENDLY_NAME = inserted.FRIENDLY_NAME,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE()
		FROM [dbo].[Config]
		INNER JOIN inserted ON inserted.id = [dbo].[Config].id;     
	
	 ELSE
	    UPDATE [dbo].[Config]
		SET DOMAIN_ID = inserted.DOMAIN_ID,
			USER_NAME = inserted.USER_NAME,
			SECTION = inserted.SECTION,
			CONFIG_KEY = inserted.CONFIG_KEY,
			CONFIG_VALUE = inserted.CONFIG_VALUE,
			CONFIG_TYPE = inserted.CONFIG_TYPE,
			VALUE_TYPE = inserted.VALUE_TYPE,
			FRIENDLY_NAME = inserted.FRIENDLY_NAME
		FROM [dbo].[Config]
		INNER JOIN inserted ON inserted.id = [dbo].[Config].id;

END
GO

--Constraints
ALTER TABLE [dbo].[CONFIG] ADD CONSTRAINT [PK_CONFIG] PRIMARY KEY CLUSTERED  ([ID]) ON [PRIMARY]
GO

--Indexes
CREATE NONCLUSTERED INDEX [IDX_DOMAIN_ID_CONFIG_TYPE] ON [dbo].[CONFIG] 
(
	[DOMAIN_ID] ASC,
	[CONFIG_TYPE] ASC
)
INCLUDE ( [ID],
[CONFIG_VALUE],
[VALUE_TYPE],
[FRIENDLY_NAME],
[USER_NAME],
[SECTION],
[CONFIG_KEY]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

--Extended properties
EXEC sp_addextendedproperty N'MS_Description', N'Configuration table.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'Configuration key column.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG', 'COLUMN', N'CONFIG_KEY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Type of the configuration.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG', 'COLUMN', N'CONFIG_TYPE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The value associated to the configuration key.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG', 'COLUMN', N'CONFIG_VALUE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG', 'COLUMN', N'CREATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG', 'COLUMN', N'CREATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Domain''s id.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG', 'COLUMN', N'DOMAIN_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'A friendly name for the configuration.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG', 'COLUMN', N'FRIENDLY_NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Configuration''s id.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Section name.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG', 'COLUMN', N'SECTION'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was changed(updated).', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG', 'COLUMN', N'UPDATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was updated.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG', 'COLUMN', N'UPDATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User name.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG', 'COLUMN', N'USER_NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The value type.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG', 'COLUMN', N'VALUE_TYPE'
GO
