USE [BMS]
GO
/****** Object:  StoredProcedure [dbo].[usp_Filter_Bed_Information]    Script Date: 9/7/2017 3:09:05 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		silvicap
-- Create date: 30.11.2011
-- Description:	Filter bed information.
-- =============================================
-- =============================================
-- Update by:	mihaia
-- Update date: 5/29/2012
-- Description:	Optimizations.
-- =============================================
-- =============================================
-- Update by:	silvicap
-- Update date: 25.10.2012
-- Description:	Separated orders from acts. 
-- =============================================

ALTER PROCEDURE [dbo].[usp_Filter_Bed_Information] 	
	@WARD_LIST NVARCHAR(MAX),
	@FACILITY_UID UNIQUEIDENTIFIER
AS
BEGIN
SET NOCOUNT ON				
		
		CREATE TABLE #WARDS(WARD_UID UNIQUEIDENTIFIER PRIMARY KEY)
		INSERT INTO #WARDS(WARD_UID)
		SELECT WARD.VALUE
		FROM dbo.fn_Split(@WARD_LIST, ',') AS WARD 
		
		CREATE TABLE #BED_CLEAN(ID INT PRIMARY KEY, DOMAIN_ID NVARCHAR(50), BED_UID UNIQUEIDENTIFIER, WARD_UID UNIQUEIDENTIFIER, EVENT_IEN NVARCHAR(50))
		INSERT INTO #BED_CLEAN(ID, DOMAIN_ID, BED_UID, WARD_UID, EVENT_IEN)
		SELECT BC.ID, BC.DOMAIN_ID, BC.BED_UID, BC.WARD_UID, BC.EVENT_IEN
		FROM BED_CLEAN AS BC
		INNER JOIN (SELECT MAX(CLN.ID) AS ID, CLN.BED_UID
					 FROM BED_CLEAN CLN
					 INNER JOIN #WARDS AS WARD ON WARD.WARD_UID = CLN.WARD_UID
					 GROUP BY BED_UID) MAX_BED_CLEAN 
					 ON MAX_BED_CLEAN.BED_UID = BC.BED_UID AND MAX_BED_CLEAN.ID = BC.ID
		WHERE BC.REQUESTED_DATE >= DATEADD(HH, -72, GETUTCDATE()) AND (BC.COMPLETED_DATE IS NULL OR BC.COMPLETED_DATE >= DATEADD(HH, -2, GETUTCDATE())) 				
		
		CREATE NONCLUSTERED INDEX [IDX_BED_UID] ON [#BED_CLEAN] (BED_UID ASC) INCLUDE (ID)
		CREATE NONCLUSTERED INDEX [IDX_BED_UID_EVENT_IEN] ON [#BED_CLEAN] (BED_UID ASC, EVENT_IEN ASC) INCLUDE (ID, DOMAIN_ID, WARD_UID)
														
		CREATE TABLE #BED_OCCUPANCY_INFORMATION 
			(ACT_ID INT,			
			FLOW_ID UNIQUEIDENTIFIER,
			DOMAIN_ID NVARCHAR(50),
			PATIENT_UID UNIQUEIDENTIFIER,	
			BED_UID UNIQUEIDENTIFIER,
			BED_CLEAN_ID INT,
			BED_UNAVAILABLE_ID INT,			
			WARD_UID UNIQUEIDENTIFIER, 
			MOVEMENT_DATE DATETIME,
			ADMISSION_DATE DATETIME,
			DISCHARGE_ORDER_TEXT NVARCHAR(MAX),
			DISCHARGE_REQ_ID INT,
			IS_VACATED BIT,
			INTERWARD_TRANSFER INT,
			LEVEL_OF_CARE NVARCHAR(50),
			LEVEL_OF_CARE_DATE DATETIME,
			LEVEL_OF_CARE_CHANGE_DATE DATETIME)
			
		CREATE TABLE #VACATED_BED
			(ACT_ID INT,			
			FLOW_ID UNIQUEIDENTIFIER,
			DOMAIN_ID NVARCHAR(50),
			PATIENT_UID UNIQUEIDENTIFIER,	
			BED_UID UNIQUEIDENTIFIER,
			BED_CLEAN_ID INT,
			BED_UNAVAILABLE_ID INT,			
			WARD_UID UNIQUEIDENTIFIER, 
			MOVEMENT_DATE DATETIME,
			ADMISSION_DATE DATETIME,
			DISCHARGE_ORDER_TEXT NVARCHAR(MAX),
			DISCHARGE_REQ_ID INT,
			IS_VACATED BIT,
			INTERWARD_TRANSFER INT,
			LEVEL_OF_CARE NVARCHAR(50),
			LEVEL_OF_CARE_DATE DATETIME,
			LEVEL_OF_CARE_CHANGE_DATE DATETIME)			

		CREATE TABLE #ACTIVE_ADMISSION(
			ADMISSION_ID INT NOT NULL PRIMARY KEY,
			CREATED_DATE DATETIME NULL)
		
		CREATE TABLE #ADMISSION_AND_TRANSFER(
			ADMISSION_ID INT NOT NULL,
			BED_UID UNIQUEIDENTIFIER,
			CREATED_DATE DATETIME NULL,
			IS_ADMISSION_EVN BIT)
			
		--GET ACTIVE ADMISSION
		--If more patients were admitted in the same bed on the whiteboard is displayed last patient admitted
		CREATE CLUSTERED INDEX [IDX_ADMISSION_ID] ON [#ADMISSION_AND_TRANSFER] (ADMISSION_ID)
		CREATE NONCLUSTERED INDEX [IDX_BED_UID] ON [#ADMISSION_AND_TRANSFER] (BED_UID ASC) INCLUDE (CREATED_DATE) 
		CREATE NONCLUSTERED INDEX [IDX_BED_UID_CREATION_DATE] ON [#ADMISSION_AND_TRANSFER] (BED_UID ASC , CREATED_DATE ASC) INCLUDE (ADMISSION_ID)
		
		INSERT INTO #ADMISSION_AND_TRANSFER(ADMISSION_ID, BED_UID, CREATED_DATE, IS_ADMISSION_EVN)
		SELECT ADM_EVN.ID, ADM_EVN.BED_UID, ADM_EVN.ADMISSION_DATE, 1
		FROM ADMISSION_EVN AS ADM_EVN
		INNER JOIN #WARDS AS WARD ON WARD.WARD_UID = ADM_EVN.WARD_UID
		WHERE ADM_EVN.HAS_DISCHARGE = 0

		INSERT INTO #ADMISSION_AND_TRANSFER(ADMISSION_ID, BED_UID, CREATED_DATE, IS_ADMISSION_EVN)
		SELECT MOV_EVN.ADMISSION_ID, MOV_EVN.BED_UID, MOV_EVN.MOVEMENT_DATE, 0
		FROM MOVEMENT_EVN AS MOV_EVN
		INNER JOIN (SELECT MAX(LAST_MOV_EVN.MOVEMENT_DATE) AS MOVEMENT_DATE, LAST_MOV_EVN.ADMISSION_ID
					FROM MOVEMENT_EVN LAST_MOV_EVN
					INNER JOIN #ADMISSION_AND_TRANSFER AS ADM_EVN ON ADM_EVN.ADMISSION_ID = LAST_MOV_EVN.ADMISSION_ID
					GROUP BY LAST_MOV_EVN.ADMISSION_ID) MAX_ME_EVENT 
					ON MAX_ME_EVENT.MOVEMENT_DATE = MOV_EVN.MOVEMENT_DATE AND MAX_ME_EVENT.ADMISSION_ID = MOV_EVN.ADMISSION_ID
					
		DELETE DEL FROM #ADMISSION_AND_TRANSFER AS DEL
		INNER JOIN #ADMISSION_AND_TRANSFER AS ADM ON ADM.ADMISSION_ID = DEL.ADMISSION_ID AND ADM.BED_UID <> DEL.BED_UID AND ADM.IS_ADMISSION_EVN = 1
		WHERE DEL.IS_ADMISSION_EVN = 0

		INSERT INTO #ACTIVE_ADMISSION(ADMISSION_ID, CREATED_DATE)
		SELECT DISTINCT ADMISSION_INFO.ADMISSION_ID, ADMISSION_INFO.CREATED_DATE
		FROM #ADMISSION_AND_TRANSFER AS ADMISSION_INFO
		INNER JOIN 
		(   SELECT MAX(CREATED_DATE) AS CREATED_DATE, BED_UID
			FROM #ADMISSION_AND_TRANSFER
			GROUP BY BED_UID
		) LAST_ADMISISON_INFO ON LAST_ADMISISON_INFO.CREATED_DATE = ADMISSION_INFO.CREATED_DATE AND LAST_ADMISISON_INFO.BED_UID = ADMISSION_INFO.BED_UID

		DROP TABLE #ADMISSION_AND_TRANSFER
		
		INSERT INTO #BED_OCCUPANCY_INFORMATION (
			ACT_ID,
			FLOW_ID,
			DOMAIN_ID,
			PATIENT_UID,
			BED_UID,
			BED_CLEAN_ID,
			BED_UNAVAILABLE_ID,			
			WARD_UID,
			MOVEMENT_DATE,
			ADMISSION_DATE,
			DISCHARGE_ORDER_TEXT,
			DISCHARGE_REQ_ID,
			INTERWARD_TRANSFER,
			LEVEL_OF_CARE,
			LEVEL_OF_CARE_DATE,
			LEVEL_OF_CARE_CHANGE_DATE)
		SELECT 			
			[AE].[ID],			
			NULL,
			[AE].[DOMAIN_ID],
			[AE].[PATIENT_UID],
			[AE].[BED_UID],
			[BC].[ID],
			[BU].[ACT_ID],		
			[AE].[WARD_UID],
			[ADM_EVN].[CREATED_DATE] AS [MOVEMENT_DATE],
		    [AE].[ADMISSION_DATE] AS ADMISSION_DATE,
			CASE 
				WHEN DREQ.ID IS NOT NULL THEN 'DISCHARGE ORDER'
				WHEN ADREQ.ID IS NOT NULL 
					  AND ( ( ADREQ.ORDER_TEXT LIKE '%ANTICIPATE%' OR ADREQ.ORDER_TEXT LIKE '%PLANNED%') AND
							(ADREQ.ORDER_TEXT LIKE '%DISCHARGE%') )
					  THEN 'ANTICIPATED DISCHARGE ORDER'
				WHEN DI.ID IS NOT NULL THEN 'DISCHARGE APPOINTMENT'
				ELSE NULL
			END,
			CASE 
				WHEN DREQ.ID IS NOT NULL THEN DREQ.ID
				WHEN DREQ.ID IS NULL AND ADREQ.ID IS NOT NULL THEN ADREQ.ID
				ELSE NULL
			END,
			CASE 
				WHEN DREQ.ID IS NULL AND ADREQ.ID IS NULL AND MR.ID IS NOT NULL THEN MR.ID
				ELSE  NULL
			END	AS INTERWARD_TRANSFER,			
			[ALOC].[LEVEL_OF_CARE] AS LEVEL_OF_CARE,
			[ALOC].[CREATION_DATE] AS LEVEL_OF_CARE_DATE,
			[ALOC].[LEVEL_OF_CARE_CHANGE_DATE] AS LEVEL_OF_CARE_CHANGE_DATE
		FROM ADMISSION_EVN AS AE
			INNER JOIN #ACTIVE_ADMISSION AS ADM_EVN ON ADM_EVN.ADMISSION_ID = AE.ID
			LEFT JOIN ADMISSION_LEVEL_OF_CARE AS ALOC ON AE.ID = ALOC.ADMISSION_ID					
			LEFT JOIN #BED_CLEAN AS BC ON BC.BED_UID = AE.BED_UID   
			LEFT JOIN BED_UNAVAILABLE AS BU ON BU.BED_UID = AE.BED_UID AND BU.COMPLETED_DATE IS NULL
			
			LEFT JOIN (SELECT MAX(CAST(M_REQ.IEN as BIGINT)) AS IEN, M_REQ.PATIENT_UID, M_REQ.WARD_UID, M_REQ.VISTA_SITE_UID
					   FROM MOVEMENT_REQ AS M_REQ
					   INNER JOIN ORDER_FACILITY AS O_FAC ON M_REQ.ID = O_FAC.ORDER_ID AND O_FAC.FACILITY_UID = @FACILITY_UID AND O_FAC.ORDER_TYPE ='TRA'
					   WHERE M_REQ.IS_ACTIVE = 1
					   GROUP BY M_REQ.PATIENT_UID, M_REQ.WARD_UID,  M_REQ.VISTA_SITE_UID) MAX_MR_ORDER 
					   ON AE.VISTA_SITE_UID = MAX_MR_ORDER.VISTA_SITE_UID AND  AE.WARD_UID = MAX_MR_ORDER.WARD_UID AND AE.PATIENT_UID = MAX_MR_ORDER.PATIENT_UID
			LEFT JOIN MOVEMENT_REQ AS MR ON MAX_MR_ORDER.IEN = CAST(MR.IEN AS BIGINT) AND MAX_MR_ORDER.VISTA_SITE_UID = MR.VISTA_SITE_UID		
			
			LEFT JOIN (SELECT MAX(CAST(D_REQ.IEN as BIGINT)) AS IEN, D_REQ.PATIENT_UID, D_REQ.WARD_UID, D_REQ.VISTA_SITE_UID
					   FROM DISCHARGE_REQ AS D_REQ
					   INNER JOIN ORDER_FACILITY AS O_FAC ON D_REQ.ID = O_FAC.ORDER_ID AND O_FAC.FACILITY_UID = @FACILITY_UID AND O_FAC.ORDER_TYPE ='DIS'
					   WHERE D_REQ.IS_ACTIVE = 1 AND D_REQ.ORDERABLE_ITEM_ID IS NOT NULL
					   GROUP BY D_REQ.PATIENT_UID, D_REQ.WARD_UID, D_REQ.VISTA_SITE_UID) MAX_DR_ORDER 
					   ON AE.WARD_UID = MAX_DR_ORDER.WARD_UID AND 
						  AE.PATIENT_UID = MAX_DR_ORDER.PATIENT_UID AND
						  AE.VISTA_SITE_UID = MAX_DR_ORDER.VISTA_SITE_UID
			LEFT JOIN DISCHARGE_REQ AS DREQ ON MAX_DR_ORDER.IEN = CAST(DREQ.IEN AS BIGINT) AND MAX_DR_ORDER.VISTA_SITE_UID = DREQ.VISTA_SITE_UID
			
			LEFT JOIN (SELECT MAX(CAST(D_REQ.IEN as BIGINT)) AS IEN, D_REQ.PATIENT_UID, D_REQ.WARD_UID, D_REQ.VISTA_SITE_UID
					   FROM DISCHARGE_REQ AS D_REQ
					   INNER JOIN ORDER_FACILITY AS O_FAC ON D_REQ.ID = O_FAC.ORDER_ID AND O_FAC.FACILITY_UID = @FACILITY_UID AND O_FAC.ORDER_TYPE ='DIS'
					   WHERE D_REQ.IS_ACTIVE = 1 AND D_REQ.ORDERABLE_ITEM_ID is null
					   GROUP BY D_REQ.PATIENT_UID, D_REQ.WARD_UID, D_REQ.VISTA_SITE_UID) MAX_ADR_ORDER 
					   ON AE.WARD_UID = MAX_ADR_ORDER.WARD_UID AND 
						  AE.PATIENT_UID = MAX_ADR_ORDER.PATIENT_UID AND
						  AE.VISTA_SITE_UID = MAX_ADR_ORDER.VISTA_SITE_UID
			LEFT JOIN DISCHARGE_REQ AS ADREQ ON MAX_ADR_ORDER.IEN = CAST(ADREQ.IEN AS BIGINT) AND MAX_ADR_ORDER.VISTA_SITE_UID = ADREQ.VISTA_SITE_UID
			
			LEFT JOIN (SELECT MAX(D_INT.APPOINTMENT_DATE) AS APPOINTMENT_DATE, D_INT.PATIENT_UID, D_INT.WARD_UID, D_INT.VISTA_SITE_UID
					   FROM DISCHARGE_INT AS D_INT 
					   INNER JOIN HOSPITAL_LOCATION_APPOINTMENT AS HLA ON D_INT.HOSPITAL_LOCATION_UID = HLA.HOSPITAL_LOCATION_UID AND HLA.FACILITY_UID = @FACILITY_UID
					   WHERE D_INT.APPOINTMENT_DATE > GETUTCDATE() AND 
							 D_INT.STATUS NOT LIKE '%CANCELLED%' AND D_INT.STATUS NOT LIKE '%DISCONTINUED%' AND 
							 D_INT.STATUS NOT LIKE '%COMPLETE%' AND D_INT.IS_ACTIVE = 1 
					   GROUP BY D_INT.PATIENT_UID, D_INT.WARD_UID, D_INT.VISTA_SITE_UID) MAX_DI_APPOIMENT 
					   ON AE.WARD_UID = MAX_DI_APPOIMENT.WARD_UID AND 
						  AE.PATIENT_UID = MAX_DI_APPOIMENT.PATIENT_UID AND
						  AE.VISTA_SITE_UID = MAX_DI_APPOIMENT.VISTA_SITE_UID AND
						  AE.ADMISSION_DATE < MAX_DI_APPOIMENT.APPOINTMENT_DATE					  
			LEFT JOIN DISCHARGE_INT AS DI ON MAX_DI_APPOIMENT.APPOINTMENT_DATE = DI.APPOINTMENT_DATE AND MAX_DI_APPOIMENT.PATIENT_UID = DI.PATIENT_UID	AND DI.VISTA_SITE_UID = MAX_DI_APPOIMENT.VISTA_SITE_UID											
		
		DROP TABLE #ACTIVE_ADMISSION
				
		UPDATE #BED_OCCUPANCY_INFORMATION
		SET DISCHARGE_ORDER_TEXT = ' '
			WHERE DISCHARGE_REQ_ID IS NOT NULL AND (DISCHARGE_ORDER_TEXT IS NULL OR LEN(DISCHARGE_ORDER_TEXT) = 0)
			
		CREATE NONCLUSTERED INDEX [IDX_BED_UID] ON [#BED_OCCUPANCY_INFORMATION] (BED_UID ASC)
		
		DECLARE @MAX_BU TABLE (ACT_ID INT, BED_UID UNIQUEIDENTIFIER, PRIMARY KEY (ACT_ID), UNIQUE CLUSTERED (BED_UID))
		INSERT INTO @MAX_BU(ACT_ID, BED_UID)
		SELECT MAX(BU.ACT_ID) AS ACT_ID, BU.BED_UID
		FROM BED_UNAVAILABLE AS BU 
		INNER JOIN BED_UNAVAILABLE_WARD AS BUW ON BUW.BED_UNAVAILABLE_ID = BU.ACT_ID
		INNER JOIN #WARDS AS WARD ON WARD.WARD_UID = BUW.WARD_UID
		WHERE BU.COMPLETED_DATE IS NULL
		GROUP BY BU.BED_UID				

		INSERT INTO #VACATED_BED 
			(ACT_ID, 
			DOMAIN_ID,
			BED_UID,
			BED_CLEAN_ID,
			BED_UNAVAILABLE_ID,
			WARD_UID, 		
			IS_VACATED)
		SELECT DISTINCT
			ISNULL(DEVN.ID, BC.ID), 
			ISNULL(DEVN.DOMAIN_ID, BC.DOMAIN_ID),
			BC.BED_UID, 
			BC.ID AS BED_CLEAN_ID,
			BU.ACT_ID, 
			BC.WARD_UID,
			1
		FROM #BED_CLEAN AS BC
			LEFT OUTER JOIN #BED_OCCUPANCY_INFORMATION AS BO ON BC.BED_UID = BO.BED_UID			
			LEFT JOIN @MAX_BU AS BU ON BU.BED_UID = BC.BED_UID																		
			LEFT JOIN (SELECT BED_UID , VISTA_SITE_UID, MAX(CAST(IEN AS BIGINT)) AS MAX_DE_IEN 
						FROM DISCHARGE_EVN 
						GROUP BY BED_UID, VISTA_SITE_UID) DA ON DA.BED_UID = BC.BED_UID AND BC.EVENT_IEN = DA.MAX_DE_IEN
			LEFT JOIN DISCHARGE_EVN AS DEVN ON CAST(DEVN.IEN AS BIGINT) = DA.MAX_DE_IEN AND DEVN.VISTA_SITE_UID = DA.VISTA_SITE_UID
		WHERE BO.BED_UID IS NULL
		
		CREATE NONCLUSTERED INDEX [IDX_BED_UID] ON [#VACATED_BED] (BED_UID ASC)
			 
		INSERT INTO #VACATED_BED 
			(ACT_ID, 
			FLOW_ID, 
			DOMAIN_ID,
			BED_UID,			
			BED_UNAVAILABLE_ID)
		SELECT DACT.ID, 
			DACT.FLOW_ID, 
			DACT.DOMAIN_ID, 
			BU.BED_UID, 				
			BU.ACT_ID 				
		FROM @MAX_BU AS BU
			INNER JOIN ACT AS DACT ON DACT.ID = BU.ACT_ID					
			LEFT OUTER JOIN #BED_OCCUPANCY_INFORMATION AS BO ON BU.BED_UID = BO.BED_UID
			LEFT OUTER JOIN #VACATED_BED AS VB ON BU.BED_UID = VB.BED_UID
		WHERE BO.BED_UID IS NULL AND VB.BED_UID IS NULL 				
		
		SELECT DISTINCT RESULT.ACT_ID AS ACT_ID,				
				RESULT.FLOW_ID AS FLOW_ID,
				RESULT.DOMAIN_ID AS DOMAIN_ID,				
				RESULT.PATIENT_UID AS PATIENT_UID,
				RESULT.BED_UID AS EVN_BED_UID,
				RESULT.WARD_UID AS EVN_WARD_UID,									
				BC.REQUESTED_DATE AS BED_CLEAN_REQUESTED_DATE,
				BC.ACCEPTED_DATE AS BED_CLEAN_ACCEPTED_DATE,
				BC.COMPLETED_DATE AS BED_CLEAN_COMPLETED_DATE,	
				BOOSS.CODE AS BED_AVAILABILITY_STATUS,				
				BOOSR.DISPLAY_NAME AS REASON,				
				BU.IS_UNAVAILABLE_FROM_VISTA AS IS_UNAVAILABLE_FROM_VISTA,
				RESULT.DISCHARGE_ORDER_TEXT AS	DISCHARGE_ORDER_TEXT,
				RESULT.MOVEMENT_DATE AS MOVEMENT_DATE,
				RESULT.IS_VACATED AS IS_VACATED,
				RESULT.INTERWARD_TRANSFER,
				RESULT.ADMISSION_DATE AS ADMISSION_DATE,
				RESULT.LEVEL_OF_CARE AS LEVEL_OF_CARE,
				RESULT.LEVEL_OF_CARE_DATE AS LEVEL_OF_CARE_DATE,
				RESULT.LEVEL_OF_CARE_CHANGE_DATE AS LEVEL_OF_CARE_CHANGE_DATE,
				ICON_FLAG_IDS_OF_BED = STUFF( (SELECT ',' + CAST(ICON_FLAG_ID AS NVARCHAR(10))
								 FROM ICON_ASSOCIATION
								 WHERE BED_UID = RESULT.BED_UID AND ICON_FLAG_ID IS NOT NULL
								 FOR XML PATH('')), 
								1, 1, ''),
				ICON_FLAG_IDS_OF_PATIENT = STUFF( (SELECT ',' + CAST(ICON_FLAG_ID AS NVARCHAR(10))
								 FROM ICON_ASSOCIATION
								 WHERE PATIENT_UID = RESULT.PATIENT_UID AND ICON_FLAG_ID IS NOT NULL
								 FOR XML PATH('')), 1, 1, ''),
				ICON_FLAG_FACILITY_IDS_OF_BED = STUFF( (SELECT ',' + CAST(IFF.ICON_FLAG_ID AS NVARCHAR(10))
								 FROM ICON_ASSOCIATION AS ICON_ASSOC_OF_BED
								 INNER JOIN ICON_FLAG_FACILITY AS IFF ON IFF.ID = ICON_ASSOC_OF_BED.ICON_FLAG_FACILITY_ID
								 WHERE IFF.FACILITY_UID = @FACILITY_UID AND ICON_ASSOC_OF_BED.BED_UID = RESULT.BED_UID AND ICON_ASSOC_OF_BED.ICON_FLAG_FACILITY_ID IS NOT NULL
								 FOR XML PATH('')), 1, 1, ''),
				ICON_FLAG_FACILITY_IDS_OF_PATIENT = STUFF( (SELECT ',' + CAST(IFF.ICON_FLAG_ID AS NVARCHAR(10))
								 FROM ICON_ASSOCIATION AS ICON_ASSOC_OF_PATIENT
								 INNER JOIN ICON_FLAG_FACILITY AS IFF ON IFF.ID = ICON_ASSOC_OF_PATIENT.ICON_FLAG_FACILITY_ID
								 WHERE IFF.FACILITY_UID = @FACILITY_UID AND ICON_ASSOC_OF_PATIENT.PATIENT_UID = RESULT.PATIENT_UID AND ICON_ASSOC_OF_PATIENT.ICON_FLAG_FACILITY_ID IS NOT NULL
								 FOR XML PATH('')), 1, 1, ''),
				A.PATIENT_UID AS WAITING_LIST_PATIENT_UID,	
			   ' - Bed Assigned - {0} from ' + isnull(WA.DISPLAY_NAME,'') + ' - ' + isnull(WL.COMMENTS,'') AS WAITING_LIST_INFO,
				WL_EVACUATION.IS_EVACUATION_PATIENT AS IS_EVACUATION_PATIENT,
				EVACUATION_DISPOSITION_STATUS.DISPLAY_NAME AS EVACUATION_DISPOSITION_STATUS,
				BC.MANUAL_REQUEST_ID AS BED_CLEAN_MANUAL_REQUEST_ID				
		FROM 
			(SELECT * FROM #BED_OCCUPANCY_INFORMATION
			UNION 
			SELECT * FROM #VACATED_BED) AS RESULT
				LEFT JOIN BED_CLEAN AS BC ON BC.ID = RESULT.BED_CLEAN_ID
				LEFT JOIN BED_UNAVAILABLE AS BU ON BU.ACT_ID = RESULT.BED_UNAVAILABLE_ID
				LEFT JOIN CONCEPT AS BOOSS ON BOOSS.ID = BU.TYPE_ID
				LEFT JOIN CONCEPT AS BOOSR ON BOOSR.ID = BU.REASON_ID				
				LEFT JOIN WAITING_LIST WL ON WL.REQUESTED_BED_UID = RESULT.BED_UID AND WL.REMOVED_DATE IS NULL AND WL.REQUESTED_BED_UID IS NOT NULL 							
				LEFT JOIN CONCEPT AS WA ON WL.WAITING_AREA_ID = WA.ID
				LEFT JOIN ACT AS A ON A.ID = WL.ACT_ID		
				LEFT JOIN (SELECT MAX(A_EVACUATION.ID) AS ID, A_EVACUATION.PATIENT_UID AS PATIENT_UID
						   FROM ACT AS A_EVACUATION
							INNER JOIN WAITING_LIST WL_EVACUATION ON WL_EVACUATION.REMOVED_DATE IS NULL AND WL_EVACUATION.ACT_ID = A_EVACUATION.ID
						   GROUP BY A_EVACUATION.PATIENT_UID)
						   EVACUATION_WAITING_LIST ON EVACUATION_WAITING_LIST.PATIENT_UID = RESULT.PATIENT_UID
				LEFT JOIN WAITING_LIST WL_EVACUATION ON WL_EVACUATION.ACT_ID = EVACUATION_WAITING_LIST.ID
				LEFT JOIN CONCEPT AS EVACUATION_DISPOSITION_STATUS ON EVACUATION_DISPOSITION_STATUS.ID = WL_EVACUATION.EVACUATION_DISPOSITION_STATUS_ID									

	DROP TABLE #WARDS
	DROP TABLE #BED_OCCUPANCY_INFORMATION
	DROP TABLE #VACATED_BED
	DROP TABLE #BED_CLEAN

END

SET QUOTED_IDENTIFIER ON
