USE [BMS_DW]
GO

/****** Object:  StoredProcedure [dbo].[usp_Rpt_IconUsage]    Script Date: 6/14/2016 9:11:54 AM ******/
DROP PROCEDURE [dbo].[usp_Rpt_IconUsage]
GO

/****** Object:  StoredProcedure [dbo].[usp_Rpt_IconUsage]    Script Date: 6/14/2016 9:11:54 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



--EXEC usp_Rpt_IconUsage_DH 'DNS.URL\bms_svc_sqa'
--exec usp_Rpt_IconUsage_DH @UserID=N'DNS.URL\bms_svc_sqa',@FACILITIES_IDS=N'144;143_1,146;141_3,162;134_10,147;140_4,163;133_11,164;132_12,165;131_13,166;130_14,148;139_5,145;142_2,149;138_6,150;137_7,151;136_8,168;128_16,167;129_15,197;99_45,198;98_46,199;97_47,169;127_17,170;126_18,171;125_19,172;124_20,200;96_48,201;95_49,202;94_50,203;93_51,173;123_21,174;122_22,175;121_23,176;120_24,204;92_52,205;91_53,206;90_54,207;89_55,208;88_56,177;119_25,178;118_26,179;117_27,180;116_28,209;87_57,210;86_58,224;72_72,225;71_73,181;115_29,182;114_30,183;113_31,184;112_32,226;70_74,227;69_75,228;68_76,229;67_77,185;111_33,186;110_34,187;109_35,188;108_36,230;66_78,231;65_79,232;64_80,233;63_81,234;62_82,189;107_37,190;106_38,191;105_39,192;104_40,235;61_83,236;60_84,237;59_85,238;58_86,193;103_41,194;102_42,195;101_43,196;100_44,253;43_101,254;42_102,255;41_103,256;40_104,211;85_59,212;84_60,213;83_61,214;82_62,257;39_105,258;38_106,259;37_107,260;36_108,261;35_109,215;81_63,216;80_64,217;79_65,218;78_66,262;34_110,263;33_111,264;32_112,265;31_113,219;77_67,220;76_68,221;75_69,222;74_70,266;30_114,267;29_115,268;28_116,269;27_117,223;73_71,239;57_87,240;56_88,241;55_89,242;54_90,270;26_118,271;25_119,272;24_120,273;23_121,243;53_91,244;52_92,245;51_93,246;50_94,302;1_143,274;22_122,275;21_123,276;20_124,277;19_125,247;49_95,248;48_96,249;47_97,161;135_9,250;46_98,278;18_126,279;17_127,280;16_128,295;8_136,251;45_99,252;44_100,281;15_129,282;14_130,283;13_131,296;7_137,297;6_138,298;5_139,299;4_140,284;12_132,285;11_133,286;10_134,287;9_135,300;3_141,301;2_142',@ICON_TYPES=N'51;-1_4_24,30;-1_18_10,53;-1_2_26,54;-1_1_27,33;-1_16_12,20;-1_25_3,27;-1_20_8,24;-1_22_6,35;-2_15_13,32;-2_17_11,48;-2_7_21,26;-2_21_7,21;-2_24_4,47;-2_8_20,42;-2_12_16,18;-2_27_1,37;-2_14_14,50;-2_5_23,29;-2_19_9,52;-2_3_25,44;-2_11_17,23;-2_23_5,39;-2_13_15,45;-2_10_18,46;-2_9_19,49;-2_6_22,19;-3_26_2'
--exec usp_Rpt_IconUsage @UserID=NULL,@FACILITIES_IDS=NULL,@ICON_TYPES=NULL

CREATE PROCEDURE [dbo].[usp_Rpt_IconUsage] 
	@UserID NVARCHAR(500),
	@FACILITIES_IDS NVARCHAR(MAX) = '',
	@ICON_TYPES NVARCHAR(MAX) = ''

AS
BEGIN
	DECLARE @TBL_FACILITY TABLE (ID INT PRIMARY KEY)
	DECLARE @TBL_ICON_TYPE TABLE (CODE VARCHAR(250) PRIMARY KEY)
						 
	INSERT INTO @TBL_FACILITY(ID) 
	SELECT CASE WHEN CHARINDEX(';',F.ID) > 0 THEN CAST(SUBSTRING(F.ID,1, CHARINDEX(';',F.ID) -1) AS INT) 
			    ELSE CAST(F.ID AS INT) 
		   END
	FROM (SELECT  VALUE AS ID FROM dbo.ufn_Split(@FACILITIES_IDS, ','))F

	INSERT INTO @TBL_ICON_TYPE(CODE) 
	SELECT CONVERT(VARCHAR(20), VALUE) FROM dbo.ufn_Split(@ICON_TYPES, ',')
	
	declare @TBL_EMERGENCY_ICONS table (id int PRIMARY KEY)
	declare @TBL_STANDARD_ICONS table (id int PRIMARY KEY)
	declare @TBL_SITE_CFG_ICONS table (id int PRIMARY KEY)
	declare @TBL_PARENT_SITE_CFG_ICONS TABLE(ID INT PRIMARY KEY)
	
	insert into @TBL_EMERGENCY_ICONS(id)
	select case when charindex(';',code) > 0 then 
			substring(code,1,charindex(';',code) -1) 
			else code end
	from @TBL_ICON_TYPE
	where charindex('-1',code) > 0 -- for emg icons
	
	-- if the category 'Emergency Management Icons' is chosen, all the icons of this type are considered
	-- and it's id is deleted
	if exists (select id from @TBL_EMERGENCY_ICONS where id = -1)
	begin
		insert into @TBL_EMERGENCY_ICONS
		select id from dbo.dim_icon_flag 
		where SUBGROUP = 'EMERGENCY_ICON' and
				id not in (select id from @TBL_EMERGENCY_ICONS)
				
		delete from @TBL_EMERGENCY_ICONS
		where id = -1		
	
	end	
	
	insert into @TBL_STANDARD_ICONS(id)
	select case when charindex(';',code) > 0 then 
			substring(code,1,charindex(';',code) -1) 
			else code end
	from @TBL_ICON_TYPE
	where charindex('-2',code) > 0 -- for standard icons
	
	-- if the category 'Standard Icons' is chosen, all the icons of this type are considered
	-- and it's id is deleted
	if exists (select id from @TBL_STANDARD_ICONS where id = -2)
	begin
		insert into @TBL_STANDARD_ICONS
		select id from dbo.dim_icon_flag 
		where SUBGROUP = 'STANDARD_ICON' and
				id not in (select id from @TBL_STANDARD_ICONS)
				
		delete from @TBL_STANDARD_ICONS
		where id = -2		
	
	end
	
	insert into @TBL_PARENT_SITE_CFG_ICONS(ID)
	select case when charindex(';',code) > 0 then 
			substring(code,1,charindex(';',code) -1) 
			else code end
	from @TBL_ICON_TYPE
	where charindex('-3',code) > 0 -- for site configurable icons

	-- if the category 'Site Configurable Icons' is chosen, all the icons of this type are considered
	IF EXISTS (SELECT ID FROM @TBL_PARENT_SITE_CFG_ICONS WHERE ID = -3)
		BEGIN
			
			INSERT INTO @TBL_SITE_CFG_ICONS(id)
			SELECT ID FROM dbo.DIM_ICON_FLAG_FACILITY 
			WHERE ICON_NAME IS NOT NULL AND LEN(LTRIM(RTRIM(ICON_NAME)))>0
		END
	ELSE
		BEGIN
			INSERT INTO @TBL_SITE_CFG_ICONS(id)
			SELECT DISTINCT ICON_F_FAC.ID
			FROM dbo.DIM_ICON_FLAG_FACILITY AS ICON_F_FAC
			INNER JOIN @TBL_PARENT_SITE_CFG_ICONS AS PARENT ON PARENT.ID = ICON_F_FAC.DIM_ICON_FLAG_ID
		END
	
	IF EXISTS(SELECT 1  FROM @TBL_FACILITY)
		BEGIN
		
		CREATE TABLE #TBL_TEMP 
		(
			ID INT IDENTITY(1,1) PRIMARY KEY,
			CODE NVARCHAR(250),
			FLAG_ID INT,
			[DESCRIPTION] NVARCHAR(250), 
			ICON_NAME NVARCHAR(250), 
			ACTIVE CHAR(1), 
			PT_REC NVARCHAR(10), 
			BED_REC NVARCHAR(10),
			IMAGE_BYTES nvarchar(max)
		)

		INSERT INTO #TBL_TEMP(CODE, FLAG_ID, ICON_NAME, [DESCRIPTION],  ACTIVE, PT_REC, BED_REC, IMAGE_BYTES)		
		SELECT DISTINCT FAC.CODE, ICON_FLAG.ID as FLAG_ID, 
			ICON_FLAG.ICON_NAME as ICON_NAME,
			ICON_FLAG.[SHORT_DESCRIPTION] as [DESCRIPTION],
			'Y' AS ACTIVE, 
			'N' AS PT_REC,
			'Y' AS BED_REC,
			ICON_FLAG.IMAGE_BYTES 
		FROM dbo.GROUP_ICON_ASSOCIATION AS ICON_ASSOCIATION
			INNER JOIN dbo.GROUP_BED_WARDGROUP AS BED ON BED.DIM_BED_ID = ICON_ASSOCIATION.DIM_BED_ID
			INNER JOIN dbo.DIM_ORGANIZATION AS DIVISION ON DIVISION.ID = BED.DIM_WARDGROUP_ID
			INNER JOIN @TBL_FACILITY AS FACILITY ON FACILITY.ID = DIVISION.DIM_ORGANIZATION_ID
			INNER JOIN dbo.DIM_ICON_FLAG AS ICON_FLAG ON ICON_FLAG.ID = ICON_ASSOCIATION.DIM_ICON_FLAG_ID	
			INNER JOIN dbo.DIM_ORGANIZATION AS FAC ON FACILITY.ID = FAC.ID
			LEFT JOIN @TBL_EMERGENCY_ICONS AS EMERGENCY_ICONS ON EMERGENCY_ICONS.id = ICON_ASSOCIATION.DIM_ICON_FLAG_ID
			LEFT JOIN @TBL_STANDARD_ICONS AS STANDARD_ICONS ON STANDARD_ICONS.id = ICON_ASSOCIATION.DIM_ICON_FLAG_ID
		WHERE ICON_ASSOCIATION.DIM_BED_ID IS NOT NULL AND ICON_FLAG.ACTIVE = 1 AND ICON_FLAG.PUBLISHED = 1 
			  AND (EMERGENCY_ICONS.id IS NOT NULL OR STANDARD_ICONS.id IS NOT NULL)
			  AND(ICON_FLAG.SUBGROUP = 'EMERGENCY_ICON' OR ICON_FLAG.SUBGROUP='STANDARD_ICON')
		UNION ALL
		SELECT DISTINCT FAC.CODE, ICON_FLAG_FACILITY.ID as FLAG_ID, 
			ICON_FLAG.ICON_NAME as ICON_NAME, 
			ISNULL(ICON_FLAG_FACILITY.[DESCRIPTION],ICON_FLAG.[SHORT_DESCRIPTION]) as [DESCRIPTION], 
			case ICON_FLAG_FACILITY.ACTIVE when 0 then 'N' when 1 then 'Y'  end as ACTIVE, 
			'N' AS PT_REC,
			'Y' BED_REC,
			ICON_FLAG.IMAGE_BYTES
		FROM dbo.GROUP_ICON_ASSOCIATION AS ICON_ASSOCIATION
		INNER JOIN @TBL_SITE_CFG_ICONS AS SITE_CFG_ICONS ON SITE_CFG_ICONS.ID = ICON_ASSOCIATION.DIM_ICON_FLAG_FACILITY_ID
		INNER JOIN dbo.DIM_ICON_FLAG_FACILITY AS ICON_FLAG_FACILITY	ON ICON_FLAG_FACILITY.ID = SITE_CFG_ICONS.ID
		INNER JOIN dbo.DIM_ICON_FLAG AS ICON_FLAG ON ICON_FLAG.ID = ICON_FLAG_FACILITY.DIM_ICON_FLAG_ID	
		INNER JOIN @TBL_FACILITY AS FACILITY ON FACILITY.ID = ICON_FLAG_FACILITY.DIM_ORGANIZATION_FACILITY_ID
		INNER JOIN dbo.DIM_ORGANIZATION AS FAC ON FACILITY.ID = FAC.ID
		WHERE ICON_ASSOCIATION.DIM_BED_ID IS NOT NULL AND ICON_FLAG.ACTIVE = 1 AND ICON_FLAG.PUBLISHED = 1 
		UNION ALL
		SELECT DISTINCT FAC.CODE, ICON_FLAG_FACILITY.ID as FLAG_ID, 
			ICON_FLAG.ICON_NAME as ICON_NAME, 
			ISNULL(ICON_FLAG_FACILITY.[DESCRIPTION],ICON_FLAG.[SHORT_DESCRIPTION]) as [DESCRIPTION], 
			case ICON_FLAG_FACILITY.ACTIVE when 0 then 'N' when 1 then 'Y'  end as ACTIVE, 
			'Y' AS PT_REC,
			'N' BED_REC,
			ICON_FLAG.IMAGE_BYTES 
		FROM dbo.GROUP_ICON_ASSOCIATION AS ICON_ASSOCIATION
		INNER JOIN @TBL_SITE_CFG_ICONS AS SITE_CFG_ICONS ON SITE_CFG_ICONS.ID = ICON_ASSOCIATION.DIM_ICON_FLAG_FACILITY_ID
		INNER JOIN dbo.DIM_ICON_FLAG_FACILITY AS ICON_FLAG_FACILITY	ON ICON_FLAG_FACILITY.ID = SITE_CFG_ICONS.ID
		INNER JOIN dbo.DIM_ICON_FLAG AS ICON_FLAG ON ICON_FLAG.ID = ICON_FLAG_FACILITY.DIM_ICON_FLAG_ID	
		INNER JOIN @TBL_FACILITY AS FACILITY ON FACILITY.ID = ICON_FLAG_FACILITY.DIM_ORGANIZATION_FACILITY_ID
		INNER JOIN dbo.DIM_ORGANIZATION AS FAC ON FACILITY.ID = FAC.ID
		WHERE ICON_ASSOCIATION.DIM_PATIENT_ID IS NOT NULL AND ICON_FLAG.ACTIVE = 1 AND ICON_FLAG.PUBLISHED = 1 
		UNION ALL
		SELECT DISTINCT FAC.CODE, ICON_FLAG.ID as FLAG_ID, 
			ICON_FLAG.ICON_NAME as ICON_NAME,
			ICON_FLAG.[SHORT_DESCRIPTION] as [DESCRIPTION],
			'Y' AS ACTIVE, 
			'Y' AS PT_REC,
			'N' AS BED_REC,
			ICON_FLAG.IMAGE_BYTES 
		FROM dbo.GROUP_ICON_ASSOCIATION AS ICON_ASSOCIATION
			INNER JOIN (SELECT MAX(ID) AS ID, DIM_PATIENT_ID
						FROM FACT_ADMISSION_EVN 
						GROUP BY DIM_PATIENT_ID) AS LAST_ADM ON LAST_ADM.DIM_PATIENT_ID = ICON_ASSOCIATION.DIM_PATIENT_ID
			INNER JOIN FACT_ADMISSION_EVN AS ADM ON ADM.ID = LAST_ADM.ID
			INNER JOIN GROUP_WARD_ORGANIZATION AS WARD ON WARD.DIM_WARD_ID = ADM.DIM_WARD_ID
			INNER JOIN dbo.DIM_ORGANIZATION AS DIVISION ON DIVISION.ID = WARD.DIM_ORGANIZATION_ID
			INNER JOIN @TBL_FACILITY AS FACILITY ON FACILITY.ID = DIVISION.DIM_ORGANIZATION_ID
			INNER JOIN dbo.DIM_ORGANIZATION AS FAC ON FACILITY.ID = FAC.ID
			INNER JOIN dbo.DIM_ICON_FLAG AS ICON_FLAG ON ICON_FLAG.ID = ICON_ASSOCIATION.DIM_ICON_FLAG_ID			
			LEFT JOIN @TBL_EMERGENCY_ICONS AS EMERGENCY_ICONS ON EMERGENCY_ICONS.id = ICON_ASSOCIATION.DIM_ICON_FLAG_ID
			LEFT JOIN @TBL_STANDARD_ICONS AS STANDARD_ICONS ON STANDARD_ICONS.id = ICON_ASSOCIATION.DIM_ICON_FLAG_ID		
		WHERE ICON_ASSOCIATION.DIM_PATIENT_ID IS NOT NULL AND ICON_FLAG.ACTIVE = 1 AND ICON_FLAG.PUBLISHED = 1 
			AND (EMERGENCY_ICONS.id IS NOT NULL OR STANDARD_ICONS.id IS NOT NULL)
			AND(ICON_FLAG.SUBGROUP = 'EMERGENCY_ICON' OR ICON_FLAG.SUBGROUP='STANDARD_ICON')

		-- count how many patients or beds have the icon associated
		
		SELECT RESULT.CODE, RESULT.[DESCRIPTION], RESULT.FLAG_ID, RESULT.ICON_NAME, RESULT.ACTIVE, RESULT.PT_REC, RESULT.BED_REC, IMAGE_BYTES
		FROM (
		select CODE, [DESCRIPTION], FLAG_ID, ICON_NAME, ACTIVE,
			   case when PT_REC = 'Y' then PT_REC + ' (' + cast(count(*) as varchar) + ')' 
					else 'N' end as PT_REC,
			   case when BED_REC = 'Y' then BED_REC + ' (' + cast(count(*) as varchar) + ')' 
					else 'N' end as BED_REC,
			   IMAGE_BYTES
		from #TBL_TEMP 
		group by CODE, [DESCRIPTION], FLAG_ID, ICON_NAME, ACTIVE, BED_REC, PT_REC, IMAGE_BYTES ) RESULT	
		order by CODE, [DESCRIPTION]

		DROP TABLE #TBL_TEMP
		
	END
END


GO


