USE [BMS_DW]
GO

/****** Object:  StoredProcedure [dbo].[usp_Rpt_EmergencyManagementEvacuationRegulate]    Script Date: 6/14/2016 9:18:05 AM ******/
DROP PROCEDURE [dbo].[usp_Rpt_EmergencyManagementEvacuationRegulate]
GO

/****** Object:  StoredProcedure [dbo].[usp_Rpt_EmergencyManagementEvacuationRegulate]    Script Date: 6/14/2016 9:18:05 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



/*
exec [usp_Rpt_EmergencyManagementEvacuationRegulate] 'DNS.URL\bms_svc_sqa',Null, Null, Null, Null
CURRENT STATUS = 55.01 added. Can't test Locally. 
*/

CREATE PROCEDURE [dbo].[usp_Rpt_EmergencyManagementEvacuationRegulate] 
	@USER_NAME NVARCHAR(500) = NULL,
	@FACILITY_EXTENSION NVARCHAR(250),
	@DIVISION_ID INT = NULL,
	@DIVISION_NAME NVARCHAR(250),
	@UserSalt NVARCHAR(250)
AS
BEGIN

	  -- create permission table
		CREATE TABLE #PERMISSION
		(
		 DIM_ORGANIZATION_ID INT,
		 DIM_WARD_ID INT
		)
		--insert permission for the user
		INSERT INTO #PERMISSION 
			SELECT * FROM dbo.ufn_GetPermissionByUserName(@USER_NAME)
				CREATE NONCLUSTERED INDEX [DIM_ORGANIZATION_ID] ON #PERMISSION ([DIM_ORGANIZATION_ID] ASC)
					WITH (
						 PAD_INDEX  = OFF,
						 STATISTICS_NORECOMPUTE  = OFF,
						 SORT_IN_TEMPDB = OFF,
						 IGNORE_DUP_KEY = OFF,
						 DROP_EXISTING = OFF,
						 ONLINE = OFF,
						 ALLOW_ROW_LOCKS  = ON,
						 ALLOW_PAGE_LOCKS  = ON)
				CREATE NONCLUSTERED INDEX DIM_WARD_ID ON #PERMISSION (DIM_WARD_ID ASC)
					WITH (
						 PAD_INDEX  = OFF,
						 STATISTICS_NORECOMPUTE  = OFF,
						 SORT_IN_TEMPDB = OFF,
						 IGNORE_DUP_KEY = OFF,
						 DROP_EXISTING = OFF,
						 ONLINE = OFF,
						 ALLOW_ROW_LOCKS  = ON,
						 ALLOW_PAGE_LOCKS  = ON) ;
							 
	DECLARE @FACILITY_ID INT
	--get facility id
	SET @FACILITY_ID = dbo.ufn_GetFacilityIdByIdentifier(@FACILITY_EXTENSION);
	--check if the user has permission for the facility		
	IF EXISTS(SELECT 1 
			  FROM #PERMISSION
			  WHERE DIM_ORGANIZATION_ID = @FACILITY_ID)
		BEGIN			
				
			CREATE TABLE #WARD (ID INT, NAME NVARCHAR(250), SPECIALTY_NAME NVARCHAR(250), NUMA NVARCHAR(250), HAvBED NVARCHAR(50))
			IF @DIVISION_ID = -1 OR @DIVISION_ID IS NULL
				BEGIN
					INSERT INTO #WARD(ID, NAME, SPECIALTY_NAME, NUMA, HAvBED)
					SELECT WARD.ID, WARD.NAME, SPECIALTY.DISPLAY_NAME, NUMA.DISPLAY_NAME, HAvBED.DISPLAY_NAME
					FROM dbo.DIM_WARD AS WARD
					INNER JOIN dbo.ufn_GetWardsByFacilityId(@FACILITY_ID) AS FAC_WARD ON FAC_WARD.ID = WARD.ID
					LEFT JOIN dbo.DIM_SPECIALTY AS SPECIALTY ON SPECIALTY.ID = WARD.VISTA_DIM_SPECIALTY_ID
					LEFT JOIN dbo.DIM_NUMA AS NUMA ON NUMA.ID = SPECIALTY.DIM_NUMA_ID
					LEFT JOIN dbo.DIM_HAvBED AS HAvBED ON HAvBED.ID = SPECIALTY.DIM_HAvBED_ID
					WHERE WARD.STATUS = 'active'
				END
			ELSE
				BEGIN		
					INSERT INTO #WARD(ID, NAME, SPECIALTY_NAME, NUMA, HAvBED)
					SELECT ACTIVE_WARD.ID, ACTIVE_WARD.NAME, SPECIALTY.DISPLAY_NAME, NUMA.DISPLAY_NAME, HAvBED.DISPLAY_NAME
					FROM GROUP_WARD_ORGANIZATION as WARD
					INNER JOIN dbo.DIM_WARD AS ACTIVE_WARD ON ACTIVE_WARD.ID = WARD.ID
					LEFT JOIN dbo.DIM_SPECIALTY AS SPECIALTY ON SPECIALTY.ID = ACTIVE_WARD.VISTA_DIM_SPECIALTY_ID
					LEFT JOIN dbo.DIM_NUMA AS NUMA ON NUMA.ID = SPECIALTY.DIM_NUMA_ID
					LEFT JOIN dbo.DIM_HAvBED AS HAvBED ON HAvBED.ID = SPECIALTY.DIM_HAvBED_ID
					WHERE ACTIVE_WARD.STATUS = 'active' AND WARD.DIM_ORGANIZATION_ID = @DIVISION_ID														
				END
			
			CREATE TABLE #ACTIVE_ADMISSION(
			PATIENT_ID INT,
			BED_ID INT,
			WARD_ID INT
			)
			
			CREATE TABLE #ADMISSION_AND_TRANSFER(
			FACT_ID INT NOT NULL ,
			BED_ID INT,
			WARD_ID INT,
			PATIENT_ID INT,
			CREATED_DATE DATETIME NULL,
			IS_ADMISSION_EVN BIT)
		
			INSERT INTO #ADMISSION_AND_TRANSFER(FACT_ID, BED_ID, WARD_ID, PATIENT_ID, CREATED_DATE, IS_ADMISSION_EVN)
			SELECT ADM_EVN.ID, ADM_EVN.DIM_BED_ID, ADM_EVN.DIM_WARD_ID, ADM_EVN.DIM_PATIENT_ID, ADM_EVN.ADMISSION_DATE, 1
			FROM FACT_ADMISSION_EVN AS ADM_EVN
			INNER JOIN #WARD AS WARD ON WARD.ID = ADM_EVN.DIM_WARD_ID
			WHERE ADM_EVN.HAS_DISCHARGE = 0

			INSERT INTO #ADMISSION_AND_TRANSFER(FACT_ID, BED_ID, WARD_ID, PATIENT_ID, CREATED_DATE, IS_ADMISSION_EVN)
			SELECT MOV_EVN.FACT_ADMISSION_EVN_ID, MOV_EVN.DIM_BED_ID, MOV_EVN.DIM_WARD_ID, MOV_EVN.DIM_PATIENT_ID, MOV_EVN.MOVEMENT_DATE, 0
			FROM FACT_MOVEMENT_EVN AS MOV_EVN
			INNER JOIN (SELECT MAX(LAST_MOV_EVN.MOVEMENT_DATE) AS MOVEMENT_DATE, LAST_MOV_EVN.FACT_ADMISSION_EVN_ID
						FROM FACT_MOVEMENT_EVN LAST_MOV_EVN
						INNER JOIN #ADMISSION_AND_TRANSFER AS ADM_EVN ON ADM_EVN.FACT_ID = LAST_MOV_EVN.FACT_ADMISSION_EVN_ID
						GROUP BY LAST_MOV_EVN.FACT_ADMISSION_EVN_ID) MAX_ME_EVENT 
						ON MAX_ME_EVENT.MOVEMENT_DATE = MOV_EVN.MOVEMENT_DATE AND MAX_ME_EVENT.FACT_ADMISSION_EVN_ID = MOV_EVN.FACT_ADMISSION_EVN_ID
			
			DELETE DEL FROM #ADMISSION_AND_TRANSFER AS DEL
			INNER JOIN #ADMISSION_AND_TRANSFER AS ADM ON ADM.FACT_ID = DEL.FACT_ID AND ADM.BED_ID <> DEL.BED_ID AND ADM.IS_ADMISSION_EVN = 1
			WHERE DEL.IS_ADMISSION_EVN = 0
			
			INSERT INTO #ACTIVE_ADMISSION(WARD_ID, BED_ID, PATIENT_ID)
			SELECT ADMISSION_INFO.WARD_ID, ADMISSION_INFO.BED_ID, ADMISSION_INFO.PATIENT_ID
			FROM #ADMISSION_AND_TRANSFER AS ADMISSION_INFO
			INNER JOIN 
			(   SELECT MAX(CREATED_DATE) AS CREATED_DATE, BED_ID
				FROM #ADMISSION_AND_TRANSFER
				GROUP BY BED_ID
			) LAST_ADMISISON_INFO ON LAST_ADMISISON_INFO.CREATED_DATE = ADMISSION_INFO.CREATED_DATE AND LAST_ADMISISON_INFO.BED_ID = ADMISSION_INFO.BED_ID

			DROP TABLE #ADMISSION_AND_TRANSFER
			
			SELECT EVACUATION_PATIENT.SOURCE_ID AS ACT_ID,
			PATIENT.LAST_NAME AS LAST_NAME,
			SUBSTRING(PATIENT.LAST_NAME, 1, 1) + SUBSTRING(PATIENT.SSN, 7, 5) AS LAST_NAME_INITIAL_AND_LAST_FOUR,
			PATIENT.GENDER AS GENDER,
			'VS: ' + ISNULL(WARD.SPECIALTY_NAME, '') AS WARD_SPECIALTY_NAME,
            'NU: ' + ISNULL(WARD.NUMA, '') AS WARD_NUMA_NAME,
            'HV: ' + ISNULL(WARD.HAvBED,'') AS WARD_HAvBED_NAME,			
			PATIENT.ADMITTING_DIAGNOSIS AS PRESENTING_PROBLEM,
			ISNULL(WARD.NAME, '') + ' - ' + ISNULL(BED.NAME, '')  AS CURRENT_LOCATION,
			dbo.ufn_GetEmergencyImagesByEvacuation(@FACILITY_ID, BED.ID, PATIENT.ID) AS CLINICAL_EQUIP_REQUIREMENTS,
			EVACUATION_PATIENT.EVACUATION_TRANSPORTATION_CARE_LEVEL AS  TRANSPORT_CARE_LEVEL,		
			EVACUATION_PATIENT.EVACUATION_ENROUTE_MEDICAL_ATTENDANT AS ENROUTE_MA,
			EVACUATION_PATIENT.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT AS ENROUTE_NMA,		    				
			TRANSPORTATION_TYPE.DISPLAY_NAME AS TRANSPORTATION_TYPE,
			TRANSPORTATION_PROVIDER.DISPLAY_NAME AS TRANSPORTATION_PROVIDER,
			EVACUATION_PATIENT.EVACUATION_TRANSPORTATION_COMMENTS AS TRANSPORTATION_COMMENTS,
			EVACUATION_PATIENT.EVACUATION_VEHICLE_ID as VEHICLE_ID,
			EVACUATION_PATIENT.EVACUATION_VEHICLE_SEAT_POSITION as SEAT_POSITION,
			[dbo].[ufn_Encrypt] ('idAdmission=' + cast(EVACUATION_PATIENT.SOURCE_ID as nvarchar(100)) 
				+ '&isFromEvacuationReport=true&selectedDivisionName=' + @DIVISION_NAME + '&selectedDivisionId=' 
				+ cast(@DIVISION_ID as nvarchar(100)) 
				+ '&isRosterReport=false&isRegulateReport=true&isManifestReport=false&isTransferReport=false', @UserSalt) AS PATIENT_LINK
			FROM dbo.FACT_WAITING_LIST AS EVACUATION_PATIENT
			INNER JOIN DIM_PATIENT AS PATIENT ON PATIENT.ID = EVACUATION_PATIENT.DIM_PATIENT_ID
			LEFT JOIN DIM_EVAC_DISPOSITION_STATUS AS CONCEPT_EVAC_DISPOSITION_STATUS ON CONCEPT_EVAC_DISPOSITION_STATUS.ID = EVACUATION_PATIENT.DIM_EVACUATION_DISPOSITION_STATUS_ID
			LEFT JOIN dbo.DIM_EVAC_TRANSPORTATION_TYPE AS TRANSPORTATION_TYPE ON TRANSPORTATION_TYPE.ID = EVACUATION_PATIENT.DIM_EVACUATION_TRANSPORTATION_TYPE_ID
			LEFT JOIN dbo.DIM_EVAC_TRANSPORTATION_PROVIDER AS TRANSPORTATION_PROVIDER ON TRANSPORTATION_PROVIDER.ID = EVACUATION_PATIENT.DIM_EVACUATION_TRANSPORTATION_PROVIDER_ID
			LEFT JOIN #ACTIVE_ADMISSION AS ADMISSION ON ADMISSION.PATIENT_ID = EVACUATION_PATIENT.DIM_PATIENT_ID
			LEFT JOIN #WARD AS WARD ON WARD.ID = ADMISSION.WARD_ID
			LEFT JOIN dbo.DIM_BED AS BED ON BED.ID = ADMISSION.BED_ID
			WHERE EVACUATION_PATIENT.REMOVED_DATE IS NULL AND EVACUATION_PATIENT.FACILITY_DIM_ORGANIZATION_ID = @FACILITY_ID AND EVACUATION_PATIENT.IS_EVACUATION_PATIENT = 1
			DROP TABLE #WARD
			DROP TABLE #ACTIVE_ADMISSION						
		END
		
	IF OBJECT_ID('tempdb..#PERMISSION') IS NOT NULL
		BEGIN
			DROP TABLE #PERMISSION
		END
END




GO


