﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using InfoWorld.HL7.ITS;
using BMS.Facade.Data;
using BMS.Facade;
using System.Web.Mvc;
using System.Text;
using InfoWorld.EVS.CTSMAPI;
using System.ComponentModel.DataAnnotations;

namespace BMS.Web.Models
{
    /// <summary>
    /// ADT Orderable Item view model class.
    /// </summary>
    public class AdtOrderableItemsViewModel : BaseViewModel
    {
        /// <summary>
        /// Gets or sets the selected ADT orderable item code.
        /// </summary>
        /// <value>
        /// The selected ADT orderable item code.
        /// </value>
        [Required(ErrorMessage = "You must select an Orderable Item")]
        public string ADTOrderableItemCode { get; set; }
        
        /// <summary>
        /// Gets or sets the selected orderable item type code.
        /// </summary>
        /// <value>
        /// The selected orderable item type code.
        /// </value>
        [Required(ErrorMessage = "You must select a Type")]
        public string OrderableItemTypeCode { get; set; }
        
        /// <summary>
        /// Gets or sets the ADT orderable item list.
        /// </summary>
        /// <value>
        /// The ADT orderable item list.
        /// </value>
        public List<CD> OrderableItemList { get; set; }
        
        /// <summary>
        /// Gets or sets the orderable item type list.
        /// </summary>
        /// <value>
        /// The orderable item type list.
        /// </value>
        public CDList OrderableItemTypeList { get; set; }

        /// <summary>
        /// Sets the orderable item list.
        /// </summary>
        /// <value>
        /// The orderable item list.
        /// </value>
        public IList<CDWithProperties> ADTOrderableItemList
        {
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    FacilityADTOrderableItemListExtended = new List<OrderableItemViewModel>();
                    string _oiTypeText = string.Empty;
                    string _oiIEN = string.Empty;
                    // generate the extended orderable items list(with the type text and IEN properties).
                    if (value != null)
                    {
                        StringBuilder facilityCode = new StringBuilder();
                        facilityCode.Append(LoggedUser.VistaSite.Code);
                        facilityCode.Append("_");
                        facilityCode.Append(LoggedUser.Facility.Code);
                        facilityCode.Append("_");
                        foreach (CDWithProperties item in value)
                        {
                            _oiTypeText = OrderableItemTypeList.SingleOrDefault(cp => cp.code == item.Properties.SingleOrDefault(a => a.PropertyName.text == "OrderableItemType").PropertyValue.text).displayName;

                            try
                            {
                                _oiIEN = item.code.Substring(item.code.LastIndexOf("_") + 1);
                            }
                            catch (Exception) { _oiIEN = string.Empty; }
                            if (item.code.StartsWith(facilityCode.ToString()))
                            {
                                FacilityADTOrderableItemListExtended.Add(new OrderableItemViewModel() { Model = item, OrderableItemTypeText = _oiTypeText, OrderableItemIEN = _oiIEN });
                            }
                            else
                            {
                                if (ADTOrderableItemListExtended == null)
                                    ADTOrderableItemListExtended = new List<OrderableItemViewModel>();
                                ADTOrderableItemListExtended.Add(new OrderableItemViewModel() { Model = item, OrderableItemTypeText = _oiTypeText, OrderableItemIEN = _oiIEN });
                            }
                        }
                    }
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }
        /// <summary>
        /// Gets or sets the orderable item list extended(with type text property).
        /// </summary>
        /// <value>
        /// The orderable item list extended.
        /// </value>
        public IList<OrderableItemViewModel> FacilityADTOrderableItemListExtended { get; set; }

        /// <summary>
        /// Gets or sets the ADT orderable item list extended (on vista node).
        /// </summary>
        /// <value>
        /// The ADT orderable item list extended.
        /// </value>
        public IList<OrderableItemViewModel> ADTOrderableItemListExtended { get; set; }

        /// <summary>
        /// Gets or sets the button save.
        /// </summary>
        /// <value>
        /// The button save.
        /// </value>
        public string ButtonSave { get; set; }

        /// <summary>
        /// Gets or sets the button load OI.
        /// </summary>
        /// <value>
        /// The button load OI.
        /// </value>
        public string ButtonLoadOI { get; set; }
    }

    /// <summary>
    /// Additional view model class containing orderable item object, the type text and presentation properties.
    /// </summary>
    public class OrderableItemViewModel : BaseViewModel
    {
        /// <summary>
        /// Gets or sets the orderable item object.
        /// </summary>
        /// <value>
        /// The orderable item object.
        /// </value>
        public CDWithProperties Model { get; set; }

        /// <summary>
        /// Gets or sets the orderable item type text.
        /// </summary>
        /// <value>
        /// The orderable item type text.
        /// </value>
        public string OrderableItemTypeText { get; set; }

        /// <summary>
        /// Gets or sets the orderable item IEN.
        /// </summary>
        /// <value>
        /// The orderable item IEN.
        /// </value>
        public string OrderableItemIEN { get; set; }

        #region Presentation/View Properties

        /// <summary>
        /// Gets or sets the delete confirmation text visible attribute.
        /// </summary>
        /// <value>
        /// The delete confirmation text visible attribute.
        /// </value>
        public string DeleteConfirmationVisible { get; set; }
        
        /// <summary>
        /// Gets or sets the add confirmation text visible attribute.
        /// </summary>
        /// <value>
        /// The add confirmation text visible attribute.
        /// </value>
        public string AddConfirmationVisible { get; set; }
        
        /// <summary>
        /// Gets or sets the add already exists confirmation text visible attribute.
        /// </summary>
        /// <value>
        /// The add already exists confirmation text visible attribute.
        /// </value>
        public string AddAlreadyExistsConfirmationVisible { get; set; }

        /// <summary>
        /// Gets or sets the add ADT orderable item with A different type confirmation visible.
        /// </summary>
        /// <value>
        /// The add ADT orderable item with A different type confirmation visible.
        /// </value>
        public string AddADTOrderableItemWithADifferentTypeConfirmationVisible { get; set; }

        #endregion
    }
}