﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using BMS.Facade.Data;
using BMS.VistaIntegration.FacadeContracts.Admin;
using System.Text;

namespace BMS.Web.Models
{
    public class AdminWhiteboardReportViewModel : BaseViewModel
    {
        public string SelectedCalendarId { get; set; }

        public List<JobCalendar> Calendars { get; set; }

        public IList<WhiteboardReportConfigEntry> Entries { get; set; }

        public WhiteboardReportConfigEntry Entry { get; set; }

        public IList<CheckItem<Facility>> Facilities { get; set; }

        public static string GetFacilitiesCode(WhiteboardReportConfigEntry entry)
        {
            if (!entry.Facilities.Any()) return string.Empty;
            StringBuilder sb = new StringBuilder();
            entry.Facilities.OrderBy(a => a.Code).ToList().ForEach(e =>
            {
                sb.Append(e.Code);
                sb.Append(", ");
            });
            sb.Remove(sb.Length - 2, 2);
            return sb.ToString();
        }
    }
}