﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using BMS.Web.Models;
using InfoWorld.HL7.ITS;
using Microsoft.Web.Mvc;
using BMS.Utils;
using BMS.Facade;
using BMS.Facade.Data;
using BMS.Web.App_GlobalResource;

namespace BMS.Web.Controllers
{
    /// <summary>
    /// Bed Board Module Controller class.
    /// </summary>
    public class BedBoardModuleController : BaseController
    {
        /// <summary>
        /// Default action for the BedBoardModuleController.
        /// </summary>
        /// <returns>Returns the Index view result.</returns>
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Index()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                BedBoardModuleViewModel bedBoardViewModule = new BedBoardModuleViewModel();
                FillModel(bedBoardViewModule);
                return View(bedBoardViewModule);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Post Action of Bed Board Controller.
        /// </summary>
        /// <param name="model">The bed board view module.</param>
        /// <returns></returns>
        [HttpPost]
        [UpdatePermissionAuthFilterAttribute]
        public ActionResult Index(BedBoardModuleViewModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (model.BedBoardModule != Strings.SelectAModule)
                {
                    string moduleName = FacadeManager.VocabularyInterface.GetVocabulary(Facade.Data.Util.Vocabulary.BedBoardModule).Where(a => a.code == model.BedBoardModule).Select(a => a.displayName).FirstOrDefault();
                    Module module = new Module();
                    module.Name = moduleName;
                    module.CurrentlyInUse = FacadeManager.VocabularyInterface.GetVocabulary(Facade.Data.Util.Vocabulary.StrictDecision).Find(a => a.code == model.PlaceInUse.code);
                    FacadeManager.ConfigurationInterface.AddEditModule(module, this.loggedUser.Domain, this.loggedUser.Facility.Id);

                    return this.RedirectToAction<BedBoardModuleController>(action => action.Index());
                }
                else
                {
                    ModelState.AddModelError("BedBoardModule", Strings.YouMustSelectAModule);
                    FillModel(model);
                    return View("Index", model);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #region Private Methods
        /// <summary>
        /// Fills the model.
        /// </summary>
        /// <param name="bedBoardViewModule">The bed board view module.</param>
        private void FillModel(BedBoardModuleViewModel bedBoardViewModule)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                bedBoardViewModule.ModuleList = FacadeManager.VocabularyInterface.GetVocabulary(Facade.Data.Util.Vocabulary.BedBoardModule);
                //Add "Select a Module" option to the drop down list.
                bedBoardViewModule.ModuleList.Insert(0, new CD { displayName = Strings.SelectAModule, code = Strings.SelectAModule });
                bedBoardViewModule.FlagsList = FacadeManager.VocabularyInterface.GetVocabulary(Facade.Data.Util.Vocabulary.StrictDecision);
                bedBoardViewModule.PlaceInUse = GetPlaceFlag(false, bedBoardViewModule.FlagsList);
                CD yes = GetPlaceFlag(true, bedBoardViewModule.FlagsList);
                bedBoardViewModule.ApplicationModuleList = Facade.FacadeManager.ConfigurationInterface.GetModules(this.loggedUser.Domain, this.loggedUser.Facility.Id);
                bedBoardViewModule.LoggedUser = loggedUser;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Gets the place flag.
        /// </summary>
        /// <param name="isFlagged">if set to <c>true</c> [is flagged].</param>
        /// <param name="flagList">The flag list.</param>
        /// <returns></returns>
        private CD GetPlaceFlag(bool isFlagged, CDList flagList)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (isFlagged)
                    return flagList.Find(cd => cd.code == Constants.Yes);
                else
                    return flagList.Find(cd => cd.code == Constants.No);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        #endregion
    }
}