﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace BMS.Web.Models
{
    /// <summary>
    /// Model for Clear All view on WardWhiteboard controller.
    /// </summary>
    public class WhiteboardClearAllViewModel : BaseViewModel
    {
        /// <summary>
        /// Gets or sets the bed.
        /// </summary>
        /// <value>
        /// The bed.
        /// </value>
        public string BedName { get; set; }

        /// <summary>
        /// Gets or sets the ward.
        /// </summary>
        /// <value>
        /// The ward.
        /// </value>
        public string WardName { get; set; }

        /// <summary>
        /// Gets or sets the root bed id from edit page.
        /// </summary>
        /// <value>
        /// The root bed id.
        /// </value>
        public string RootBedId { get; set; }

        /// <summary>
        /// Gets or sets the extension bed id from edit page.
        /// </summary>
        /// <value>
        /// The extension bed id.
        /// </value>
        public string ExtensionBedId { get; set; }

        /// <summary>
        /// Gets or sets the ward from ward whiteboard home page.
        /// </summary>
        /// <value>
        /// The ward parameter.
        /// </value>
        public string WardParameter { get; set; }

        /// <summary>
        /// Gets or sets the split screen from ward whiteboard home page.
        /// </summary>
        /// <value>
        /// The split screen parameter.
        /// </value>
        public string SplitScreenParameter { get; set; }

        /// <summary>
        /// Gets or sets the display PT from ward whiteboard home page.
        /// </summary>
        /// <value>
        /// The display PT code parameter.
        /// </value>
        public string DisplayPTCodeParameter { get; set; }

        /// <summary>
        /// Gets or sets the display footer census.
        /// </summary>
        /// <value>
        /// The display footer census.
        /// </value>
        public string DisplayFooterCensus { get; set; }

        /// <summary>
        /// Gets or sets the gender color from ward whiteboard home page.
        /// </summary>
        /// <value>
        /// The gender color code parameter.
        /// </value>
        public string GenderColorCodeParameter { get; set; }

        /// <summary>
        /// Gets or sets the sort by parameter.
        /// </summary>
        /// <value>
        /// The sort by parameter.
        /// </value>
        public string SortByParameter { get; set; }

        /// <summary>
        /// Gets or sets the display staff attending parameter.
        /// </summary>
        /// <value>
        /// The display staff attending parameter.
        /// </value>
        public string DisplayStaffAttendingParameter { get; set; }

        /// <summary>
        /// Gets or sets the scroll rate parameter.
        /// </summary>
        /// <value>
        /// The scroll rate parameter.
        /// </value>
        public int ScrollRateParameter { get; set; }

        /// <summary>
        /// Gets or sets the root patient id.
        /// </summary>
        /// <value>
        /// The root patient id.
        /// </value>
        public string RootPatientId { get; set; }

        /// <summary>
        /// Gets or sets the extension patient id.
        /// </summary>
        /// <value>
        /// The extension patient id.
        /// </value>
        public string ExtensionPatientId { get; set; }

        /// <summary>
        /// Gets or sets the flow id.
        /// </summary>
        /// <value>
        /// The flow id.
        /// </value>
        public string FlowId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance has evacuation icon.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance has evacuation icon; otherwise, <c>false</c>.
        /// </value>
        public bool HasEvacuationIcon { get; set; }
    }
}