﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using InfoWorld.HL7.ITS;
using BMS.Facade.Data;
using System.Web.Mvc;
using BMS.Web.Controllers.Shared;

namespace BMS.Web.Models
{
    public class WaitingAreaViewModel : BaseViewModel
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the waiting area name.
        /// </summary>
        /// <value>
        /// The name of the waiting area.
        /// </value>
        [ValidateXss]
        public string WaitingAreaName { get; set; }

        /// <summary>
        /// Gets or sets the concept code of the vocabulary.
        /// </summary>
        /// <value>
        /// The concept code of the vocabulary.
        /// </value>
        public string Code { get; set; }

        /// <summary>
        /// Gets or sets the waiting area list.
        /// </summary>
        /// <value>
        /// The waiting area list.
        /// </value>
        public IList<CD> WaitingAreaList { get; set; }

        /// <summary>
        /// Gets or sets the message.
        /// </summary>
        /// <value>
        /// The message.
        /// </value>
        public string Message { get; set; }

        /// <summary>
        /// Gets or sets the display button when missing waiting area text.
        /// </summary>
        /// <value>
        /// The display button when missing waiting area text.
        /// </value>
        public string DisplayButtonWhenMissingWaitingAreaText { get; set; }

        /// <summary>
        /// Gets or sets the display button when successfully edit area text.
        /// </summary>
        /// <value>
        /// The display button when successfully edit area text.
        /// </value>
        public string DisplayButtonWhenSuccessfullyEditAreaText { get; set; }

        #endregion
    }
}