﻿using System;
using System.Collections.Generic;
using BMS.Utils;
using BMS.Facade.Data;
using System.ComponentModel.DataAnnotations;

namespace BMS.Web.Models
{
    public class SiteOptionsViewModel : BaseViewModel
    {
        public DateTime FacilityDateTime { get; set; }
        public string VISN { get; set; }
        public string VISNExtension { get; set; }
        public string FacilityExtension { get; set; }
        public string Region { get; set; }
        public string RegionExtension { get; set; }
        public bool IsEvacuation { get; set; }
        public bool IsEvacConfirmationSureQuestionVisible { get; set; }
        public string ResetSummaryUnavailableSelected { get; set; }
        Dictionary<string, string> _resetSummaryUnavailableList;
        public Dictionary<string, string> ResetSummaryUnavailableList 
        {
            get 
            {
                _resetSummaryUnavailableList = new Dictionary<string, string>();
                _resetSummaryUnavailableList.Add(Constants.BED_OUT_OF_SERVICE_TYPE_CODE, "Unavailable/Out Of Service");
                _resetSummaryUnavailableList.Add(Constants.BED_DO_NOT_DISPLAY_TYPE_CODE, "Not Displayed");
                return _resetSummaryUnavailableList;
            }
        }
        public List<Division> DivisionList { get; set; }
        [Required(ErrorMessage = "You must select a Ward!")]
        public string DivisionSelectedId { get; set; }
        public string ResetSummaryResultText { get; set; }
        public string ButtonSubmitResetSummary { get; set; }
        public string ButtonSubmitEvacuation { get; set; }
    }
}