﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Facade.Data;
using BMS.Utils;
using BMS.Web.App_GlobalResource;
using InfoWorld.HL7.ITS;

namespace BMS.Web.Models
{
    /// <summary>
    /// The Model class for the Home page.
    /// </summary>
    public class HomeViewModel : BaseViewModel
    {
        /// <summary>
        /// Gets or sets the admission list.
        /// </summary>
        /// <value>
        /// The admission list.
        /// </value>
        public IList<AdmissionInfo> AdmissionList { get; set; }

        /// <summary>
        /// Gets or sets the threshold.
        /// </summary>
        /// <value>
        /// The threshold.
        /// </value>
        public int Threshold { get; set; }

        /// <summary>
        /// Gets or sets the view2 id selected.
        /// </summary>
        /// <value>
        /// The view2 id selected.
        /// </value>
        public string View2 { get; set; }
        /// <summary>
        /// Gets or sets the view2 object selected.
        /// </summary>
        /// <value>
        /// The view2 object selected.
        /// </value>
        public CD View2Selected { get; set; }

        /// <summary>
        /// Gets or sets the last selected view.
        /// </summary>
        /// <value>
        /// The last selected view.
        /// </value>
        public string LastSelectedView { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is change selected view.
        /// </summary>
        /// <value>
        ///     <c>true</c> if this instance is change selected view; otherwise, <c>false</c>.
        /// </value>
        public bool IsChangeSelectedView { get; set; }

        /// <summary>
        /// Gets or sets the view2 list.
        /// </summary>
        /// <value>
        /// The view2 list.
        /// </value>
        public CDList View2List { get; set; }

        /// <summary>
        /// Gets or sets the events count.
        /// </summary>
        /// <value>
        /// The events count.
        /// </value>
        public List<EventInfo> EventsCount { get; set; }
        /// <summary>
        /// Gets or sets the button filter clicked.
        /// </summary>
        /// <value>
        /// The clicked filter button.
        /// </value>
        public string CurrentFilter { get; set; }

        /// <summary>
        /// name of the filter to apply;when not null it is a filter operation
        /// </summary>
        public string FilterOperation { get; set; }

        /// <summary>
        /// Gets or sets the type of the waiting list filter.
        /// </summary>
        /// <value>
        /// The type of the waiting list filter.
        /// </value>
        public string WaitingListFilterType { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [diversion exists].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [diversion exists]; otherwise, <c>false</c>.
        /// </value>
        public bool DiversionExists { get; set; }

        /// <summary>
        /// Gets or sets the diversion yes.
        /// </summary>
        /// <value>
        /// The diversion yes.
        /// </value>
        public string DiversionYes { get; set; }

        /// <summary>
        /// Gets or sets the diversion no.
        /// </summary>
        /// <value>
        /// The diversion no.
        /// </value>
        public string DiversionNo { get; set; }

        /// <summary>
        /// Displays diversion details for tooltip if diversions exist
        /// </summary>
        public string DiversionInfo { get; set; }

        /// <summary>
        /// Gets or sets the marquee text.
        /// </summary>
        /// <value>
        /// The marquee text.
        /// </value>
        public string MarqueeText { get; set; }

        /// <summary>
        /// Gets or sets the facility time.
        /// </summary>
        /// <value>
        /// The facility time.
        /// </value>
        public DateTime FacilityTime { get; set; }

        /// <summary>
        /// Gets or sets the integrated sites.
        /// </summary>
        /// <value>
        /// The integrated sites.
        /// </value>
        public IList<Facility> IntegratedSites { get; set; }

        /// <summary>
        /// Gets or sets the go to selected facility site.
        /// </summary>
        /// <value>
        /// The go to selected facility site.
        /// </value>
        public string GoToSelectedFacilitySite { get; set; }

        /// <summary>
        /// Gets or sets the selected facility site extension.
        /// </summary>
        /// <value>
        /// The selected facility site extension.
        /// </value>
        public string SelectedFacilitySiteExtension { get; set; }

        /// <summary>
        /// Gets or sets the change integrated site error.
        /// </summary>
        /// <value>
        /// The change integrated site error.
        /// </value>
        public string ChangeIntegratedSiteError { get; set; }

        /// <summary>
        /// Gets or sets the occupancy percent.
        /// </summary>
        /// <value>
        /// The occupancy percent.
        /// </value>
        public int OccupancyPercent { get; set; }

        public Dictionary<string, int> WardCensus { get; set; }

        public Dictionary<string, int> WardCensusByCategory { get; set; }

        public Dictionary<string, CD> CensusCategories { get; set; }

        public string SelectedCensusCategory { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether the current view is selected.
        /// </summary>
        /// <value>
        ///   <c>true</c> if the current view is selected; otherwise, <c>false</c>.
        /// </value>
        public bool CurrentViewSelected { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is evacuation.
        /// </summary>
        /// <value>
        ///     <c>true</c> if this instance is evacuation; otherwise, <c>false</c>.
        /// </value>
        public bool IsEvacuation { get; set; }

        public string CPU { get; set; }

        /// <summary>
        /// Gets or sets the BP last ran date time.
        /// </summary>
        /// <value>
        /// The BP last ran date time.
        /// </value>
        public string BPLastRanDateTime { get; set; }

        public bool IsValidDateBPLastRan { get; set; }

        public string CurrentGridView { get; set; }

        public CDList WaitingAreaList { get; set; }

        public int GetCensusByCategory(string categoryName)
        {
            if (WardCensusByCategory == null || !WardCensusByCategory.ContainsKey(categoryName))
                return 0;

            return WardCensusByCategory[categoryName];
        }
		
        public bool IsFirstLoad { get; set; }

        public string HeaderCommand { get; set; }
    }

    public class EventInfo
    {
        public string DisplayValue { get; set; }
        public string ReportLink { get; set; }

        public static string GetDisplayNameFor(Utils.NewEvent newEventEnum)
        {
            switch (newEventEnum)
            {
                case Utils.NewEvent.AdmittedPatient:
                    return Strings.AdmittedPatient;
                case Utils.NewEvent.SignedAdmission:
                    return Strings.SignedAdmission;
                case Utils.NewEvent.SignedTransfer:
                    return Strings.SignedTransfer;
                case Utils.NewEvent.SignedDischarge:
                    return Strings.SignedDischarge;
                case Utils.NewEvent.SignedAnticipatedDischarge:
                    return Strings.SignedAnticipatedDischarge;
                case Utils.NewEvent.DischargeAppointment:
                    return Strings.DischargeAppointment;
                case Utils.NewEvent.PatientDischarged:
                    return Strings.PatientDischarged;
                case Utils.NewEvent.VacatedBed:
                    return Strings.VacatedBed;
                case Utils.NewEvent.CurrentlyCleaningBed:
                    return Strings.CurrentlyCleaningBed;
                case Utils.NewEvent.CompletedCleaningBed:
                    return Strings.CompletedCleaningBed;
                case Utils.NewEvent.BedOutOfService:
                    return Strings.BedOutOfService;
                case Utils.NewEvent.BackToService:
                    return Strings.BackToService;
            }

            return null;
        }
    }

    public class HomeRemoveAdmissionViewModel : BaseViewModel
    {
        public string IdAdmission { get; set; }
    }
}
