using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using InfoWorld.HL7.ITS;
using BMS.Facade.Data;
using InfoWorld.EVS.CTSMAPI;
using System.ComponentModel.DataAnnotations;
using BMS.Web.Models.Shared;
using BMS.Utils;
using System.Web.Mvc;
using System.Security;
using BMS.Web.Controllers.Shared;
using CompareAttribute = System.ComponentModel.DataAnnotations.CompareAttribute;

namespace BMS.Web.Models
{
    public class FacilitySettingsViewModel
    {
        private SecureString _emsPassword, _emsConfirmPassword, _kioskPassword, _kioskConfirmPassword;

        public string BMSServerTimeZone { get; set; }
        
        [Required(ErrorMessage = "The FacilitySiteTimeZone field is required.")]
        public string FacilitySiteTimeZoneCode { get; set; }
        
        public CD AutoRemovalWaitingList { get; set; }
        
        public CD AutoPlacementTransferList { get; set; }

        public CD IntegratedFacility { get; set; }
        
        public string MedicalCenterID { get; set; }
        
        [ValidateXss]
        public string WardPrefix { get; set; }

        [ValidateXss]
        public string WardSuffix { get; set; }

        [ValidateXss]
        public string ADTPrefix { get; set; }

        [ValidateXss]
        public string ADTSuffix { get; set; }

        [ValidateXss]
        public string FacilityName { get; set; }

        [ValidateXss]
        public string FacilityAddress1 { get; set; }

        [ValidateXss]
        public string FacilityAddress2 { get; set; }

        [ValidateXss]
        public string FacilityPOCContact { get; set; }

        [RegularExpression(Constants.EMAIL_GROUP_REGULAR_EXPRESSION, ErrorMessage = "Invalid email.")]
        public string FacilityPOCEmail { get; set; }

        [ValidateXss]
        public string FacilityPOCTelephone { get; set; }
        
        [Range(-1, 1, ErrorMessage = "Local Time Adjust must be a positive or negative integer between -1 and 1.")]
        public int LocalTimeAdjust { get; set; }
        
        public CDList FacilitySiteTimeZoneList { get; set; }
        
        public CDList StrictDecisionList { get; set; }
        
        public User LoggedUser { get; set; }
        
        public FacilitySettings Settings { get; set; }

        /// <summary>
        /// Gets or sets the vista division list.
        /// </summary>
        /// <value>
        /// The vista division list.
        /// </value>
        public List<CD> VistaDivisionList { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [show allowed access sites].
        /// </summary>
        /// <value>
        /// 	<c>true</c> if [show allowed access sites]; otherwise, <c>false</c>.
        /// </value>
        public bool DisplayAllowedSites { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is integrated facility.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is integrated facility; otherwise, <c>false</c>.
        /// </value>
        public bool IsIntegratedFacility { get; set; }

        /// <summary>
        /// Gets or sets the integrated site list.
        /// </summary>
        /// <value>
        /// The integrated site list.
        /// </value>
        public IList<FacilitySisterSitesGroupViewModel> IntegratedSiteList { get; set; }

        /// <summary>
        /// Gets or sets the name of the EMS user.
        /// </summary>
        /// <value>
        /// The name of the EMS user.
        /// </value>
        [ValidateXss]
        public string EMSUserName { get; set; }

        /// <summary>
        /// Gets or sets the EMS password.
        /// </summary>
        /// <value>
        /// The EMS password.
        /// </value>
        //public string EMSPassword { get; set; }
        public string EMSPassword
        {
            get
            {
                return SecureStringUtils.ConvertToUnsecureString(_emsPassword);
            }

            set
            {
                _emsPassword = SecureStringUtils.ConvertToSecureString(value);
            }
        }

        /// <summary>
        /// Gets or sets the EMS confirm password.
        /// </summary>
        /// <value>
        /// The EMS confirm password.
        /// </value>
        [Compare("EMSPassword", ErrorMessage = "EMS Password and EMS Password Confirm do not match!")]
        //public string EMSConfirmPassword { get; set; }
        public string EMSConfirmPassword
        {
            get
            {
                return SecureStringUtils.ConvertToUnsecureString(_emsConfirmPassword);
            }

            set
            {
                _emsConfirmPassword = SecureStringUtils.ConvertToSecureString(value);
            }
        }

        /// <summary>
        /// Gets or sets the name of the EMS user.
        /// </summary>
        /// <value>
        /// The name of the EMS user.
        /// </value>
        [ValidateXss]
        public string KioskUserName { get; set; }

        /// <summary>
        /// Gets or sets the Kiosk password.
        /// </summary>
        /// <value>
        /// The Kiosk password.
        /// </value>
        //public string KioskPassword { get; set; }
        public string KioskPassword
        {
            get
            {
                return SecureStringUtils.ConvertToUnsecureString(_kioskPassword);
            }

            set
            {
                _kioskPassword = SecureStringUtils.ConvertToSecureString(value);
            }
        }

        /// <summary>
        /// Gets or sets the Kiosk confirm password.
        /// </summary>
        /// <value>
        /// The Kiosk confirm password.
        /// </value>
        [Compare("KioskPassword", ErrorMessage = "Whiteboard Kiosk Password and Whiteboard Kiosk Password Confirm do not match!")]
        //public string KioskConfirmPassword { get; set; }
        public string KioskConfirmPassword
        {
            get
            {
                return SecureStringUtils.ConvertToUnsecureString(_kioskConfirmPassword);
            }

            set
            {
                _kioskConfirmPassword = SecureStringUtils.ConvertToSecureString(value);
            }
        }
    }
}
