﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using BMS.Facade;
using System.Globalization;
using System.Text;
using System.Reflection;

namespace BMS.Web.Controllers
{
    /// <summary>
    /// Base class for checking if the user is authorized to perform the operation on a action.
    /// </summary>
    public class BasePermissionAuthFilterAttribute : PermissionAuthFilterAttribute
    {
        public string OperationOverride { get; set; }
        protected virtual string Type { get; private set; }

        public override void OnActionExecuting(ActionExecutingContext filterContext)
        {
            string controller = filterContext.ActionDescriptor.ControllerDescriptor.ControllerName;
            var method = filterContext.ActionDescriptor as ReflectedActionDescriptor;
            if (method == null)
                throw new InvalidOperationException("Could not find the operation associated with the request.");
            string action = method.MethodInfo.Name;

            string operation = null;
            if (!String.IsNullOrEmpty(OperationOverride))
            {
                operation = OperationOverride;
                if (!String.IsNullOrEmpty(Type) && !operation.EndsWith(" " + Type))
                    operation += " " + Type;
            }
            else
                operation = string.Format("{0}, {1} {2}", controller, action, Type);

            CheckPermission(filterContext, operation);
        }
    }
}