﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using BMS.Facade;
using BMS.Facade.Data;
using BMS.Utils;
using BMS.Web.App_GlobalResource;
using BMS.Web.Controllers.Shared;
using BMS.Web.Models;
using DevExpress.Web.Mvc;
using InfoWorld.HL7.ITS;
using Microsoft.Web.Mvc;

namespace BMS.Web.Controllers
{
    /// <summary>
    /// National And Regional Controller class.
    /// </summary>
    public class NationalAndRegionalController : BaseController
    {
        /// <summary>
        /// Default action for the Admin controller.
        /// </summary>
        /// <param name="regionId">The region id.</param>
        /// <param name="visnId">The visn id.</param>
        /// <param name="specialty">The speciality.</param>        
        /// <param name="waitingView">The waiting view.</param>
        /// <param name="waitingTime">The waiting time.</param>        
        /// <returns>
        /// The index view.
        /// </returns>
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Index(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                string waitingTime = null, waitingView = null;
                bool fillVisn = false;
                if (!string.IsNullOrEmpty(p))
                {
                    //regionId = QueryStrings["regionId"];
                    //visnId = QueryStrings["visnId"];
                    //selectedNationalPatient = QueryStrings["selectedNationalPatient"];
                    //specialty = QueryStrings["specialty"];
                    waitingTime = QueryStrings["waitingTime"];
                    waitingView = QueryStrings["waitingView"];
                    fillVisn = bool.Parse(QueryStrings["fillVisn"]);
                }

                NationalAndRegionalViewModel model = new NationalAndRegionalViewModel();
                model.DefaultII = new II { root = this.loggedUser.Domain, extension = Constants.ALL };
                //model.SelectedRegionExtension = string.IsNullOrEmpty(regionId) ? model.DefaultII.extension : regionId;
                //model.SelectedVisnExtension = string.IsNullOrEmpty(visnId) ? model.DefaultII.extension : visnId;
                FillModel(model);

                ModelState.Clear();

                //model.SelectedNationalPatient = string.IsNullOrEmpty(selectedNationalPatient) ? Strings.NationalViewDisplayOnlyNationlPatients : selectedNationalPatient;
                //model.SelectedSpeciality = string.IsNullOrEmpty(specialty) ? null : new CD() { code = specialty };
                model.SelectedWaitingTime = string.IsNullOrEmpty(waitingTime) ? model.WaitingTimes.Where(a => a.code == Constants.CURRENT).FirstOrDefault() : new CD() { code = waitingTime };
                model.SelectedWaitingView = string.IsNullOrEmpty(waitingView) ? model.WaitingViews.Where(a => a.code == Constants.STANDARD).FirstOrDefault() : new CD() { code = waitingView };
                model.VisibilityControlsForCurrentUser = Strings.VisibleValueOfVisibility;

                if (fillVisn == false)
                    FillPatientWaitingList(model);
                else
                {
                    if (model.SelectedWaitingView.code == Constants.STANDARD)
                        model.StandardPatientWaiting = TempData.Get<IList<TransferInfo>>();
                    else
                        model.DataViewPatientWaiting = TempData.Get<IList<DateView>>();
                }
                if (model.SelectedWaitingView.code == Constants.STANDARD)
                    TempData.Put<IList<TransferInfo>>(model.StandardPatientWaiting);
                else
                    TempData.Put<IList<DateView>>(model.DataViewPatientWaiting);

                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Index(NationalAndRegionalViewModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                bool fillVisn = false;
                if (!string.IsNullOrEmpty(model.FillVisnsByRegion))
                    fillVisn = true;

                //string selectedSpecialty = model.SelectedSpeciality != null ? model.SelectedSpeciality.code : null;
                string selectedWaitingView = model.SelectedWaitingView != null ? model.SelectedWaitingView.code : null;
                string selectedWaitingTime = model.SelectedWaitingTime != null ? model.SelectedWaitingTime.code : null;

                if (!String.IsNullOrEmpty(model.HeaderCommand))
                {
                    model.LoggedUser = loggedUser;
                    string saveArea = "NationalPPBP" + selectedWaitingView;
                    string key = loggedUser.Id.extension + saveArea;
                    if (model.HeaderCommand == "Save" && Session[key] != null)
                    {
                        string layoutData = Session[key].ToString();
                        GridHelper.SaveUserLayout(this.loggedUser, saveArea, layoutData, true); // save settings from session to database
                    }
                    else if (model.HeaderCommand == "Reset")
                        GridHelper.SaveUserLayout(this.loggedUser, saveArea, String.Empty, true); // clear saved settings and reset grid
                }

                return this.RedirectToAction<NationalAndRegionalController>(act => act.Index(EncryptQueryString(new string[] { "waitingView", "waitingTime", "fillVisn", "resetGrid" }, new string[] { selectedWaitingView, selectedWaitingTime, fillVisn.ToString(), model.HeaderCommand }, loggedUser.Salt)));
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [ValidateInput(false)]
        public ActionResult NationalAndRegionalGrid([Bind(Exclude = "RememberMe")] NationalAndRegionalViewModel model)
        {
            if (model == null || model.StandardPatientWaiting == null || model.DataViewPatientWaiting == null)
                model = BuildModelForGrid();

            return PartialView("NationalAndRegionalGrid", model);
        }

        public ActionResult ExportTo(string p)
        {
            string outputFormat = QueryStrings["outputFormat"];
            NationalAndRegionalViewModel model = BuildModelForGrid();

            object dataSource = model.SelectedWaitingView.code.Equals(BMS.Utils.Constants.STANDARD) ? (object)model.StandardPatientWaiting : (object)model.DataViewPatientWaiting;

            GridViewSettings settings = GridHelper.CreateNationalPPBPGrid(null, model, true);

            switch (outputFormat.ToUpper())
            {
                case "CSV":
                    return GridViewExtension.ExportToCsv(settings, dataSource);
                case "PDF":
                    return GridViewExtension.ExportToPdf(settings, dataSource);
                case "RTF":
                    return GridViewExtension.ExportToRtf(settings, dataSource);
                case "XLS":
                    return GridViewExtension.ExportToXls(settings, dataSource);
                case "XLSX":
                    return GridViewExtension.ExportToXlsx(settings, dataSource);
                default:
                    return GridViewExtension.ExportToXls(settings, dataSource);
            }
        }

        #region Private Methods

        private bool IsRegionalUser
        {
            get
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    return !loggedUser.IsSuperUser && loggedUser.SupportUser.IsNo() && loggedUser.NationalUser.IsNo() && loggedUser.RegionalUser.IsYes();
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }

        private IEnumerable<Region> GetRegions()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                var regions = IsRegionalUser ? new Region[] { loggedUser.DefaultFacility.VistaSite.Visn.Region } : Facade.FacadeManager.EntityInterface.GetRegions();
                return regions.OrderByDescending(a => a.Number);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private void FillModel(NationalAndRegionalViewModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                model.CurrentUser = loggedUser;
                model.LoggedUser = loggedUser;
                model.Specialities = Facade.FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.VistaSpecialty).OrderBy(a => a.displayName).ToList();
                model.WaitingTimes = Facade.FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.PatientWaitingTimes);
                model.WaitingViews = Facade.FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.WaitListView);
                IReportInfo nationalBedAvailabilityReport = Facade.FacadeManager.ReportsInterface.GetOtherReports(FullUserName).Where(a => a.Name == Constants.BED_AVAILABILITY_STATUS_REPORT).FirstOrDefault();
                if (nationalBedAvailabilityReport.Parameters == null)
                    nationalBedAvailabilityReport.Parameters = new Dictionary<String, String>();

                nationalBedAvailabilityReport.Parameters.Add(Constants.REP_TIME_ZONE_MINUTES_OFFSET, RepTimeZoneMinutesOffset);
                nationalBedAvailabilityReport.Parameters.Add(Constants.REP_GENERAL_RETURN_PATH, this.Request.Url.ToString());
                nationalBedAvailabilityReport.Parameters.Add(Constants.REP_GENERAL_RETURN_TEXT, Strings.ReturnToRegionalPage);
                nationalBedAvailabilityReport.Parameters.Add(Constants.REPORT_TITLE, Strings.BedAvailabilityStatusReportTitle);
                model.NationalBedAvailabilityReportUrl = nationalBedAvailabilityReport.Url;
                model.RegionsAndVisns = new Dictionary<Region, List<VisnItemModel>>();
                model.Regions = new List<RegionModel>();
                model.Visns = new List<VisnModel>();
                List<Region> regions = new List<Region>();
                List<VisnModel> visnsModel = new List<VisnModel>();
                model.ThColspanCount = 0;

                Dictionary<string, int> loggedUsers = FacadeManager.UserInterface.GetLoggedUsersCount(this.loggedUser.Domain, null);
                foreach (Region region in GetRegions())
                {
                    model.ThColspanCount++;
                    List<Visn> visns = Facade.FacadeManager.EntityInterface.GetVisns(region.Id).OrderBy(a => a.Number, new NumericComparer()).ToList();
                    List<VisnItemModel> visnModel = new List<VisnItemModel>();
                    foreach (Visn visn in visns)
                    {
                        visnModel.Add(new VisnItemModel() { Visn = visn, LoggedUsers = loggedUsers[visn.Id.extension.ToLower()] });
                    }
                    model.RegionsAndVisns.Add(region, visnModel);
                    model.Regions.Add(new RegionModel { Id = region.Id, Name = region.Number.ToString() });
                    visnsModel.AddRange(visns.Select(a => (new VisnModel { Id = a.Id, Name = a.Number })).ToList());
                }

                if (model.Visns != null)
                    model.Visns.Clear();
                if (!string.IsNullOrEmpty(model.SelectedRegionExtension) && model.SelectedRegionExtension != model.DefaultII.extension)
                {
                    Region region = model.RegionsAndVisns.Keys.Where(a => a.Id.extension.Equals(model.SelectedRegionExtension, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                    model.Visns = model.RegionsAndVisns[region].Select(a => (new VisnModel { Id = a.Visn.Id, Name = Strings.VISN + " " + a.Visn.Number })).ToList();
                }
                else
                    model.Visns = visnsModel.OrderBy(vm => vm.Name, new NumericComparer()).Select(vm => (new VisnModel { Id = vm.Id, Name = string.Concat(Strings.VISN," ",vm.Name) })).ToList();
                if (model.Visns.Where(a => a.Id.extension.Equals(model.SelectedVisnExtension, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault() == null)
                    model.SelectedVisnExtension = model.DefaultII.extension;
                model.Regions = model.Regions.OrderBy(regionModel => regionModel.Name, new NumericComparer()).Select(regionModel => new RegionModel { Id = regionModel.Id, Name = string.Concat(Strings.Region, " ", regionModel.Name) }).ToList();
                //Add Select all region option to the drop down list.
                //model.Regions.Insert(0, new RegionModel { Name = Constants.ALL, Id = model.DefaultII });
                //Add Select all region option to the drop down list.
                //model.Visns.Insert(0, new VisnModel { Name = Constants.ALL, Id = model.DefaultII });
                //model.Specialities.Insert(0, new CD { code = Constants.ALL, codeSystem = null, codeSystemName = null, displayName = Constants.ALL });
                model.DisplayNationalPatientsList = new List<string>();
                model.DisplayNationalPatientsList.Add(Strings.NationalViewDisplayAllPatients);
                model.DisplayNationalPatientsList.Add(Strings.NationalViewDisplayOnlyNationlPatients);

            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private NationalAndRegionalViewModel BuildModelForGrid()
        {
            NationalAndRegionalViewModel model = new NationalAndRegionalViewModel();

            string waitingTime = null, waitingView = null;
            if (QueryStrings != null && QueryStrings.Count > 0)
            {
                //regionId = QueryStrings["regionId"];
                //visnId = QueryStrings["visnId"];
                //selectedNationalPatient = QueryStrings["selectedNationalPatient"];
                //specialty = QueryStrings["specialty"];
                waitingTime = QueryStrings["waitingTime"];
                waitingView = QueryStrings["waitingView"];
            }

            model.LoggedUser = loggedUser;
            model.Specialities = Facade.FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.VistaSpecialty).OrderBy(a => a.displayName).ToList();
            model.WaitingTimes = Facade.FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.PatientWaitingTimes);
            model.WaitingViews = Facade.FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.WaitListView);

            model.Specialities.Insert(0, new CD { code = Constants.ALL, codeSystem = null, codeSystemName = null, displayName = Constants.ALL });

            model.DefaultII = new II { root = this.loggedUser.Domain, extension = Constants.ALL };
            //model.SelectedRegionExtension = string.IsNullOrEmpty(regionId) ? model.DefaultII.extension : regionId;
            //model.SelectedVisnExtension = string.IsNullOrEmpty(visnId) ? model.DefaultII.extension : visnId;
            //model.SelectedNationalPatient = string.IsNullOrEmpty(selectedNationalPatient) ? Strings.NationalViewDisplayOnlyNationlPatients : selectedNationalPatient;
            //model.SelectedSpeciality = string.IsNullOrEmpty(specialty) ? model.Specialities.Where(a => a.code == Constants.ALL).FirstOrDefault() : new CD() { code = specialty };
            model.SelectedWaitingTime = string.IsNullOrEmpty(waitingTime) ? model.WaitingTimes.Where(a => a.code == Constants.CURRENT).FirstOrDefault() : new CD() { code = waitingTime };
            model.SelectedWaitingView = string.IsNullOrEmpty(waitingView) ? model.WaitingViews.Where(a => a.code == Constants.STANDARD).FirstOrDefault() : new CD() { code = waitingView };
            model.VisibilityControlsForCurrentUser = Strings.VisibleValueOfVisibility;

            model.RegionsAndVisns = new Dictionary<Region, List<VisnItemModel>>();
            model.Regions = new List<RegionModel>();
            model.Visns = new List<VisnModel>();
            List<Region> regions = new List<Region>();
            List<VisnModel> visnsModel = new List<VisnModel>();
            model.ThColspanCount = 0;

            Dictionary<string, int> loggedUsers = FacadeManager.UserInterface.GetLoggedUsersCount(this.loggedUser.Domain, null);
            foreach (Region region in GetRegions())
            {
                model.ThColspanCount++;
                List<Visn> visns = Facade.FacadeManager.EntityInterface.GetVisns(region.Id).OrderBy(a => a.Number, new NumericComparer()).ToList();
                List<VisnItemModel> visnModel = new List<VisnItemModel>();
                foreach (Visn visn in visns)
                {
                    visnModel.Add(new VisnItemModel() { Visn = visn, LoggedUsers = loggedUsers[visn.Id.extension.ToLower()] });
                }
                model.RegionsAndVisns.Add(region, visnModel);
                model.Regions.Add(new RegionModel { Id = region.Id, Name = region.Number.ToString() });
                visnsModel.AddRange(visns.Select(a => (new VisnModel { Id = a.Id, Name = a.Number })).ToList());
            }

            if (model.Visns != null)
                model.Visns.Clear();
            if (!string.IsNullOrEmpty(model.SelectedRegionExtension) && model.SelectedRegionExtension != model.DefaultII.extension)
            {
                Region region = model.RegionsAndVisns.Keys.Where(a => a.Id.extension.Equals(model.SelectedRegionExtension, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                model.Visns = model.RegionsAndVisns[region].Select(a => (new VisnModel { Id = a.Visn.Id, Name = Strings.VISN + " " + a.Visn.Number })).ToList();
            }
            else
                model.Visns = visnsModel.OrderBy(vm => vm.Name, new NumericComparer()).Select(vm => (new VisnModel { Id = vm.Id, Name = string.Concat(Strings.VISN, " ", vm.Name) })).ToList();
            if (model.Visns.Where(a => a.Id.extension.Equals(model.SelectedVisnExtension, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault() == null)
                model.SelectedVisnExtension = model.DefaultII.extension;
            
            model.DisplayNationalPatientsList = new List<string>();
            model.DisplayNationalPatientsList.Add(Strings.NationalViewDisplayAllPatients);
            model.DisplayNationalPatientsList.Add(Strings.NationalViewDisplayOnlyNationlPatients);

            model.Regions = model.Regions.OrderBy(regionModel => regionModel.Name, new NumericComparer()).Select(regionModel => new RegionModel { Id = regionModel.Id, Name = string.Concat(Strings.Region, " ", regionModel.Name) }).ToList();
            //Add Select all region option to the drop down list.
            model.Regions.Insert(0, new RegionModel { Name = Constants.ALL, Id = model.DefaultII });
            //Add Select all region option to the drop down list.
            model.Visns.Insert(0, new VisnModel { Name = Constants.ALL, Id = model.DefaultII });

            FillPatientWaitingList(model);

            return model;
        }

        private void FillPatientWaitingList(NationalAndRegionalViewModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                //CD specialty = model.Specialities.Where(a => a.code == model.SelectedSpeciality.code).FirstOrDefault();                
                //Region region = null;
                //Visn visn = null;

                //if (string.IsNullOrEmpty(model.SelectedRegionExtension) && string.IsNullOrEmpty(model.SelectedVisnExtension))
                //{
                //    region = null;
                //    visn = null;
                //}
                //else if (!string.IsNullOrEmpty(model.SelectedRegionExtension) && string.IsNullOrEmpty(model.SelectedVisnExtension))
                //{
                //    region = Facade.FacadeManager.EntityInterface.GetRegion(new II(this.loggedUser.Domain, model.SelectedRegionExtension));
                //    visn = null;
                //}
                //else if (string.IsNullOrEmpty(model.SelectedRegionExtension) && !string.IsNullOrEmpty(model.SelectedVisnExtension))
                //{
                //    region = null;
                //    visn = Facade.FacadeManager.EntityInterface.GetVisn(new II(this.loggedUser.Domain, model.SelectedVisnExtension));
                //}
                //else
                //{
                //    if (model.SelectedRegionExtension.Equals(Constants.ALL))
                //        region = null;
                //    else
                //        region = Facade.FacadeManager.EntityInterface.GetRegion(new II(this.loggedUser.Domain, model.SelectedRegionExtension));
                //    if (model.SelectedVisnExtension.Equals(Constants.ALL))
                //        visn = null;
                //    else
                //        visn = Facade.FacadeManager.EntityInterface.GetVisn(new II(this.loggedUser.Domain, model.SelectedVisnExtension));
                //}

                //if All codes selected, send null to the service.
                //if (model.SelectedSpeciality != null && string.Compare(model.SelectedSpeciality.code, Constants.ALL, true) == 0)
                //    specialty.code = null;

                DateTime transferDateTime = DateTimeNowOnCurrentFacility;
                bool isCurrentWaitingList = false;

                if (model.SelectedWaitingTime.code == Constants.CURRENT)
                    transferDateTime = DateTimeNowOnCurrentFacility;
                else if (model.SelectedWaitingTime.code == Constants.PastThirtyDays)
                    transferDateTime = DateTimeNowOnCurrentFacility.AddMonths(-1);
                else if (model.SelectedWaitingTime.code == Constants.PastSixtyDays)
                    transferDateTime = DateTimeNowOnCurrentFacility.AddMonths(-2);
                else
                    transferDateTime = DateTimeNowOnCurrentFacility.AddMonths(-3);

                if (model.SelectedWaitingTime.code == Constants.CURRENT)
                    isCurrentWaitingList = true;
                else
                    isCurrentWaitingList = false;

                //bool isDisplayOnlyNationalPatients = false;
                //bool isDisplayOnlyNationalPatients = true;
                //if (model.SelectedNationalPatient != Strings.NationalViewDisplayOnlyNationlPatients)
                //    isDisplayOnlyNationalPatients = false;

                if (model.SelectedWaitingView.code == Constants.STANDARD)
                    model.StandardPatientWaiting = Facade.FacadeManager.ADTInterface.GetPatientsInCommunityHospitalsStandardView(false, null, null, null, isCurrentWaitingList, transferDateTime);

                else
                    model.DataViewPatientWaiting = Facade.FacadeManager.ADTInterface.GetPatientsInCommunityHospitalsDateView(false, null, null, null, isCurrentWaitingList, transferDateTime);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion
    }
}
