﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Microsoft.Web.Mvc;
using BMS.Web.Models;
using InfoWorld.HL7.ITS;
using BMS.Facade;
using BMS.Facade.Data;
using BMS.Web.App_GlobalResource;
using BMS.Utils;

namespace BMS.Web.Controllers
{
    /// <summary>
    /// Controller for comments page
    /// </summary>
    [ValidateInput(false)]
    public class AdminCommentsController : BaseController
    {
        /// <summary>
        ///  Default action for the Admin controller.
        /// </summary>
        /// <returns>The index view.</returns>
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Index([Bind(Exclude = "DisplayMessageAction")] string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                AdminCommentsViewModel model = new AdminCommentsViewModel();
                model.LoggedUser = this.loggedUser;
                model.StandardizedCommentList = FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.Comments);
                if (model.StandardizedCommentList != null && model.StandardizedCommentList.Count > 0)
                {
                    model.LastConceptCode = Convert.ToInt32(model.StandardizedCommentList.OrderBy(a => a.code.Split('_')[1], new NumericComparer()).Last().code.Split('_')[1]);
                }
                else
                    model.LastConceptCode = 0;
                if (!string.IsNullOrEmpty(p))
                {
                    model.CommentValue = model.StandardizedCommentList.Where(a => a.code == this.QueryStrings["conceptCode"]).First().displayName;
                    model.SelectedConceptCode = this.QueryStrings["conceptCode"];
                }
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Post action for the StandardizedComment controller - used for the Add button.
        /// </summary>
        /// <param name="input">The input(admin comments view model).</param>
        /// <returns>The Index view.</returns>
        [HttpPost]
        [UpdatePermissionAuthFilterAttribute]
        public ActionResult Index(AdminCommentsViewModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (!string.IsNullOrWhiteSpace(model.CommentValue) )
                {
                    CDList commentsVocabulary = FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.Comments);
                    CD comment = commentsVocabulary.FirstOrDefault(cd => cd.displayName.Equals(model.CommentValue.Trim()));
                    if (comment != null && (model.SelectedConceptCode == null || !comment.code.Equals(model.SelectedConceptCode, StringComparison.InvariantCultureIgnoreCase)))
                        model.DisplayMessageAction = Strings.CommonMedicalTermAlreadyExists;
                    else
                        if (string.IsNullOrEmpty(model.SelectedConceptCode))
                        {
                            CD concept = new CD() { code = Constants.Comment.ToUpper() + "_" + (model.LastConceptCode + 1).ToString(), codeSystem = Constants.CommentsCodeSystem, codeSystemName = Constants.Comments, displayName = model.CommentValue.ToUpper() };
                            FacadeManager.VocabularyInterface.InsertConcept(concept);
                            model.DisplayMessageAction = Strings.YouHaveAddedThisRecordSuccessfullyInDatabase;
                        }
                        else
                        {
                            CD concept = commentsVocabulary.Where(a => a.code == model.SelectedConceptCode).FirstOrDefault();
                            if (concept != null)
                            {
                                concept.displayName = model.CommentValue.ToUpper();
                                FacadeManager.VocabularyInterface.UpdateConcept(concept);
                            }
                            model.DisplayMessageAction = Strings.YouHaveUpdatedThisRecordSuccessfullyInDatabase;
                        }
                }
                else
                    model.DisplayMessageAction = Strings.YourDidNotEnterAMedicalTerm;

                return View("NotifyChange", model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Show Delete view.
        /// </summary>
        /// <param name="conceptCode">The concept Code</param>
        /// <returns>Returns the Delete view result.</returns>
        [HttpPost]
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Delete(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                AdminCommentsViewModel model = new AdminCommentsViewModel();
                CDList vocabulary = FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.Comments);
                CD concept = vocabulary.SingleOrDefault(x => x.code == this.QueryStrings["conceptCode"]);

                if (concept != null)
                    FacadeManager.VocabularyInterface.DeleteConcept(concept);
                model.DisplayMessageAction = Strings.YouHaveSuccessfullyDeletedThisRecordFromDatabase;
                return View("NotifyChange", model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Show Edit view
        /// </summary>
        /// <param name="conceptCode">The concept Code</param>
        /// <returns>Returns the Index view result.</returns>
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Edit(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                return this.RedirectToAction<AdminCommentsController>(act => act.Index(p));
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

    }
}
