﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Configuration;

namespace BMS.VistaIntegration
{
    public static class VistasBedHoldSupported
    {
        private const string ConfigKey = "VistasBedHoldSupported";

        private static List<String> vistasThatSupportBedHold;

        static VistasBedHoldSupported()
        {
            string keyValue = ConfigurationManager.AppSettings[ConfigKey];
            vistasThatSupportBedHold = keyValue.Split(new char[] { ';', ',' })
                .Where(s => s != string.Empty)
                .Select(s=>s.Trim())
                .ToList();

        }

        public static bool IsBedHoldSupported(string vistaId)
        {
            return vistasThatSupportBedHold.Contains(vistaId);
        }
    }
}
