﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Utils;
using BMS.VistaIntegration.Data;
using System.Configuration;

namespace BMS.VistaIntegration
{
    public class SiteData
    {
        public SiteData(VistASite site, IList<BMS.DataContracts.VistaOperation> operations)
        {
            Site = site;
            this.operations = operations;
            try
            {
                this.JobFailedMaxCount = int.Parse(ConfigurationManager.AppSettings["VistaIntegrationJobFailedMaxCount"]);
            }
            catch
            {
                this.JobFailedMaxCount = 10;
            }
            try
            {
                this.JobFailedIncrementDateMinutes = int.Parse(ConfigurationManager.AppSettings["VistaIntegrationJobFailedIncrementDateMinutes"]);
            }
            catch
            {
                this.JobFailedIncrementDateMinutes = 10;
            }
        }

        public VistASite Site { get; private set; }
        private readonly IList<BMS.DataContracts.VistaOperation> operations;
        private readonly int JobFailedMaxCount;
        private readonly int JobFailedIncrementDateMinutes;

        public BMS.DataContracts.VistaOperation this[VistaDataType type]
        {
            get 
            { 
                BMS.DataContracts.VistaOperation vo = operations.First(s => s.DataType == type);
                if (vo != null && vo.CounterFailed >= JobFailedMaxCount && vo.LastRunning.HasValue)
                {
                    if (vo.DataType.Equals(VistaDataType.ADT))
                    {
                        DateTime dt1 = vo.LastRunning.Value.AddMinutes(JobFailedIncrementDateMinutes);
                        DateTime dt2 = DateTime.UtcNow;
                        if (dt1 < dt2)
                            vo.LastRunning = dt1;
                        else
                            vo.LastRunning = dt2;
                        BMS.VistaIntegration.Commands.VistaOperationsCache.Instance.Update(vo);
                    }
                }
                return vo;
            }
        }
    }
}
