﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker2.Writer;

namespace BMS.VistaIntegration.Operations.Concrete.EntryProcessors
{
    public class SingleEntryProcessor<T> : IEntryProcessor
    {
        private IList<T> entries;
        private int index = 0;

        public Func<Parameter, IList<T>> FetchFunc { get; private set; }
        public Parameter Parameter { get; private set; }
        public int RetrievedEntries { get; private set; }
        public bool HasMoreEntries { get; private set; }
        public Func<T, DateTime?> FilterDateTimeFunc { get; private set; }
        protected IEntityWriter<T> entityWriter;
        private IWriterManager writerManager;

        public SingleEntryProcessor(IWriterManager writerManager, Parameter parameter)
        {
            Parameter = parameter;
            this.writerManager = writerManager;
        }

        public void Init(Func<Parameter, IList<T>> fetchFunc, Func<T, DateTime?> filterDateTimeFunc = null)
        {
            FetchFunc = fetchFunc;
            this.FilterDateTimeFunc = filterDateTimeFunc ?? ((t) => null);
            ResetBulk();
            if (HasMoreEntries) entityWriter = writerManager.MakeEntityWriter<T>();
        }

        public DateTime? EntryFilterDateTime { get { return FilterDateTimeFunc(Entry); } }

        private void ResetBulk()
        {
            do
            {
                entries = FetchFunc(Parameter);
            }
            while (entries != null && entries.Count == 0);

            if (entries != null)
            {
                HasMoreEntries = true;
                RetrievedEntries += entries.Count;
                index = 0;
            }
            else
                HasMoreEntries = false;

        }

        private T Entry { get { return entries[index]; } }

        public string ProcessNextEntry()
        {

            if (!HasMoreEntries)
                throw new InvalidOperationException();

            T entry = entries[index++];
            if (index == entries.Count)
                ResetBulk();
            return entityWriter.Update(entry) ? typeof(T).Name : null;

        }

        public void Dispose()
        {
            if (entityWriter != null) entityWriter.Dispose();
        }

        public void InitLogCheck(VistaWorker2.Writer.Implementation.Concrete.IVistaIntegrationLogChecker logChecker)
        {
            if (entityWriter != null) entityWriter.LogChecker = logChecker;
        }
    }
}
