﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker2.Writer;
using BMS.VistaIntegration.Data;
using System.Collections;
using BMS.Utils;

namespace BMS.VistaIntegration.Operations.Concrete.EntryProcessors
{
    public class MultipleEntryProcessor : IEntryProcessor
    {
        private int index = 0;
        private bool? hasMoreEntries;

        public DateTime? EntryFilterDateTime { get { return null; } }

        public bool HasMoreEntries
        {
            get
            {
                if (hasMoreEntries == null)
                    hasMoreEntries = GetHasMoreEntries();
                return hasMoreEntries.Value;
            }
        }
        private IList<IEntryProcessor> entriesProcessor;
        public IWriterManager WriterManager { get; private set; }

        public int RetrievedEntries
        {
            get
            {
                int value = 0;
                for (int i = 0; i < entriesProcessor.Count; i++)
                    value += entriesProcessor[i].RetrievedEntries;                
                return value;
            }
        }

        private bool GetHasMoreEntries()
        {
            for (int i = 0; i < entriesProcessor.Count; i++)
            {
                if (entriesProcessor[i].HasMoreEntries)
                    return true;
            }
            return false;
        }

        public void InitEntriesProcessor(IList<IEntryProcessor> entriesProcessor)
        {
            this.entriesProcessor = entriesProcessor;
        }


        public MultipleEntryProcessor(IWriterManager writerManager)
        {
            WriterManager = writerManager;
        }        

        public string ProcessNextEntry()
        {
            if (!HasMoreEntries)
                throw new InvalidOperationException();
            hasMoreEntries = null;            
            return entriesProcessor[index].ProcessNextEntry();

        }

        public void Dispose()
        {
            entriesProcessor.ForEach(s => s.Dispose());
        }

        public void InitLogCheck(VistaWorker2.Writer.Implementation.Concrete.IVistaIntegrationLogChecker logChecker)
        {
            entriesProcessor.ForEach(s => s.InitLogCheck(logChecker));
        }
    }
}
