﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.DataContracts;
using BMS.Utils;
using BMS.ServicesWrapper.BMService;
using System.Threading;

namespace BMS.VistaIntegration.Commands
{
    class VistaOperationsCache
    {
        internal static readonly VistaOperationsCache Instance = new VistaOperationsCache();

        private VistaOperationsCache() { } 

        private Dictionary<string, IList<VistaOperation>> cache = new Dictionary<string, IList<VistaOperation>>();
        private static readonly ReaderWriterLockSlim _lock = new ReaderWriterLockSlim();

        internal void Update(VistaOperation op)
        {
            BMSFactory.BedManagerOperationsClientWindows.UpdateData(op);
            _lock.EnterWriteLock();
            try
            {
                cache[op.VistaSiteId] = BMSFactory.BedManagerOperationsClientWindows.GetData(op.VistaSiteId);                
                int index = cache[op.VistaSiteId].IndexOf(P => P.DataType == op.DataType);
                cache[op.VistaSiteId][index] = op;
            }
            finally { _lock.ExitWriteLock(); }
        }

        internal IList<VistaOperation> Get(string vistaId)
        {
            IList<VistaOperation> result = null;
            _lock.EnterReadLock();
            try
            {               
                if (cache.ContainsKey(vistaId))
                    result = cache[vistaId];
            }
            finally { _lock.ExitReadLock(); }
            if (result == null || result.Count == 0)
            {
                _lock.EnterWriteLock();
                try
                {
                    result = BMSFactory.BedManagerOperationsClientWindows.GetData(vistaId);
                    cache[vistaId] = result;                    
                }
                finally { _lock.ExitWriteLock(); }
            }
            return result;
        }
    }
}
