﻿using System;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Via.Commands;
using Mdws2ORM.Maps;
using System.Configuration;

namespace BMS.VistaIntegration.Via.Commands.Maps
{
    public class ViaPatientMap : EntityMap<Patient>
    {
        public override string File
        {
            get
            {
                return "2";
            }
        }

        public override string Location
        {
            get
            {
                return "DPT(";
            }
        }

        protected override void MapFields()
        {
            this.MapFreeText(".01", (e, value) => e.Name = value);
            this.MapSetOfCodes(".02", (e, value) => e.Sex = value);
            this.MapDateTime(".03", (e, value) => e.DateOfBirth = value);
            this.MapFreeText(".09", (e, value) => e.SocialSecurityNumber = GetSsn(value));
            this.MapDateTime(".097", (e, value) => e.DateEnteredIntoFile = value);
            this.MapPointerToFile<FacilityTreatingSpecialty>(".103", (e, value) => e.TreatingSpecialtyId = value, (e, v) => e.TreatingSpecialty = v);
            this.MapPointerToFile<NewPerson>(".1041", (e, value) => { }, (e, v) => e.AttendingPhysician = v);

            this.MapPointerToFile(".105", (e, value) =>
            {
                var values = value.Split('~');
                e.AdmissionIen = values[0];

                if (values.Length > 1)
                {
                    e.AdmittingDiagnosis = values[1];
                }
            });

            MapBoolean(".109", (e, value) => e.IsOptOut = value);
            this.MapNumericInt(".302", (e, value) => e.ServiceConnectedPercentage = value);
        }

        private static string GetSsn(string value)
        {
            try
            {
                return value.Insert(3, "-").Insert(6, "-");
            }
            catch
            {
                return value;
            }
        }

        public override Patient NewEntity(string ien)
        {
            return new Patient() { IEN = ien };
        }
    }
}
