﻿using System;
using BMS.Utils;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Data.WF;
using BMS.VistaIntegration.Via.Commands.Maps;
using Mdws2ORM.Core;
using Mdws2ORM.Impl;
using Mdws2ORM.Maps.EIS;
using Mdws2ORM.Maps.EVS;
using Mdws2ORM.Maps.WF;
using Mdws2ORM.RpcQueries;

namespace BMS.VistaIntegration.Via.Commands
{
    internal static class EntityMapRegistration
    {
        static EntityMapRegistration()
        {
            var entityMapRepository = new EntityMapRepository();
            InitEis(entityMapRepository);
            InitEvs(entityMapRepository);
            InitWf(entityMapRepository);

            var fieldsParamFactory = new FieldsParamFactory();
            InitMediator = new InitMapMediator(entityMapRepository, fieldsParamFactory);
            entityMapRepository.EntityMaps.ForEach(s =>
            {
                s.SortFields = false;
                s.Initialize(InitMediator);
            });
        }

        public static InitMapMediator InitMediator
        {
            get;
            private set;
        }

        private static void InitEis(EntityMapRepository entityMapRepository)
        {
            entityMapRepository.Add<HospitalLocationMap, HospitalLocation>();
            entityMapRepository.Add<WardLocationMap, WardLocation>();
            entityMapRepository.Add<RoomBedMap, RoomBed>();
            entityMapRepository.Add<NewPersonMap, NewPerson>();
            entityMapRepository.Add<ViaPatientMap, Patient>();
        }

        private static void InitEvs(EntityMapRepository entityMapRepository)
        {
            entityMapRepository.Add<SpecialtyMap, Specialty>();
            entityMapRepository.Add<MedicalCenterDivisionMap, MedicalCenterDivision>();
            entityMapRepository.Add<FacilityMovementTypeMap, FacilityMovementType>();
            entityMapRepository.Add<OrderableItemMap, OrderableItem>();
            entityMapRepository.Add<FacilityTreatingSpecialtyMap, FacilityTreatingSpecialty>();
            entityMapRepository.Add<OrderStatusMap, OrderStatus>();
        }

        private static void InitWf(EntityMapRepository entityMapRepository)
        {
            entityMapRepository.Add<PatientMovementMap, PatientMovement>();
            entityMapRepository.Add<ScheduledAdmissionMap, ScheduledAdmission>();
            entityMapRepository.Add<OrderActionMap, OrderAction>();
            entityMapRepository.Add<ViaOrderMap, Order>();
            entityMapRepository.Add<PatientAppointmentMap, PatientAppointment>();
            entityMapRepository.Add<ClinicAppointmentMap, ClinicAppointment>();
            entityMapRepository.Add<BedSwitchMap, BedSwitch>();
            entityMapRepository.Add<AdmittedPatientMap, AdmittedPatient>();
            entityMapRepository.Add<ViaPatientMovementIenMap, PatientMovementIen>();
            entityMapRepository.Add<EDISPatientAdmissionMap, EDISPatientAdmission>();
        }
    }
}
