﻿using System;
using System.Linq;
using System.Collections.Generic;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Via.Commands.EntityCommands;
using Mdws2ORM;
using Mdws2ORM.Core;
using Mdws2ORM.Maps;
using BMS.VistaIntegration.Via.Commands.EIS;
using BMS.VistaIntegration.Via.Commands.EVS;


namespace BMS.VistaIntegration.Via.Commands.WF
{
    public class ListScheduledAdmissionCommand : BaseListPeriodCommand<ScheduledAdmission>
    {
        public ListScheduledAdmissionCommand(ViaVistAQuery query)
            : base(query)
        {
        }

        public string PatientIen
        {
            get;
            set;
        }

        protected override string GetTarget()
        {
            return "ListScheduledAdmission";
        }

        protected override IEnumerable<object> GetCriteria()
        {
            yield return this.PatientIen;
            yield return this.StartDate.GetValueOrDefault(MinDate);
            yield return this.EndDate.GetValueOrDefault(this.MaxDate);
            yield return this.MaxCount;
            yield return this.From;
        }

        protected override IDependencySource GetDependencySource()
        {
            return ScheduledAdmissionDependencySource.Instance;
        }
    }

    internal sealed class ScheduledAdmissionDependencySource : IDependencySource
    {
        private static IDependencySource instance;

        private ScheduledAdmissionDependencySource()
        {
        }

        public static IDependencySource Instance
        {
            get
            {
                if (instance == null)
                {
                    instance = new ScheduledAdmissionDependencySource();
                }

                return instance;
            }
        }

        public IEnumerable<DependentEntityInfo> GetDependentTypes()
        {
            yield return new DependentEntityInfo<Patient>(ListPatientCommand.Target, ListPatientCommand.ArgumentsCount, ListPatientCommand.CheckIen, ".01");
            yield return new DependentEntityInfo<WardLocation>(ListWardLocationCommand.Target, ListWardLocationCommand.ArgumentsCount, "8");
            yield return new DependentEntityInfo<FacilityTreatingSpecialty>(ListFacilityTreatingSpecialtyCommand.Target, ListFacilityTreatingSpecialtyCommand.ArgumentsCount, "9");
            yield return new DependentEntityInfo<MedicalCenterDivision>(ListMedicalCenterDivisionCommand.Target, ListMedicalCenterDivisionCommand.ArgumentsCount, "12");
            yield return new DependentEntityInfo<NewPerson>(ListNewPersonCommand.Target, ListNewPersonCommand.ArgumentsCount, "5", "11");
        }
    }
}
