﻿using System;
using System.Collections.Generic;
using System.Linq;
using BMS.Utils;
using BMS.VistaIntegration.Data.WF;
using Mdws2ORM;

namespace BMS.VistaIntegration.Via.Commands.WF
{
    public class ListBedSwitchCommand : BaseListCommand<BedSwitch>
    {
        private string currentIens;

        public ListBedSwitchCommand(ViaVistAQuery query)
            : base(query, true)
        {
        }

        public IEnumerable<string> Iens
        {
            get;
            set;
        }

        public override List<BedSwitch> Execute(ViaVistASession session)
        {
            var result = Enumerable.Empty<BedSwitch>();

            foreach (var iens in this.Iens.JoinAndSplitByLength(',', MaxCriteriaLength))
            {
                this.currentIens = iens;

                result = result.Union(base.Execute(session));
            }

            return result.ToList();
        }

        protected override string GetTarget()
        {
            return "ListBedSwitch";
        }

        protected override IEnumerable<object> GetCriteria()
        {
            yield return this.currentIens;
            yield return string.Empty;
        }
    }
}
