﻿using System;
using System.Linq;
using System.Collections.Generic;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Via.Commands.EntityCommands;

namespace BMS.VistaIntegration.Via.Commands.EVS
{
    public class ListSpecialtyCommand : BaseListCommand<Specialty>
    {
        public const string Target = "ListSpecialty";
        public const int ArgumentsCount = 3;

        public ListSpecialtyCommand(ViaVistAQuery query)
            : base(query)
        {
        }

        protected override string GetTarget()
        {
            return Target;
        }

        protected override IEnumerable<object> GetCriteria()
        {
            return new object[] { string.Empty }.Concat(base.GetCriteria());
        }
        protected override IDependencySource GetDependencySource()
        {
            return SpecialtyDependencySource.Instance;
        }
    }
    internal sealed class SpecialtyDependencySource : IDependencySource<Specialty>
    {
        private static SpecialtyDependencySource instance;
        private SpecialtyDependencySource()
        {
        }
        public static SpecialtyDependencySource Instance
        {
            get
            {
                if (instance == null)
                {
                    instance = new SpecialtyDependencySource();
                }
                return instance;
            }
        }
        public List<Specialty> PostProcessEntities(ViaVistAQuery query, List<Specialty> result)
        {
            if (result != null)
            {
                result = result.Where(a => !string.IsNullOrWhiteSpace(a.Name) && !a.Name.StartsWith("z", StringComparison.InvariantCultureIgnoreCase)).ToList();
            }
            return result;
        }
        public IEnumerable<DependentEntityInfo> GetDependentTypes()
        {
            yield break;
        }
    }
}
