﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Via.Commands.EntityCommands;
using BMS.Utils;

namespace BMS.VistaIntegration.Via.Commands.EIS
{
    public class ListRoomBedCommand : BaseListCommand<RoomBed>
    {
        public const string Target = "ListRoomBed";
        public const int ArgumentsCount = 3;

        public ListRoomBedCommand(ViaVistAQuery query)
            : base(query)
        {
        }

        protected override string GetTarget()
        {
            return Target;
        }

        protected override IEnumerable<object> GetCriteria()
        {
            return new object[] { string.Empty }.Concat(base.GetCriteria());
        }

        protected override IDependencySource GetDependencySource()
        {
            return RoomBedDependencySource.Instance;
        }
    }

    internal sealed class RoomBedDependencySource : IDependencySource<RoomBed>
    {
        private static IDependencySource instance;

        private RoomBedDependencySource()
        {
        }

        public static IDependencySource Instance
        {
            get
            {
                if (instance == null)
                {
                    instance = new RoomBedDependencySource();
                }

                return instance;
            }
        }

        public IEnumerable<DependentEntityInfo> GetDependentTypes()
        {
            yield return new DependentEntityInfo<WardLocation>(ListWardLocationCommand.Target, ListWardLocationCommand.ArgumentsCount, ',', "100");
        }

        public List<RoomBed> PostProcessEntities(ViaVistAQuery query, List<RoomBed> result)
        {
            result.ForEach(rb =>
            {
                if (!string.IsNullOrEmpty(rb.WardsWhichCanAssignString))
                {
                    rb.Wards = (from ien in rb.WardsWhichCanAssign
                                let ward = query.EntitySetCache.GetEntity<WardLocation>(query, ien)
                                where ward != null
                                select ward).ToList();
                }
            });

            return result;
        }
    }
}
