﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Linq;
using BMS.Schedulers.DateTimeValidators.CalendarValidators;
namespace BMS.VistaIntegration.UnitTesting.Schedulers
{

    [TestClass()]
    public class WeeklyRecursTest
    {


        [TestMethod()]
        public void IsValidRecursEvery1Test()
        {
            DateTime dateTimeStarted = new DateTime(2012, 1, 1, 1, 1, 1);
            int recursEvery = 1;
            var dayOfWeeks = new DayOfWeek[] { DayOfWeek.Sunday, DayOfWeek.Wednesday };
            WeeklyRecurs target = new WeeklyRecurs(recursEvery, dayOfWeeks);
            target.Init(dateTimeStarted);


            for (int i = 0; i < 1000; i++)
            {
                DateTime value = dateTimeStarted.AddDays(i);
                bool expected = target.DayOfWeeks.Contains(value.DayOfWeek);
                bool actual = target.IsValid(value);
                Assert.AreEqual(expected, actual);
            }
        }


        [TestMethod()]
        public void IsValidRecursEvery3Test()
        {
            DateTime dateTimeStarted = new DateTime(2012, 1, 5, 1, 1, 1);
            int recursEvery = 3;
            var dayOfWeeks = Enum.GetValues(typeof(DayOfWeek)).Cast<DayOfWeek>().ToList();
            WeeklyRecurs target = new WeeklyRecurs( recursEvery, dayOfWeeks);
            target.Init(dateTimeStarted);

            Assert.IsFalse(target.IsValid(new DateTime(2012, 1, 5, 1, 1, 1)));
            Assert.IsFalse(target.IsValid(new DateTime(2012, 1, 6, 1, 1, 1)));
            Assert.IsFalse(target.IsValid(new DateTime(2012, 1, 7, 1, 1, 1)));
            for (int i = 0; i < 7; i++)
                Assert.IsFalse(target.IsValid(new DateTime(2012, 1, 8 + i, 1, 1, 1)));
            for (int i = 0; i < 7; i++)
                Assert.IsTrue(target.IsValid(new DateTime(2012, 1, 15 + i, 1, 1, 1)));
            for (int i = 0; i < 7; i++)
                Assert.IsFalse(target.IsValid(new DateTime(2012, 1, 22 + i, 1, 1, 1)));
            for (int i = 0; i < 2; i++)
                Assert.IsFalse(target.IsValid(new DateTime(2012, 1, 29 + i, 1, 1, 1)));
            for (int i = 0; i < 4; i++)
                Assert.IsFalse(target.IsValid(new DateTime(2012, 2, 1 + i, 1, 1, 1)));
            for (int i = 0; i < 7; i++)
                Assert.IsTrue(target.IsValid(new DateTime(2012, 2, 5 + i, 1, 1, 1)));
            for (int i = 0; i < 7; i++)
                Assert.IsFalse(target.IsValid(new DateTime(2012, 2, 12 + i, 1, 1, 1)));
            for (int i = 0; i < 7; i++)
                Assert.IsFalse(target.IsValid(new DateTime(2012, 2, 19 + i, 1, 1, 1)));
            for (int i = 0; i < 4; i++)
                Assert.IsTrue(target.IsValid(new DateTime(2012, 2, 26 + i, 1, 1, 1)));

        }

    }
}
