﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps;
using Mdws2ORM.Maps.EIS;

namespace Mdws2ORM.Maps.WF
{
    public class EDISPatientAdmissionMap : EntityMap<EDISPatientAdmission>
    {
        public override string Location
        {
            get { return "DGS(230,"; }
        }

        public override EDISPatientAdmission NewEntity(string ien)
        {
            return new EDISPatientAdmission() { DispositionTime = Converters.ToDateTime( ien ) };
        }

        public override string File
        {
            get { return "230"; }
        }

        protected override void MapFields()
        {
            //MapDateTime("1.3", (m, s) => m.DispositionTime = s);
            MapPointerToFile<Patient>(".06", (m, s) => m.PatientId = s, (m, s) => m.Patient = s);
            MapFreeText(".02", (m, s) => m.FacilityCode = s);
            MapFreeText("1.1", (m, s) => m.Complaint = s);
            MapDateTime("1.4", (m, s) => m.DiagnosisTime = s);              
        }
    }
}
