﻿using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps;
using Mdws2ORM.QuerySvcService;
using BMS.VistaIntegration.Mdws.Commands.EntityCommands;
using BMS.VistaIntegration.Data.WF;
using System;
using BMS.Utils;
using Mdws2ORM;

namespace BMS.VistaIntegration.Mdws.Commands.Concrete.WF
{
    public class GetPatientMovementCommand
    {
        public DateTime DateTime { get; set; }
        public string PatientIen { get; set; }
        public MovementTransactionType MovementType { get; set; }
        public string PatientMovementIen { get; set; }

        public PatientMovement Execute(ISession session)
        {
            if (string.IsNullOrEmpty(PatientMovementIen))
            {
                string screen = string.Format(ScreenFormat, Converters.ToInternalFormat(DateTime), (int)MovementType, PatientIen);
                string from = Converters.ToInternalFormat(DateTime.AddSeconds(-1));

                ListParam param = new ListParamBuilder()
                    .Screen(screen)
                    .Index("B")
                    .Partial(ParamUtilities.GetMonthPart(DateTime))
                    .From(from)
                    .Number("1")
                    .Build();

                var result = session.List<PatientMovement>(param);
                return result.SingleOrDefault().Entity;
            }
            else
            {
                var result = session.Get<PatientMovement>(GetParamBuilder.DefaultParam, PatientMovementIen + ",");
                if (result != null)
                {
                    decimal transaction = 0;
                    decimal.TryParse(result.TransactionTypeId, out transaction);
                    if ((transaction >= Constants.PATIENT_MOVEMENT_TRANSACTION_ADMISSION_MIN && transaction <= Constants.PATIENT_MOVEMENT_TRANSACTION_ADMISSION_MAX) ||
                        (transaction >= Constants.PATIENT_MOVEMENT_TRANSACTION_TRANSFER_MIN && transaction <= Constants.PATIENT_MOVEMENT_TRANSACTION_TRANSFER_MAX) ||
                        (transaction >= Constants.PATIENT_MOVEMENT_TRANSACTION_DISCHARGE_MIN && transaction <= Constants.PATIENT_MOVEMENT_TRANSACTION_DISCHARGE_MAX) ||
                        (transaction >= Constants.PATIENT_MOVEMENT_TRANSACTION_SPECIALTY_TRANSFER_MIN && transaction <= Constants.PATIENT_MOVEMENT_TRANSACTION_SPECIALTY_TRANSFER_MAX))
                        return result;
                }
                return null;
            }
        }

        private const string ScreenFormat = "I $P(^(0),U,1)={0},$P(^(0),U,2)={1},$P(^(0),U,3)={2} I {0}";
    }
}
