﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BMS.Utils
{
    [Flags]
    public enum VistaDataType
    {
        None = 0,
        HospitalLocation = 1,
        Patient = 2,
        RoomBed = 4,
        WardLocation = 8,
        ADT = 16,
        Specialty = 32,
        TreatingSpecialty = 64,
        FacilityMovementType = 128,
        OrderableItem = 256,
        MedicalCenterDivision = 512,
        WaitingList = 1024,
        Order = 2048,
        PatientMovement = 4096,
        PatientAppointment = 8192,
        ScheduledAdmission = 16384,
        AdmittedPatient = 32768,
        PatientMovementIen = 65536,
        EDISPatientAdmission = 131072,
        Vocabularies = OrderableItem | Specialty | TreatingSpecialty | FacilityMovementType | MedicalCenterDivision,
        OrganizationalStructure = HospitalLocation | RoomBed | WardLocation,
    }
}
