﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Drawing;
using System.Drawing.Imaging;
using System.Web;

namespace BMS.Utils
{
    /// <summary>
    /// Image Converter class
    /// </summary>
    public static class ImageConverter
    {
        /// <summary>
        /// Convert Image to byte[] array
        /// </summary>
        /// <param name="image">The image</param>
        /// <returns></returns>
        public static byte[] GetByteArrayFromImage(Image image)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                byte[] imageBytes;
                using (MemoryStream ms = new MemoryStream())
                {
                    image.Save(ms, System.Drawing.Imaging.ImageFormat.Png);
                    image.Dispose();
                    imageBytes = ms.ToArray();
                }
                return imageBytes;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Convert Image to byte[] array
        /// </summary>
        /// <param name="image">The image</param>
        /// <returns></returns>
        public static void GetImageFromByteArray(string byteArray, string imageName)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                string folderPath = HttpContext.Current.Server.MapPath("~/Content/images/EVS/");
                if (!Directory.Exists(folderPath))
                    Directory.CreateDirectory(folderPath);
                string imgPath = Path.Combine(folderPath, imageName);
                if (!File.Exists(imgPath))
                {
                    byte[] imageBytes = Convert.FromBase64String(byteArray);
                    MemoryStream ms = new MemoryStream(imageBytes, 0, imageBytes.Length);
                    ms.Write(imageBytes, 0, imageBytes.Length);
                    Image image = Image.FromStream(ms, true);
                    image.Save(imgPath, ImageFormat.Png);
                    ms.Close();
                    image.Dispose();
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static string GetImageRelativePath()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                string url = HttpContext.Current.Request.Url.AbsolutePath;
                int count = url.Count(a => a.Equals('/'));
                StringBuilder path = new StringBuilder();
                for (int i = 1; i <= count; i++)
                    path.Append("../");
                path.Append("Content/images/EVS/");
                return path.ToString();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static byte[] MergeMultipleImages(List<string> imagesBytes)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                byte[] result;
                if (imagesBytes.Count == 1)
                    result = Convert.FromBase64String(imagesBytes[0]);
                else
                {
                    int count = 0;
                    using (Bitmap bitmap = new Bitmap(20 * imagesBytes.Count, 20))
                    {
                        Graphics g = Graphics.FromImage(bitmap);
                        foreach (string icon in imagesBytes)
                        {
                            byte[] imageBytes = Convert.FromBase64String(icon);
                            MemoryStream ms = new MemoryStream(imageBytes, 0, imageBytes.Length);
                            ms.Write(imageBytes, 0, imageBytes.Length);
                            Image image = Image.FromStream(ms, true);
                            ms.Close();
                            g.DrawImage(image, 20 * count, 0);
                            image.Dispose();
                            count++;
                        }

                        MemoryStream msByte = new MemoryStream();
                        bitmap.Save(msByte, System.Drawing.Imaging.ImageFormat.Png);
                        result = msByte.ToArray();
                        msByte.Close();
                    }
                }
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
