using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BMS.Utils
{
    /// <summary>
    /// BMS solution global contants.
    /// </summary>
    public static class Constants
    {
        #region Regular Expressions
        public const string EMAIL_GROUP_REGULAR_EXPRESSION = @"^(([\w-]+\.)+[\w-]+|([a-zA-Z]{1}|[\w-]{2,}))@((([0-1]?[0-9]{1,2}|25[0-5]|2[0-4][0-9])\.([0-1]?[0-9]{1,2}|25[0-5]|2[0-4][0-9])\.([0-1]?[0-9]{1,2}|25[0-5]|2[0-4][0-9])\.([0-1]?[0-9]{1,2}|25[0-5]|2[0-4][0-9])){1}|([a-zA-Z]+[\w-]+\.)+[a-zA-Z]{2,4})((,[ ]{0,1}(([\w-]+\.)+[\w-]+|([a-zA-Z]{1}|[\w-]{2,}))@((([0-1]?[0-9]{1,2}|25[0-5]|2[0-4][0-9])\.([0-1]?[0-9]{1,2}|25[0-5]|2[0-4][0-9])\.([0-1]?[0-9]{1,2}|25[0-5]|2[0-4][0-9])\.([0-1]?[0-9]{1,2}|25[0-5]|2[0-4][0-9])){1}|([a-zA-Z]+[\w-]+\.)+[a-zA-Z]{2,4}))*)$";
        public const string PATIENT_SEARCH_REGULAR_EXPRESSION = @"^[a-zA-Z0-9\-]{3,}$";
        public const string CONTINGENCY_REGULAR_EXPRESSION = @"^(([a-zA-Z]:)|(\\{2}\w+[a-zA-Z0-9\-]+)\$?)(\\(\w[a-zA-Z0-9\-].*))$";
        #endregion

        /// <summary>
        /// Controller temporary data dictionary constant for BedStatus.
        /// </summary>
        public const string TempData_BedStatus = "BedStatus";
        /// <summary>
        /// Controller temporary data dictionary constant for WardGroup.
        /// </summary>
        public const string TempData_WardGroup = "WardGroup";

        public const string NONE = "NONE";
        public const string Yes = "Yes";
        public const string No = "No";
        public const string Stat = "Stat";

        public const string DNRDNIRegex = "(DNI)+|(DNR)+|(DNAR)+|(D\\.N\\.R\\.)+|(D\\.N\\.I\\.)+|(D\\.N\\.A\\.R\\.)+|(dni)+|(dnr)+|(dnar)+|(d\\.n\\.r\\.)+|(d\\.n\\.i\\.)+|(d\\.n\\.a\\.r\\.)+";

        public const string Icon = "Icon";

        public const string NonAcute = "Non-Acute";

        public const string WAITING_AREA_SCHEDULED_ADMISSIONS = "NATIONAL_SCHEDULED_ADMISSIONS";
        public const string WAITING_AREA_EVACUATION_CODE = "NATIONAL_EVACUATION";
        public const string WAITING_AREA_ADMISSIONS_CODE = "NATIONAL_ADMISSIONS";

        public const string EVAC_DISPOSITION_STATUS_EVACUATE_CODE = "EVAC";
        public const string EVAC_TRANSPORTATION_PROVIDER_VA_CODE = "VA";
        public const string EVAC_TRANSPORTATION_TYPE_CODE = "ALS_AMB";

        public const string PERSON_FIRST_NAME = "FirstName";
        public const string PERSON_MIDDLE_NAME = "MiddleName";
        public const string PERSON_LAST_NAME = "LastName";
        public const string DEFAULT_USER_PROFILE = "Default";
        public const string LastNameInitialAndLastFourDigitsOfSsn = "1st+Last4";
        public const string LastName = "Last Name";
        public const string GenderColorNone = "None";
        public const string GenderColorBlueAndPink = "Blue/Pink";
        public const string Visn = "VISN";
        public const string Facility = "Facility";
        public const string Patient = "PatientName";
        public const string Ssn = "SSN";
        public const string ServiceConnected = "Service Connected";
        public const string Era = "Era";
        public const string Contract = "Contract";
        public const string Diagnosis = "Diagnosis";
        public const string Specialty = "Specialty";
        public const string CurrentLocation = "CurrentLocation";
        public const string EventDT = "AdmissionDate";
        public const string Comment = "Comment";
        public const string Entered = "Entered";
        public const string Requested = "Requested";
        public const string Removed = "Removed";
        public const string PatientName = "PatientName";
        public const string Problem = "Problem";
        public const string TypeOfBedWard = "TypeOfBedWard";
        public const string WaitingArea = "WaitingArea";
        public const string WaitTime = "WaitTime";
        public const string ServiceReceivingFee = "ServiceReceivingFee";
        public const string Fee = "Fee";
        public const string ReasonUsingFee = "ReasonUsingFee";
        public const string Acute = "Acute";
        public const string FeeComments = "FeeComments";
        public const string BedAssignedDate = "BedAssignedDate";
        public const string RoomBedAssigned = "RoomBedAssigned";
        public const string EVENTDT = "EVENTDT";
        public const string REQUESTDT = "REQUESTDT";
        public const string STANDARD = "Standard";
        public const string CURRENT = "CURR";
        public const string ALL = "ALL";
        public const string PastThirtyDays = "30D";
        public const string PastSixtyDays = "60D";
        public const string Comments = "Comments";
        public const string SEARCH = "SEARCH";
        public const string ACTIVE = "Active";

        public const string CURRENT2 = "Current";
        public const string PAST_30_DAYS = "Past 30-Days";
        public const string YESTERDAY = "Today -24 hours";
        public const string TOMORROW = "Today +24 hours";

        public const string RECORDS_NUMBER_PER_PAGE = "RecordsNumberPerPage";

        public const string TRANSFER_REQUEST_ID = "TransferRequestID";

        public const string BedHasMultipleDivisionsAssignedWarning = "Bed assigned to multiple BMS ward group texts.";
        public const string BedHasMultipleCommentsWarning = "ERROR: Multiple comment found.";
        public const string GENDER_UNKNOWN_CODE = "UNK";

        public const string HOME = "home";
        public const string NEW_EVENTS = "newevents";

        public const string WL_AUTO_REMOVE_USER = "Bed_Control_Auto";

        #region Patient Risk

        public const string NegativePressure = "Negative Pressure";
        public const string CloseObservation = "Close Observation";
        public const string OneOnOne = "One-On-One";
        public const string Stretcher = "Stretcher";
        public const string RespiratoryTherapy = "Respiratory Therapy";
        public const string Ventilator = "Ventilator";


        public const string NegativePressureImageName = "NegativePressure";
        public const string CloseObservationImageName = "CloseObservation";
        public const string OneOnOneImageName = "OneOnOne";
        public const string StretcherImageName = "Stretcher";
        public const string RespiratoryTherapyImageName = "RespiratoryTherapy";
        public const string VentilatorImageName = "Ventilator";

        #endregion

        #region Reports Name

        public const string SignedAdmission = "Active Admission Orders Report";
        public const string PatientMovementByDate = "Patient Movements by Date";
        public const string SignedDischarge = "Active Discharge Orders Report";
        public const string AnticipatedDischarge = "Antic Discharge Orders Report";
        public const string DischargeAppointment = "Patients w Discharge Appointments";
        public const string DischargeAppointment1 = "Patients w Discharge Appointments";
        public const string EMSBedStatus = "EMS Bed Status Report (Admin)";
        public const string BedOutOfService = "Beds Out of Service Report (All)";
        public const string BedsOutOfService = "Beds Out of Service Report (By Date)";
        public const string BedSpecialtyRoster = "Bed Specialty Roster";
        public const string BedSpecialtyReport = "Bed Specialty Report";
        public const string ScheduledAdmissionsByDate = "Scheduled Admissions by Date";
        public const string ScheduledAdmissions = "Scheduled Admissions Report";
        public const string FacilityDiversion = "Facility Diversion Report";
        public const string PatientMovement = "Patient Movement Report";
        public const string PatientInquiry = "Patient Inquiry";
        public const string VISNBedSummaryReport = "VISN Bed Summary Report";
        public const string PPBPDateRange = "PPBP By Date Range Report";

        public const string NationalPPBP = "NationalPPBP_New";

        public const string BED_AVAILABILITY_STATUS_REPORT = "BED AVAILABILITY STATUS REPORT";
        public const string BED_SUMMARY_REPORT = "Bed Summary Report";
        public const string BED_TURNAROUND_TIME_REPORT = "Bed Turnaround Time Report";
        public const string DISCHARGES_IN_PROGRESS_REPORT = "Discharges In Progress";
        public const string DISCHARGE_ORDER_DIFF_REPORT = "Discharge Order Difference Report";

        public const string VISN_ACTIVE_RPT = "VISN Network Active Report";
        public const string VISN_AUDIT_RPT = "VISN Network Audit Report";
        public const string VISN_CONTRACT_RPT = "VISN Network Contract Report";
        public const string VISN_DISPOSITION_RPT = "VISN Network Disposition Report";
        public const string VISN_DIVERSION_RPT = "VISN Diversion Report";
        public const string VISN_EMERGENCY_MGMT_RPT = "VISN Emergency Management Report";

        public const string ICON_USAGE_RPT = "Icon Usage Report";
        public const string ICON_FLAG_RPT = "Audit Log Report";
        public const string ICON_FLAG_RPT_SELECT_RPT_PARAM = "SelectReport";

        public const string EMERGENCY_MANAGEMENT_REPORT = "Emergency Management Report";
        public const string ACTIVE_TRANSFER_REPORT = "Active Transfer Orders Report";
        public const string BED_SWITCH_REPORT = "Bed Switch Report";
        public const string USER_ACCESS_REPORT = "User Access Report";

        public const string ROSTER = "Roster";
        public const string REGULATE = "Regulate";
        public const string MANIFEST = "Manifest";
        public const string TRANSFER = "Patient Transfer";

        public const string WAIT_LIST_STATUS_REPORT = "Patients Pending Bed Placement List Status Report";
        #endregion

        #region Report Parameters

        public const string REP_GENERAL_FACILITY_EXTENSION = "FacilityExtension";
        public const string REP_GENERAL_FACILITY_EXTENSION_TO_UPPER = "FACILITY_EXTENSION";
        public const string REP_GENERAL_RETURN_URL = "ReturnUrl";
        public const string REP_GENERAL_RETURN_TEXT = "ReturnText";
        public const string REP_GENERAL_RETURN_PATH = "ReturnPath";
        public const string REP_GENERAL_FACILITY_CODE = "FACILITY_CODE";
        public const string REP_GENERAL_IS_ROSTER_REPORT = "IS_ROSTER_REPORT";
        public const string REP_GENERAL_IS_REGULATE_REPORT = "IS_REGULATE_REPORT";
        public const string REP_GENERAL_IS_MANIFEST_REPORT = "IS_MANIFEST_REPORT";
        public const string REP_GENERAL_IS_TRANSFER_REPORT = "IS_TRANSFER_REPORT";
        public const string REP_GENERAL_REPORT_TYPE = "REPORT_TYPE";
        public const string REP_GENERAL_DEFAULT_DIVISION_ID = "DEFAULT_SELECTED_DIVISION_ID";
        public const string REP_GENERAL_DEFAULT_DIVISION_NAME = "DIVISION_NAME";
        public const string REP_GENERAL_WARDGROUP_ID = "WardgroupId";
        public const string REP_VISN_BED_SUMMARY_VISN_ROOT = "VisnRoot";
        public const string REP_VISN_BED_SUMMARY_VISN_EXTENSION = "VisnExtension";

        public const string REP_PATIENT_INQUIRY_IS_DISCH_ORDER_ACTIVE = "IS_DISCHARGE_ORDER_ACTIVE";
        public const string REP_PATIENT_INQUIRY_IS_ANTICIPATED_DISCH_ORDER_ACTIVE = "IS_ANTICIPATED_DISCHARGE_ORDER_ACTIVE";
        public const string REP_PATIENT_INQUIRY_IS_DISCH_APPOINTMENT_ACTIVE = "IS_DISCHARGE_APPOINTMENT_ACTIVE";
        public const string REP_PATIENT_INQUIRY_IS_TRANSFER_ORDER_ACTIVE = "IS_TRANSFER_ORDER_ACTIVE";

        public const string REP_GENERAL_FACILITIES = "FACILITIES";

        public const string REP_NEW_EVENT_START_DATE = "StartDate";
        public const string REP_NEW_EVENT_END_DATE = "EndDate";
        public const string REP_TIME_ZONE_MINUTES_OFFSET = "TimeZoneMinutesOffset";
        public const string REP_BED_SPECIALTY_ROSTER_TYPEGROUP = "TypeGroup";
        public const string REP_SCHEDULED_ADMISSIONS_REPORT_NEXT_DAYS = "NextDays";
        public const string REP_PATIENT_MOVEMENT_REPORT_DATE = "Date";
        public const string REP_PATIENT_MOVEMENT_REPORT_TRANSATION = "Transation";
        public const string REP_VISN_NETWORK_VISN_EXTENSION = "VISN_EXTENSION";
        public const string REP_EDIT_PT_IEN = "PatientIEN";
        public const string REP_EDIT_PT_IDENTIFIER = "PatientIdentifier";
        public const string REP_ADMITTED_PATIENT_TRANS = "Trans";
        public const string REPORT_TITLE = "Title";
        public const string REP_SCHEDULED_ADMISSION_MEDICAL_DIVISION = "MedicalCenterID";
        public const string REP_PAGE_TITLE = "PageTitle";

        public const string REP_IS_ROSTER_REPORT = "IS_ROSTER_REPORT";
        public const string REP_IS_REGULATE_REPORT = "IS_REGULATE_REPORT";
        public const string REP_IS_MANIFEST_REPORT = "IS_MANIFEST_REPORT";

        public const string REP_SELECT_REPORT = "SelectReport";
        public const string REP_REGION_EXTENSIONS = "REGION_EXTENSIONS";
        public const string REP_VISN_EXTENSIONS = "VISN_EXTENSIONS";
        public const string REP_FACILITIES_IDS = "FACILITIES_IDS";
        public const string REP_IS_FACILITY = "IsFacilityReport";

        public const string REP_USER_SALT = "UserSalt";
        public const string REP_CURRENT_USER = "CurrentUser";

        #endregion

        public const string REPORTS_ERROR_MESSAGE_SESSION_KEY = "ReportsErrorMsg";
        #region Roots for HL7 entities

        /// <summary>
        /// root for VISN.
        /// </summary>
        public const string VISNROOT = "VISN";

        /// <summary>
        /// root for REGION.
        /// </summary>
        public const string REGION_ROOT = "REGION";

        /// <summary>
        /// root for Facility.
        /// </summary>
        public const string FACILITYROOT = "FACILITY";

        /// <summary>
        /// root for Division.
        /// </summary>
        public const string DIVISIONROOT = "DIVISION";

        /// <summary>
        /// root for Ward.
        /// </summary>
        public const string WARDROOT = "WARD";

        /// <summary>
        /// root for User.
        /// </summary>
        public const string USERROOT = "USER";

        /// <summary>
        /// root for SSN.
        /// </summary>
        public const string SSNROOT = "SSN";

        /// <summary>
        /// root for Patient.
        /// </summary>
        public const string PATIENTROOT = "PATIENT";

        /// <summary>
        /// root for Act.
        /// </summary>
        public const string ACTROOT = "ACT";

        /// <summary>
        /// root for Bed
        /// </summary>
        public const string BEDROOT = "BED";

        public const string ADMISSIONROOT = "InfoWorld";

        #endregion

        public const int DEFAULT_EVS_CACHE_SIZE = 1024;
        public const string APP_SETTINGS_EVS_CACHE_SIZE = "BMS.EVSDictionaryCacheSize";
        public const string APP_SETTING_VA_URL = "VAURL";
        public const string APP_SETTING_TICKET_URL = "TICKETURL";
        public const string HOME_PAGE_REFRESH_RATE = "HomePageRefreshRate";

        public const string MIME_TEXT = "text/plain";
        public const string EVS_Language_code = "en";
        public const string HTTP_SESSION_ID_HTTP_HEADER = "HTTP_SESSION_ID_HTTP_HEADER";

        public const string SMTP_HOST = "SmtpHost";
        public const string BED_OUT_OF_SERVICE = "BED_OOS";
        public const string ADMISSION_ORDER = "ADM_ORDER";
        public const string CANCEL_ORDER = "CNC_ORDER";
        public const string ANTICIPATED_DISCHARGE_ORDER = "ANTIC_DISCH_ORDER";
        public const string DISCHARGE_APPOINTMENT = "DISCH_APP";
        public const string DISCH_ORDER = "DISCH_ORDER";
        public const string TRANSFER_ORDER = "TRSF_ORDER";
        public const string BED_SWITCH = "BED_SWITCH";
        public const string ISOLATION = "ISOLATION";
        public const string ADM_ORD = "ADM_ORD";
        public const string DISCH_ORD = "DISCH_ORD";
        public const string TRSF_ORD = "TRSF_ORD";
        public const string ANTIC_DISCH = "ANTIC_DISCH";

        #region EmsNotifications
        public const string NotificationsAdd = "Notifications Add";
        public const string EMSBedNotificationEdit = "EMS Bed Notification Edit";

        public const string EMS_NOTIFICATION = "EMSNotification";
        public const string EMS_EMAIL = "EMSEmail";
        public const string EMS_DIRTY = "EMSDirty";
        public const string EMS_CLEANED = "EMSCleaned";
        public const string EMS_BED_CONTROLLER_EMAIL = "EMSBedControllerEmail";
        public const string EMS_BED_CONTROLLER_DIRTY = "EMSBedControllerDirty";
        public const string EMS_BED_CONTROLLER_CLEANED = "EMSBedControllerCleaned";
        public const string EMS_VISTA_GROUP_MAIL = "EMSVistaGroupMail";
        public const string EMS_VISTA_GROUP_DIRTY = "EMSVistaGroupDirty";
        public const string EMS_VISTA_GROUP_CLEANED = "EMSVistaGroupCleaned";

        #endregion

        #region EventNotifications
        public const string EventNotificationsAdd = "Event Notifications Add";
        public const string EventNotificationsEdit = "Event Notifications Edit";

        public const string EVENT_NOTIFICATION = "EventNotification";
        public const string EVENT_BED_CONTROLLER_EMAIL = "EventBedControllerEmail";
        public const string EVENT_BED_CONTROLLER_NOTIFY = "EventBedControllerNotify";
        public const string EVENT_OTHER_EMAIL = "EventOtherEmail";
        public const string EVENT_OTHER_NOTIFY = "EventOtherNotify";
        #endregion

        #region VocabularyCodeSystemConstants
        public const string OrderableItemCodeSystem = "2.12.24.38";
        public const string ADTOrderableItemCodeSystem = "2.12.24.34";
        public const string ADTOrderableItem = "ADTOrderableItem";
        public const string WaitingAreaCodeSystem = "2.12.24.8";
        public const string UnavailableReason = "UnavailableReason";
        public const string UnavailableReasonCodeSystem = "2.12.24.33";
        public const string VistaSpecialtyCodeSystem = "2.12.24.39";
        public const string TypeOfMovementCodeSystem = "2.12.24.43";
        public const string VistaTreatingSpecialtyCodeSystem = "2.12.24.44";
        public const string MedicalCenterDivisionCodeSystem = "2.12.24.47";
        public const string CommentsCodeSystem = "2.12.24.48";
        #endregion

        #region VocabularyConceptCodeConstants

        public const string QuickDateToday = "0TODAY";
        public const string QuickDate1D = "1D";
        public const string QuickDate2D = "2D";
        public const string QuickDate3D = "3D";
        public const string QuickDate4D = "4D";
        public const string QuickDate5D = "5D";
        public const string QuickDate6D = "6D";
        public const string QuickDate7D = "7D";

        public const string SELECT_REPORT_ACTIVE = "ACTIVE";
        public const string SELECT_REPORT_DISP = "DISP";
        public const string SELECT_REPORT_CONTRACT = "CONTRACT";
        public const string SELECT_REPORT_DATE_AUDIT = "DATE_AUDIT";

        public const string TRANSFER_EVENT_DT = "TransferEventDT";

        public const string ORDERABLE_ITEM_TYPE_ADMISSION_CODE = "ADM";
        public const string ORDERABLE_ITEM_TYPE_TRANSFER_CODE = "TRF";
        public const string ORDERABLE_ITEM_TYPE_DISCHARGE_CODE = "DIS";
        public const string ORDERABLE_ITEM_TYPE_AUTOMATIC_ICON_CODE = "AMI";

        public const string CONCEPT_PROPERTY_IEN = "IEN";
        public const string CONCEPT_PROPERTY_ORDERABLE_ITEM_TYPE = "OrderableItemType";

        public const string NATIONAL_VOCABULARY_CODE_PREFIX = "NATIONAL_";

        #endregion

        #region Bed Board Module
        public const string BED_BOARD_MODULE = "BedBoardModule";
        public const string BED_BOARD_MODULE_CURRENTLY_IN_USE = "CurrentlyInUse";

        #endregion

        #region Settings

        public const string SETTINGS_SisterSites = "Sister Sites";
        public const string SETTINGS_Profile = "Profile";

        #endregion

        #region VistASetttings
        public const string VISTA_SETTINGS = "VistASettings";
        public const string VISTA_SETTINGS_SITE_TIME_ZONE = "VistASiteTimeZone";
        public const string VISTA_SETTINGS_LOCALTIMEADJUST = "VistALocalTimeAdjust";
        #endregion

        #region FacilitySettings

        public const string FACILITY_SETTINGS = "FacilitySettings";
        public const string FACILITY_SETTINGS_BMS_SERVER_TIME_ZONE = "BMSServerTimeZone";
        public const string FACILITY_SETTINGS_SITE_TIME_ZONE = "FacilitySiteTimeZone";
        public const string FACILITY_SETTINGS_LOCALTIMEADJUST = "LocalTimeAdjust";
        public const string FACILITY_SETTINGS_AUTO_REMOVAL_WAITING_LIST = "AutoRemovalWaitingList";
        public const string FACILITY_SETTINGS_AUTO_PLACEMENT_TRANSFER_LIST = "AutoPlacementTransferList";
        public const string FACILITY_SETTINGS_INTEGRATED_FACILITY = "IntegratedFacility";
        public const string FACILITY_SETTINGS_ALLOWED_ACCESS = "AllowedAccessIntegratedSites";
        public const string FACILITY_SETTINGS_MEDICAL_CENTER_ID = "MedicalCenterID";
        public const string FACILITY_SETTINGS_WARD_PREFIX = "WardPrefix";
        public const string FACILITY_SETTINGS_WARD_SUFFIX = "WardSuffix";
        public const string FACILITY_SETTINGS_ADT_PREFIX = "ADTPrefix";
        public const string FACILITY_SETTINGS_ADT_SUFFIX = "ADTSuffix";
        public const string FACILITY_SETTINGS_FACILITY_NAME = "FacilityName";
        public const string FACILITY_SETTINGS_FACILITY_ADDRESS1 = "FacilityAddress1";
        public const string FACILITY_SETTINGS_FACILITY_ADDRESS2 = "FacilityAddress2";
        public const string FACILITY_SETTINGS_SITEALIAS1 = "SiteAlias1";
        public const string FACILITY_SETTINGS_SITEALIAS2 = "SiteAlias2";
        public const string FACILITY_SETTINGS_SITEALIAS3 = "SiteAlias3";
        public const string FACILITY_SETTINGS_EMSMAILSENDER = "EMSMailSender";
        public const string FACILITY_SETTINGS_EVENTMAILSENDER = "EventMailSender";
        public const string FACILITY_SETTINGS_BPMAILMONITOR = "BPMailMonitor";
        public const string FACILITY_SETTINGS_INTEGRATED_SITE_SISTER_ID = "IntegratedSiteSisterConfigKey";
        public const string FACILITY_SETTINGS_EMS_USER_NAME = "EMSUserName";
        public const string FACILITY_SETTINGS_EMS_PASSWORD = "EMSPassword";
        public const string FACILITY_SETTINGS_KIOSK_USER_NAME = "KioskUserName";
        public const string FACILITY_SETTINGS_KIOSK_PASSWORD = "KioskPassword";
        public const string FACILITY_SENTTINGS_EMPTY_MEDICAL_CENTER_CODE = "EMPTY_CODE";
        #endregion

        #region Admin

        public const string VISTA_SITE_SETTINGS = "VistASiteSettings ";
        public const string VISTA_SITE_SETTINGS_NAME = "Name";
        public const string VISTA_SITE_SETTINGS_TIMEZONE = "TimeZone";
        public const string VISTA_SITE_SETTINGS_ODBC_USER = "OdbcUser";
        public const string VISTA_SITE_SETTINGS_ODBC_PASSWORD = "OdbcPassword";
        public const string VISTA_SITE_SETTINGS_ODBC_CONNECTION_STRING = "OdbcConnectionString";
        public const string VISTA_SITE_SETTINGS_VISTA_NUMBER = "MDWSVistANumber";
        public const string VISTA_SITE_SETTINGS_RETRIEVAL_DETAIL = "RetrievalDetail";
        public const string VISTA_SITE_SETTINGS_RETRIEVAL_DETAIL_METHOD = VISTA_SITE_SETTINGS_RETRIEVAL_DETAIL + "Method";
        public const string VISTA_SITE_SETTINGS_RETRIEVAL_DETAIL_IS_HL7_ENABLED = VISTA_SITE_SETTINGS_RETRIEVAL_DETAIL + "IsHL7Enabled";
        public const string VISTA_SITE_SETTINGS_MDWS_URL_CONFIG_KEY = "MDWSEndpointConfigKey";
        public const string VISTA_SITE_SETTINGS_RETRIEVAL_DETAIL_CALENDAR = VISTA_SITE_SETTINGS_RETRIEVAL_DETAIL + "Calendar";
        public const string VISTA_SITE_RETRIEVAL_DETAIL_CALENDAR_LAST_RUN = VISTA_SITE_SETTINGS_RETRIEVAL_DETAIL + "LastRun";
        public const string VISTA_SITE_SETTINGS_RETRIEVAL_DETAIL_METHOD_WAITINGLIST = "RetrievalDetailMethodPatientsPendingBedPlacementList";
        public const string VISTA_SITE_SETTINGS_RETRIEVAL_DETAIL_CALENDAR_WAITINGLIST = "RetrievalDetailCalendarPatientsPendingBedPlacementList";
        public const string VISTA_SITE_SETTINGS_RETRIEVAL_DETAIL_HL7_ENABLED_WAITINGLIST = "RetrievalDetailIsHL7EnabledPatientsPendingBedPlacementList";

        public const string JOB_CALENDAR = "JobCalendar ";

        public const string JOB_AUDIT_QUERY_START_DATE = "StartDate";
        public const string JOB_AUDIT_QUERY_END_DATE = "EndDate";

        public const string CHECK_BOX_CONTAINER_VISTA_SITES = "vistaSitesCheckBoxContainer";
        public const string CHECK_BOX_CONTAINER_DATA_TYPES = "dataTypesCheckBoxContainer";
        public const string CHECK_BOX_CONTAINER_RETRIEVAL_METHODS = "retrievalMethodsCheckBoxContainer";
        public const string CHECK_BOX_CONTAINER_STATUS = "statusCheckBoxContainer";

        public const string NUMI_ENTRY = "NumiEntry";

        public const string WHITEBOARD_REPORT_ENTRY = "WhiteboardReportEntry";

        public const string Mdws_Endpoint_Url = "MdwsEndpointUrl";

        public const string Via_Endpoint_Url = "ViaEndpointUrl";
        public const string Via_Requesting_App = "ViaRequestingApp";
        public const string Via_App_Token = "ViaAppToken";
        public const string Via_App_Password = "ViaAppPassword";

        #endregion

        public const string EVACUATION = "EVACUAT";
        public const string IS_EVACUATION = "IsEvacuation";
        public const string OFF = "Off";
        public const string ON = "On";
        public const string MARQUEE_TEXT = "MarqueeText";
        public const string MARQUEE_ACTIVE_INDEX = "ActiveIndex";
        public const string APPLICATION_PARAMETERS = "ApplicationParameters";
        public const string APPLICATION_PARAMETERS_CLINICAL_INVENTORY = "ClinicalInventory";
        public const string APPLICATION_PARAMETERS_NPP_ALERT_EMAIL = "NPPAlertEmail";
        public const string ORDERABLE_ITEM_TYPE_ADMISSION = "ADMISSION";
        public const string ORDERABLE_ITEM_TYPE_TRANSFER = "TRANSFER";
        public const string ORDERABLE_ITEM_TYPE_DISCHARGE = "DISCHARGE";
        public const string ORDERABLE_ITEM_TYPE_AUTOICON = "AUTO-ICON";
        public const string ORDERABLE_ITEM_TYPE_Cancelled_Admission = "CANCELLED ADMISSION";
        public const string WAITING_LIST_USER_SETTINGS = "WaitingListUserSettings";

        public const decimal PATIENT_MOVEMENT_TRANSACTION_ADMISSION_MIN = 1;
        public const decimal PATIENT_MOVEMENT_TRANSACTION_ADMISSION_MAX = 1.1M;
        public const decimal PATIENT_MOVEMENT_TRANSACTION_TRANSFER_MIN = 2;
        public const decimal PATIENT_MOVEMENT_TRANSACTION_TRANSFER_MAX = 2.1M;
        public const decimal PATIENT_MOVEMENT_TRANSACTION_DISCHARGE_MIN = 3;
        public const decimal PATIENT_MOVEMENT_TRANSACTION_DISCHARGE_MAX = 3.1M;
        public const decimal PATIENT_MOVEMENT_TRANSACTION_SPECIALTY_TRANSFER_MIN = 6;
        public const decimal PATIENT_MOVEMENT_TRANSACTION_SPECIALTY_TRANSFER_MAX = 6.1M;

        public const string ACT_OPERATION_TYPE_INTENT = "INT";
        public const string ACT_OPERATION_TYPE_REQUEST = "REQ";
        public const string ACT_OPERATION_TYPE_EVENT = "EVN";

        public const string BED_OUT_OF_SERVICE_VACABULARY_CODE = "OUT_OF_SERVICE";
        public const string BED_OUT_OF_SERVICE_TYPE_CODE = "OOS";
        public const string BED_DO_NOT_DISPLAY_TYPE_CODE = "DND";
        public const string BED_OOS_FROM_VISTA = "BED_OOS_VISTA";
        public const string BED_OOS_FROM_BEDBOARD = "BED_OOS_BEDBOARD";
        public const string NATIONAL_BED_OUT_OF_SERVICE_CODE = "NATIONAL_OUT_OF_SERVICE";

        public const string BED_IN_ISOLATION_TYPE_CODE = "ISO";
        public const string BED_AVAILABILITY_STATUS_ISOLATION_CODE = "BED_ISOLATION";

        public const string VISN_Add_Transfer_Operation_Permission = "Transfer, AddTranfer Update";
        public const string VISN_Edit_Transfer_Operation_Permission = "Transfer, EditTransfer Update";
        public const string VISN_Finalize_Transfer_Operation_Permission = "Transfer, FinalizeTransfer Update";

        public const string Whiteboard_Edit_Staff_Permission = "WardWhiteBoard, WardWhiteBoard Update";

        public const string WAIT_LIST_STATUS_REPORT_PERMISSION = "rep, Wait List Status Report";

        #region Discharge Status

        public const string DISCHARGE_ORDER = "DISCH_ORDERED";
        public const string DISCHARGE_ANTICIPATED = "ANTIC_DISCH_APP";
        public const string INTERNAL_TRANSFER = "INTER_TRF";

        #endregion

        #region NUMI Level Of Care

        public const string NUMI_LEVEL_OF_CARE_YES = "NUMI_LEVEL_OF_CARE_MET";
        public const string NUMI_LEVEL_OF_CARE_NO = "NUMI_LEVEL_OF_CARE_NOT_MET";
        public const string NUMI_LEVEL_OF_CARE_STAT = "NUMI_LEVEL_OF_CARE_NOT_REVIEWED";

        #endregion

        #region Bed Clean Status

        public const string BED_CLEANED = "BED_CLEANED";
        public const string CLEANING_BED = "CLEANING_BED";
        public const string BED_NEEDS_CLEAN = "BED_NEEDS_CLEAN";
        public const string EMS_NOTIFIED = "EMS_NOTIFIED";

        #endregion

        #region Disposition Code

        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1707:IdentifiersShouldNotContainUnderscores")]
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1709:IdentifiersShouldBeCasedCorrectly", MessageId = "COMMENT")]
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1709:IdentifiersShouldBeCasedCorrectly", MessageId = "OTHER")]
        public const string OTHER_COMMENT = "OtherComment";
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1707:IdentifiersShouldNotContainUnderscores")]
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1709:IdentifiersShouldBeCasedCorrectly", MessageId = "ADMISSION")]
        public const string VA_ADMISSION = "VAAdmission";

        #endregion

        #region Era Code
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1709:IdentifiersShouldBeCasedCorrectly", MessageId = "OTHER")]
        public const string OTHER = "Other";
        #endregion

        #region HL7 message types

        public const string AdmissionEventMessageType = "A01";
        public const string TransferEventMessageType = "A02";
        public const string DischargeEventMessageType = "A03";
        public const string RegisterPatientEventMessageType = "A04";

        #endregion

        #region ApplicationModule
        public const string EMS_MODULE = "BED_CLN";
        #endregion

        #region Whiteboard

        public const string SORT_BY_STAFF_OR_ATTENDING_ASCENDING = "Staff/Attending (ascending)";
        public const string SORT_BY_STAFF_OR_ATTENDING_DESCENDING = "Staff/Attending (descending)";
        public const string SORT_BY_STAFF_ASCENDING = "Staff (ascending)";
        public const string SORT_BY_STAFF_DESCENDING = "Staff (descending)";
        public const string SORT_BY_ATTENDING_ASCENDING = "Attending (ascending)";
        public const string SORT_BY_ATTENDING_DESCENDING = "Attending (descending)";
        public const string SORT_BY_WARD_ASCENDING = "Ward (ascending)";
        public const string SORT_BY_WARD_DESCENDING = "Ward (descending)";

        public const string STAFF = "Staff";
        public const string ATTENDING = "Attending";
        public const string STAFF_ATTENDING = "Staff and Attending";

        public const string DISPLAY_PT_FIRST_AND_LAST4_CODE = "FirstAndLast4";
        public const string DISPLAY_PT_LAST_NAME_CODE = "LastName";

        #endregion

        #region Icons

        public const string APPLICATION_ICON = "APPLICATION_ICON";
        public const string SYSTEM_ICON = "SYSTEM_ICON";
        public const string BED_CLEANING_ICON = "BED_CLEANING_ICON";
        public const string SIMILAR_SAME_NAME = "SIMILAR_SAME_NAME";
        public const string WHITEBOARD_ICON = "WHITEBOARD_ICON";
        public const string STANDARD_ICON = "STANDARD_ICON";
        public const string EMERGENCY_ICON = "EMERGENCY_ICON";
        public const string SITE_CONFIGURABLE_ICON = "SITE_CONFIGURABLE_ICON";
        public const string BED_ISOLATION = "BED_ISOLATION";
        public const string IMAGE_BYTES = "ImageBytes";
        public const string IMAGE_BYTES_INACTIVE = "ImageBytesInactive";
        public const string IMAGE_NAME = "ImageName";
        public const string PATIENT_ICON_CODE = "PATIENT_ICON";
        public const string ROOM_BED_ICON_CODE = "ROOM_BED_ICON";
        public const string WHITEBOARD = "WHITEBOARD";

        #endregion

        public const int WAITING_LIST_INACTIVATE_TIMEOUT_DAYS = 90;
        public const int WAITING_LIST_INACTIVATE_TIMEOUT_MINUTES = 0;

        #region wf start method names

        public const string WAITING_LIST_FLOW_CREATE_ITEM = "CreateWaitingListItem";
        public const string WAITING_LIST_FLOW_UNDO_REMOVE_ITEM = "UndoRemoveFromWaitingList";
        public const string TRANSFER_FLOW_CREATE_REQUEST = "CreateTransferRequest";
        public const string BED_CLEAN_FLOW_CREATE_REQUEST = "CreateBedCleanRequest";
        public const string BED_UNAVAILABLE_CREATE = "CreateBedUnavailable";
        public const string BED_CLEAN_FLOW_COMPLETE_REQUEST = "CompleteBedCleanRequest";
        public const string BED_CLEAN_FLOW_UPDATE_REQUEST = "UpdateBedCleanRequest";


        #endregion

        public const int MAX_BED_CONTROLLER_EMAIL_LENGTH = 300;
        public const int COMMENTS_MAX_LENGTH = 150;

        #region Bed Status Report Fields

        public const string PATIENT_FIELD = "Patient";
        public const string GENDER_FIELD = "Gender";
        public const string EVENT_TIME_FIELD = "Event Time";
        public const string REQUEST_DT_FIELD = "Request DT";
        public const string REMOVE_FROM_LIST_FIELD = "Removed From List";
        public const string CURRENT_WAIT_AREA_FIELD = "Current Wait Area";
        public const string RECORD_LAST_EDITED_BY_FIELD = "Last Edited By";
        public const string COMMUNITY_SERVICES_FIELD = "Community Services";
        public const string CONTRACTED_FIELD = "Contracted";
        public const string REASON_USING_FEE_FIELD = "Reason Using Fee";
        public const string ACUTE_FIELD = "Acute";
        public const string AUTHORIZED_FEE_FIELD = "Authorized Fee";
        public const string IN_HOUSE_TRANSFER_FIELD = "In House Transfer";
        public const string DATE_TIME_BED_REQUEST_FIELD = "Date/Time of Bed Request";
        public const string DATE_TIME_BED_ASSIGNED_FIELD = "Date/Time of Bed Assigned";
        public const string FEE_COMMENTS_FIELD = "Fee Comments";
        public const string ROOM_BED_ASSIGNED_FIELD = "Room/Bed Assigned";
        public const string TYPE_OF_BED_WARD_REQUIRED_FIELD = "Type of Bed/Ward Required";
        public const string PRESENTING_PROBLEM_FIELD = "Presenting Problem";

        public const string PATIENT_FIELD_SQL = "PATIENT_NAME";
        public const string GENDER_FIELD_SQL = "PATIENT_GENDER_CODE";
        public const string EVENT_TIME_FIELD_SQL = "ENTERED_DATE";
        public const string REQUEST_DT_FIELD_SQL = "REQUESTED_DATE";
        public const string REMOVE_FROM_LIST_FIELD_SQL = "REMOVED_DATE";
        public const string CURRENT_WAIT_AREA_FIELD_SQL = "WAITING_AREA_CODE";
        public const string RECORD_LAST_EDITED_BY_FIELD_SQL = "LAST_EDIT_BY";
        public const string COMMUNITY_SERVICES_FIELD_SQL = "SERVICE_RECEIVING_FEE_CODE";
        public const string CONTRACTED_FIELD_SQL = "CONTRACT_FEE_CODE";
        public const string REASON_USING_FEE_FIELD_SQL = "REASON_USING_FEE_CODE";
        public const string ACUTE_FIELD_SQL = "FEE_DISPOSITION_CODE";
        public const string AUTHORIZED_FEE_FIELD_SQL = "AUTHORIZED_FEE_CODE";
        public const string IN_HOUSE_TRANSFER_FIELD_SQL = "IN_HOUSE";
        public const string DATE_TIME_BED_REQUEST_FIELD_SQL = "BED_REQUESTED_DATE";
        public const string DATE_TIME_BED_ASSIGNED_FIELD_SQL = "BED_ASSIGNED_DATE";
        public const string FEE_COMMENTS_FIELD_SQL = "FEE_COMMENTS";
        public const string ROOM_BED_ASSIGNED_FIELD_SQL = "BED_ASSIGNED_UID";
        public const string TYPE_OF_BED_WARD_REQUIRED_FIELD_SQL = "TYPE_OF_BED_WARD";
        public const string PRESENTING_PROBLEM_FIELD_SQL = "PRESENTING_PROBLEM";

        public const string DISPLAY = "Display";
        public const string FILTER = "Filter";
        public const string SORT = "Sort";

        public const string SortAscendingCode = "ASC";
        public const string SortDescendingCode = "DESC";
        public const string SortAscendingName = "Ascending";
        public const string SortDescendingName = "Descending";
        public const string SortNoneCode = "NONE";
        public const string SortNoneName = "None";
        public const string LIKE = "LIKE";
        public const string BETWEEN = "BETWEEN";

        #endregion

        public const string NUMA = "NUMA";
        public const string HAvBED = "HAvBED";
        public const string Hidden = "Hidden";
        public const string NUMACodeSystem = "2.12.24.56";
        public const string HAvBEDCodeSystem = "2.12.24.55";

        public const string BED_HOLD_TEXT = "BED HOLD";
        public const string BED_HOLD_CONCEPT_CODE = "BED_HOLD";

        public const string EMS_USER_ROLE = "EmsStaff";

        public const string EMS_Supervisor_Permission = "EmsBedStatusAdmin, EMS Supervisor Read/Update";

        #region Type Of Movement

        public const string AUTHORIZED_ABSENCE = "AUTHORIZED ABSENCE < THAN 96 HOURS";
        public const string UN_AUTHORIZED_ABSENCE = "UNAUTHORIZED ABSENCE";
        public const string WHILE_ASIH = "WHILE ASIH";
        public const string FROM_ASIH = "FROM ASIH";
        public const string RESUME_ASIH = "RESUME ASIH";

        #endregion

        public const string Mdws_Connection_Exception_Text_1 = "Mdws return a fault. Fault msj: An established connection was aborted by the software in your host machine";
        public const string Mdws_Connection_Exception_Text_2 = "Mdws return a fault. Fault msj: There is no logged in connection";
        public const string MDWS = "MDWS";
        public const string VIA = "VIA";
        public const string Mdws_Fault_Exception_Text = "Mdws return a fault. Fault msj";

        public const string CLEAR_ALL = "CLEAR-ALL";
    }
}
