﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Facade.Data;
using InfoWorld.HL7.ITS;
using BMS.Utils;
using BMS.FaultContracts;
using BMS.Facade.Fault;
using System.ServiceModel;
using BMS.Utils.Properties;

namespace BMS.ServicesWrapper.Proxy.WF
{
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    [System.ServiceModel.ServiceContractAttribute(Name = "BMS.Workflows.WF.IBedUnavailableFlow", ConfigurationName = "BMS.Workflows.WF.IBedUnavailableFlow")]
    public interface BMSWorkflowsWFIBedUnavailableFlow
    {
        [System.ServiceModel.OperationContractAttribute(ProtectionLevel = System.Net.Security.ProtectionLevel.EncryptAndSign, Action = "http://tempuri.org/BMS.Workflows.WF.IBedUnavailableFlow/CreateBedUnavailable", ReplyAction = "http://tempuri.org/BMS.Workflows.WF.IBedUnavailableFlow/CreateBedUnavailableResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(GenericWFServiceFault), Action = "http://tempuri.org/BMS.Workflows.WF.IBedUnavailableFlow/CreateBedUnavailableGener" +
            "icWFServiceFaultFault", ProtectionLevel = System.Net.Security.ProtectionLevel.EncryptAndSign, Name = "GenericWFServiceFault", Namespace = "http://schemas.datacontract.org/2004/07/BMS.Facade.Fault")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "pBedUnavailableId")]
        II CreateBedUnavailable(BedUnavailable pBedUnavailable);

        [System.ServiceModel.OperationContractAttribute(ProtectionLevel = System.Net.Security.ProtectionLevel.EncryptAndSign, Action = "http://tempuri.org/BMS.Workflows.WF.IBedUnavailableFlow/UpdateBedUnavailable", ReplyAction = "http://tempuri.org/BMS.Workflows.WF.IBedUnavailableFlow/UpdateBedUnavailableResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(GenericWFServiceFault), Action = "http://tempuri.org/BMS.Workflows.WF.IBedUnavailableFlow/UpdateBedUnavailableGener" +
            "icWFServiceFaultFault", ProtectionLevel = System.Net.Security.ProtectionLevel.EncryptAndSign, Name = "GenericWFServiceFault", Namespace = "http://schemas.datacontract.org/2004/07/BMS.Facade.Fault")]
        void UpdateBedUnavailable(BedUnavailable pBedUnavailable);

        [System.ServiceModel.OperationContractAttribute(ProtectionLevel = System.Net.Security.ProtectionLevel.EncryptAndSign, Action = "http://tempuri.org/BMS.Workflows.WF.IBedUnavailableFlow/CancelBedUnavailable", ReplyAction = "http://tempuri.org/BMS.Workflows.WF.IBedUnavailableFlow/CancelBedUnavailableResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(GenericWFServiceFault), Action = "http://tempuri.org/BMS.Workflows.WF.IBedUnavailableFlow/CancelBedUnavailableGener" +
            "icWFServiceFaultFault", ProtectionLevel = System.Net.Security.ProtectionLevel.EncryptAndSign, Name = "GenericWFServiceFault", Namespace = "http://schemas.datacontract.org/2004/07/BMS.Facade.Fault")]
        void CancelBedUnavailable(BedUnavailable pBedUnavailable);
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public interface BMSWorkflowsWFIBedUnavailableFlowChannel : BMSWorkflowsWFIBedUnavailableFlow, System.ServiceModel.IClientChannel
    {
    }

    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public partial class BMSWorkflowsWFIBedUnavailableFlowClient : System.ServiceModel.ClientBase<BMSWorkflowsWFIBedUnavailableFlow>, BMSWorkflowsWFIBedUnavailableFlow, IDisposable
    {
        #region ProxyTool Generated Code

        private BMSWorkflowsWFIBedUnavailableFlowClient _instance;
        private string _endpointConfigurationName;
        private string _remoteAddress;
        private System.ServiceModel.EndpointAddress _endpointAddress;
        private System.ServiceModel.Channels.Binding _binding;

        private void InitProxyInstance()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        if (_instance.State != System.ServiceModel.CommunicationState.Faulted)
                            _instance.Close();
                        else
                            _instance.Abort();
                }
                catch { }

                if (_binding != null)
                    _instance = new BMSWorkflowsWFIBedUnavailableFlowClient(_binding, _endpointAddress);
                else if (_endpointAddress != null)
                    _instance = new BMSWorkflowsWFIBedUnavailableFlowClient(_endpointConfigurationName, _endpointAddress);
                else if (_remoteAddress != null)
                    _instance = new BMSWorkflowsWFIBedUnavailableFlowClient(_endpointConfigurationName, _remoteAddress);
                else if (_endpointConfigurationName != null)
                    _instance = new BMSWorkflowsWFIBedUnavailableFlowClient(_endpointConfigurationName);
                else
                    _instance = new BMSWorkflowsWFIBedUnavailableFlowClient();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        void System.IDisposable.Dispose()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.Close();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Close()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<BMSWorkflowsWFIBedUnavailableFlow>)_instance).Close();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<BMSWorkflowsWFIBedUnavailableFlow>)this).Close();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Abort()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<BMSWorkflowsWFIBedUnavailableFlow>)_instance).Abort();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<BMSWorkflowsWFIBedUnavailableFlow>)this).Abort();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        public BMSWorkflowsWFIBedUnavailableFlowClient()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BMSWorkflowsWFIBedUnavailableFlowClient(string endpointConfigurationName) : base(endpointConfigurationName)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BMSWorkflowsWFIBedUnavailableFlowClient(string endpointConfigurationName, string remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _remoteAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BMSWorkflowsWFIBedUnavailableFlowClient(string endpointConfigurationName, System.ServiceModel.EndpointAddress remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BMSWorkflowsWFIBedUnavailableFlowClient(System.ServiceModel.Channels.Binding binding, System.ServiceModel.EndpointAddress remoteAddress) : base(binding, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _binding = binding;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public II CreateBedUnavailable(BedUnavailable pBedUnavailable)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.CreateBedUnavailable(pBedUnavailable);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.CreateBedUnavailable(pBedUnavailable);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BMSWorkflowsWFIBedUnavailableFlowClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateBedUnavailable(BedUnavailable pBedUnavailable)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateBedUnavailable(pBedUnavailable);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateBedUnavailable(pBedUnavailable);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BMSWorkflowsWFIBedUnavailableFlowClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void CancelBedUnavailable(BedUnavailable pBedUnavailable)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.CancelBedUnavailable(pBedUnavailable);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.CancelBedUnavailable(pBedUnavailable);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BMSWorkflowsWFIBedUnavailableFlowClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
