﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
using System.ServiceModel.Activities;
using System.ServiceModel;
using System.Activities;
using System.ServiceModel.Channels;
using System.Xml.Serialization;
using System.IO;

namespace BMS.Workflows.CustomActivities.Utils
{
    /// <summary>
    /// Message inspector to set the current OperationContext
    /// </summary>
    [DataContract]
    public class GetMessageOperationContextInspector : IReceiveMessageCallback
    {
        //do not add the DataMember attribute. Because of a WF4 bug, this gets serialized improperly and the flow never goes to Idle status/
        public OperationContext CurrentOperationContext { get; set; }

        public void OnReceiveMessage(OperationContext operationContext,
            ExecutionProperties activityExecutionProperties)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                CurrentOperationContext = operationContext;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}