﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Activities;
using BMS.Facade.Data;
using BMS.Utils;
using InfoWorld.HL7.ITS;
using BMS.Facade;
using BMS.ServicesWrapper.WF;
using BMS.ServicesWrapper.EVS;
using FC = BMS.Facade.Data;

namespace BMS.Workflows.CustomActivities
{
    public class CreateAdmissionForTransfer : CodeActivity
    {
        public InArgument<Transfer> TransferEvent { get; set; }
        public InArgument<Transfer> TransferRequest { get; set; }

        protected override void Execute(CodeActivityContext context)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                Transfer transferRequest = this.TransferRequest.Get<Transfer>(context);
                Transfer transferEvent = this.TransferEvent.Get<Transfer>(context);
                DateTime date = DateTime.UtcNow;

                if (transferEvent.Disposition != null && transferEvent.Disposition.code != null && transferEvent.Disposition.code == BMS.Utils.Constants.VA_ADMISSION)
                {
                    WaitingListItem waitingListItem = new WaitingListItem()
                    {
                        Id = new II(transferEvent.Id.root, null),
                        Patient = transferEvent.Patient,
                        Parent = new Act() { Id = transferEvent.Id },
                        FlowId = transferRequest.FlowId,
                        CreationDate = date,
                        RequestedDate = date,
                        Problem = transferRequest.Diagnosis,
                        TypeOfBedWard = transferRequest.Comment,
                        Facility = transferEvent.FacilityTo,
                        VistaSite = transferEvent.FacilityTo.VistaSite,
                        LastEditBy = transferEvent.LastEditBy,
                        IsCommunityLivingCenter = false
                    };

                    WFFactory.WaitingListFlowClientFromWCF.CreateWaitingListItem(waitingListItem);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
