using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Facade.Data;
using BMS.ServicesWrapper.EIS;
using InfoWorld.HL7.ITS;
using BMS.Utils;
using BMS.ServicesWrapper.EVS;
using BMS.ServicesWrapper.WF;
using System.ServiceModel;
using BMS.DataContracts;
using BMS.ServicesWrapper.BMService;
using BMS.VistaIntegration.Data;
using System.Configuration;
using BMS.Facade;
using BMS.FaultContracts;
using BMS.Facade.Translators;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete.WF
{
    public class Utils
    {
        Dictionary<string, List<Facility>> facilitiesByVista = new Dictionary<string, List<Facility>>();
        Dictionary<string, List<Module>> modulesByFacility = new Dictionary<string, List<Module>>();
        Dictionary<string, List<Division>> divisionsByFacility = new Dictionary<string, List<Division>>();
        Dictionary<string, FacilitySettings> settingsByFacility = new Dictionary<string, FacilitySettings>();
        object _lock = new object();

        internal void FillVistaData(II vistaId)
        {
            lock (_lock)
            {
                if (!facilitiesByVista.ContainsKey(vistaId.extension))
                    facilitiesByVista.Add(vistaId.extension, EISFactory.InstanceFromWCF.GetFacilities(vistaId).ToList());
                foreach (Facility f in facilitiesByVista[vistaId.extension])
                {
                    if (!modulesByFacility.ContainsKey(f.Id.extension))
                        modulesByFacility.Add(f.Id.extension, FacadeManager.ConfigurationInterface.GetModules(vistaId.root, f.Id).ToList());
                    if (!divisionsByFacility.ContainsKey(f.Id.extension))
                        divisionsByFacility.Add(f.Id.extension, EISFactory.InstanceFromWCF.GetDivisions(f.Id).ToList());
                    if (!settingsByFacility.ContainsKey(f.Id.extension))
                        settingsByFacility.Add(f.Id.extension, FacadeManager.ConfigurationInterface.GetFacilitySettings(f.Id));
                }
            }
        }

        public void GenerateBedCleanRequest(string ien, II bedId, II wardId, II vistaSiteId, TimeZoneInfo vistaTimeZone, DateTime requestDate, DateTime vacatedDate, string eventType)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                FillVistaData(vistaSiteId);
                List<Division> divisions = EISFactory.InstanceFromWCF.GetDivisionsForBed(bedId, vistaSiteId).ToList();
                List<Facility> facilities = new List<Facility>();
                if (divisions != null)
                    facilities = divisions.Select<Division, Facility>(division => new Facility() { Id = division.Facility.Id }).Distinct().ToList();
                if (facilities != null && facilities.Count > 0)
                {
                    List<Module> flags = null;
                    foreach (Facility f in facilities)
                    {
                        if (modulesByFacility.ContainsKey(f.Id.extension))
                        {
                            flags = modulesByFacility[f.Id.extension];
                            if (flags.Where(a => a.Code.Equals(Constants.EMS_MODULE, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault().CurrentlyInUse.code.Equals(Constants.No, StringComparison.InvariantCultureIgnoreCase))
                                divisions.RemoveAll(a => a.Facility.Id.extension.Equals(f.Id.extension, StringComparison.InvariantCultureIgnoreCase));
                        }
                    }
                }
                if (divisions != null && divisions.Count > 0)
                {
                    List<CD> strictDecisionList = EVSFactory.InstanceFromWCF.GetCodes(new CodeFilterParameters() { MaxSelectedCodes = int.MaxValue, VocabularyDomain = Util.Vocabulary.StrictDecision.ToString() }).ToList();
                    List<CD> decisionList = EVSFactory.InstanceFromWCF.GetCodes(new CodeFilterParameters() { MaxSelectedCodes = int.MaxValue, VocabularyDomain = Util.Vocabulary.Decision.ToString() }).ToList();
                    Ward ward = EISFactory.InstanceWindows.GetWard(wardId);
                    Division division = null;
                    if (ward != null && ward.DivisionList != null && ward.DivisionList.Count > 0)
                        division = ward.DivisionList[0];
                    BedCleaningOperation bedClean = new BedCleaningOperation()
                    {
                        Id = new II(bedId.root, null),
                        EventIen = ien,
                        BedId = bedId,
                        LastEditDate = DateTime.UtcNow,
                        LastEditedBy = null,
                        ManualRequest = strictDecisionList.Where(a => a.displayName == Constants.No).FirstOrDefault(),
                        RequestedDate = requestDate,
                        TypeOfClean = decisionList.Where(a => a.displayName == Constants.Yes).FirstOrDefault(),
                        WardId = wardId,
                        DivisionId = division != null ? division.Id : null,
                        VistaSiteId = vistaSiteId,
                        VacatedDate = vacatedDate,
                        EventType = eventType
                    };
                    bedClean.Id = BMSFactory.BedManagerOperationsClientFromWCF.CreateBedCleaningOperation(bedClean);
                    if (!bedClean.Id.extension.Equals("-2"))
                    {
                        if (facilities == null || facilities.Count == 0)
                            return;
                        Bed bed = EISFactory.InstanceFromWCF.GetBed(bedId, vistaSiteId);
                        IList<Ward> wards = null;
                        if (bed.WardList != null && bed.WardList.Count > 0)
                            wards = EISFactory.InstanceFromWCF.GetWards(bed.WardList.Select<Ward, II>(wrd => wrd.Id).ToList());
                        int mailsSent = 0;
                        List<EMSNotification> notifications = null;
                        foreach (Facility f in facilities)
                        {
                            if (!settingsByFacility.ContainsKey(f.Id.extension))
                                continue;
                            notifications = Facade.FacadeManager.ConfigurationInterface.GetEMSNotifications(f.Id.root, f.Id);

                            string from = settingsByFacility[f.Id.extension].EMSMailSender;
                            string to = string.Empty;

                            foreach (EMSNotification notification in notifications)
                            {
                                if (divisions.Where(a => a.Name.Equals(notification.Location, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault() != null)
                                {
                                    if (!bedClean.CompletedDate.HasValue)
                                    {
                                        if (notification.BedControllerDirty.code == Constants.Yes)
                                            to += (string.IsNullOrEmpty(to) ? "" : ",") + notification.BedControllerEmail;
                                        if (notification.EMSDirty.code == Constants.Yes)
                                            to += (string.IsNullOrEmpty(to) ? "" : ",") + notification.EMSEmail;
                                        if (notification.VistaGroupDirty.code == Constants.Yes)
                                            to += (string.IsNullOrEmpty(to) ? "" : ",") + notification.VistaGroupMail;
                                    }
                                    else
                                    {
                                        if (notification.BedControllerCleaned.code == Constants.Yes)
                                            to += (string.IsNullOrEmpty(to) ? "" : ",") + notification.BedControllerEmail;
                                        if (notification.EMSCleaned.code == Constants.Yes)
                                            to += (string.IsNullOrEmpty(to) ? "" : ",") + notification.EMSEmail;
                                        if (notification.VistaGroupCleaned.code == Constants.Yes)
                                            to += (string.IsNullOrEmpty(to) ? "" : ",") + notification.VistaGroupMail;
                                    }
                                }
                            }

                            if (!string.IsNullOrWhiteSpace(to) && !string.IsNullOrWhiteSpace(from))
                            {
                                //compose and send the actual message
                                string subject = bedClean.CompletedDate.HasValue ? "Bed cleaned" : "Dirty bed";
                                string bodyFormat = "RoomBed: {0}" + Environment.NewLine +
                                                    "Vista Ward: {1}" + Environment.NewLine +
                                                    (bedClean.CompletedDate.HasValue ? "Cleaned by: {4}" + Environment.NewLine : string.Empty) +
                                                    "Date/time: {2}" + Environment.NewLine +
                                                    "Isolation: {3}";

                                string isolation = Constants.No;
                                DataContracts.BedUnavailable bu = null;
                                try
                                {
                                    bu = BMSFactory.BedManagerOperationsClientFromWCF.GetBedUnavailable(null, bedId);
                                }
                                catch { }
                                if (bu != null && bu.Reason.code.Contains(Constants.ISOLATION))
                                    isolation = Constants.Yes;

                                DateTime dt = bedClean.RequestedDate.HasValue ? DateTime.SpecifyKind(bedClean.RequestedDate.Value, DateTimeKind.Unspecified) : DateTime.UtcNow;
                                string body = string.Format(bodyFormat,
                                    bed.Name,
                                    (wards != null && wards.Count > 0) ? String.Join("; ", wards.Select<Ward, string>(w => w.Name)) : string.Empty,
                                    TimeZoneInfo.ConvertTimeFromUtc(dt, vistaTimeZone).ToString("MM/dd/yy hh:mm"),
                                    isolation,
                                    bedClean.CompletedBy);

                                BMS.Utils.SendMail.Execute(from, to, subject, body, ConfigurationManager.AppSettings[Constants.SMTP_HOST], 25, null);
                                mailsSent++;
                            }
                        }
                        notifications = null;
                        if (mailsSent > 0)
                        {
                            bedClean.EMSNotify = bedClean.CompletedDate.HasValue ? null : Constants.Yes;
                            //update bedclean to include this flag
                            BMSFactory.BedManagerOperationsClientFromWCF.UpdateBedCleaningOperation(bedClean);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Tracer.TraceException(ex);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static void AutoRemoveWaitingListItem(II patientId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                DataContracts.WaitingListItem wlItem = null;
                Facade.Data.Patient patient = EISFactory.InstanceWindows.GetPatientById(patientId, null);
                try
                {
                    wlItem = BMSFactory.BedManagerOperationsClientFromWCF.GetWaitingListItem(null, patient.Id.extension);                                        
                }
                catch { }
                if (wlItem != null && wlItem.IsInHouse == false && wlItem.IsCommunityLivingCenter == false && wlItem.IsEvacuationPatient == false)
                {
                    if (GetAutoRemovalOption(wlItem.FacilityId))
                    {
                        Facility facility = null;
                        Bed bed = null;
                        if (wlItem.FacilityId != null)
                            facility = EISFactory.InstanceWindows.GetFacility(wlItem.FacilityId);                        
                        if (wlItem.RequestedBedId != null)
                            bed = EISFactory.InstanceWindows.GetBed(wlItem.RequestedBedId, wlItem.VistaSiteId);
                        Facade.Data.WaitingListItem wli = wlItem.ToFacadeContract(facility, patient, bed);

                        wli.Patient = patient;
                        wli.PatientId = patient.Id;
                        wli.RemovedDate = DateTime.UtcNow;
                        wli.LastEditBy = Constants.WL_AUTO_REMOVE_USER;                        
                        WFFactory.WaitingListFlowClientFromWCF.RemoveFromWaitingList(wli);
                    }
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private static bool GetAutoRemovalOption(II facilityId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                bool result = false;
                FacilitySettings settings = FacadeManager.ConfigurationInterface.GetFacilitySettings(facilityId);
                if (settings.AutoRemovalWaitingList != null && settings.AutoRemovalWaitingList.code == Constants.Yes)
                    result = true;                
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static bool GetAutoPlacementOption(II facilityId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                bool result = false;
                FacilitySettings settings = FacadeManager.ConfigurationInterface.GetFacilitySettings(facilityId);
                if (settings.AutoPlacementTransferList != null && settings.AutoPlacementTransferList.code == Constants.Yes)
                    result = true;
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void SendMailNotification(object request, II vistaSiteId, TimeZoneInfo vistaTimeZone, string orderType, AdmissionEvent currentAdmission, II patientId)
        {
            try
            {
                FillVistaData(vistaSiteId);
                List<Facility> facilities = facilitiesByVista[vistaSiteId.extension];
                facilities = GetFacilitiesWithFlags(orderType, vistaSiteId.root, facilities);
                if (facilities == null || facilities.Count == 0)
                    return;                
                AdmissionEvent admission = null;
                II wardId = null;
                //get TimeZoneInfo of the VistA Site
                TimeZoneInfo timeZoneInfo;
                if (vistaTimeZone != null)
                    timeZoneInfo = vistaTimeZone;
                else
                    timeZoneInfo = TimeZoneInfo.Local;

                if ((request as OrderAction) != null && !orderType.Equals(Constants.ADMISSION_ORDER))
                {                    
                    try
                    {
                        OrderAction oa = null;
                        oa = request as OrderAction;
                        if (oa != null)
                        {
                            admission = BMSFactory.BedManagerOperationsClientWindows.GetAdmissionEventForPatient(patientId, vistaSiteId, null, TimeZoneInfo.ConvertTimeToUtc(oa.DateTimeOrdered));
                            wardId = admission.WardId;
                        }
                    }
                    catch (FaultException<EntityNotFoundException>) { }
                }
                else if ((request as BedSwitch) != null)
                {
                    BedSwitch bs = null;
                    bs = request as BedSwitch;
                    if (bs != null)
                    {
                        wardId = bs.WardId;
                    }
                }
                else if ((request as PatientAppointment) != null)
                {
                    if (currentAdmission != null)
                        wardId = currentAdmission.WardId;
                }
                if (currentAdmission == null)
                    currentAdmission = admission;

                List<Division> divisions = new List<Division>();
                facilities.ForEach(f => { if (divisionsByFacility.ContainsKey(f.Id.extension)) divisions.AddRange(divisionsByFacility[f.Id.extension]); });
                if (wardId != null)
                {
                    Ward ward = EISFactory.InstanceWindows.GetWard(wardId);
                    if (ward.DivisionList == null || ward.DivisionList.Count == 0)
                        return;
                    divisions.RemoveAll(a => ward.DivisionList.Where(b => b.Id != null && !string.IsNullOrEmpty(b.Id.extension) && b.Id.extension.Equals(a.Id.extension, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault() == null);                    
                }
                if (divisions == null || divisions.Count == 0)
                    return;

                IList<EventNotification> notifications = null;
                foreach (Division division in divisions)
                {
                    if (!settingsByFacility.ContainsKey(division.Facility.Id.extension))                        
                        continue;
                    //get the notifications by facility and division
                    notifications = Facade.FacadeManager.ConfigurationInterface.GetEventNotification(division.Name, vistaSiteId.root, division.Facility.Id);

                    string from = settingsByFacility[division.Facility.Id.extension].EventMailSender;
                    string to = string.Empty;

                    foreach (EventNotification notification in notifications)
                    {
                        if (!notification.Name.Equals(orderType))
                            continue;
                        if (notification.BedControllerNotification.code == Constants.Yes)
                            to += (string.IsNullOrEmpty(to) ? "" : ",") + notification.BedControllerEmailAddress;
                        break;
                    }

                    if (!string.IsNullOrWhiteSpace(to) && !string.IsNullOrWhiteSpace(from))
                    {
                        string subject;
                        string body = GetMailMessageBody(request, orderType, vistaSiteId, timeZoneInfo, currentAdmission, out subject);

                        SendMail.Execute(from, to, subject, body, ConfigurationManager.AppSettings[Constants.SMTP_HOST], 25, null);
                    }
                }
                notifications = null;
            }
            finally
            {
                request = null;
                currentAdmission = null;                
            }
        }

        private List<Facility> GetFacilitiesWithFlags(string orderType, string domainId, List<Facility> facilities)
        {
            List<Module> flags = new List<Module>();
            List<Facility> tempFacilities = new List<Facility>();
            string flagCode = null;
            switch (orderType)
            {
                case Constants.ADMISSION_ORDER:
                    flagCode = Constants.ADM_ORD;                        
                    break;
                case Constants.ANTICIPATED_DISCHARGE_ORDER:
                    flagCode = Constants.ANTIC_DISCH;                        
                    break;
                case Constants.DISCH_ORDER:
                    flagCode = Constants.DISCH_ORD;                        
                    break;
                case Constants.TRANSFER_ORDER:
                    flagCode = Constants.TRSF_ORD;
                    break;
                case Constants.DISCHARGE_APPOINTMENT:
                    flagCode = Constants.DISCHARGE_APPOINTMENT;
                    break;
            }
            if (!string.IsNullOrEmpty(flagCode))
            {
                foreach (Facility f in facilities)
                {
                    if (modulesByFacility.ContainsKey(f.Id.extension))
                    {
                        flags = modulesByFacility[f.Id.extension];
                        if (flags.Where(a => a.Code.Equals(flagCode, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault().CurrentlyInUse.code.Equals(Constants.No, StringComparison.InvariantCultureIgnoreCase))
                            tempFacilities.Add(f);
                    }
                }
            }
            if (tempFacilities != null && tempFacilities.Count > 0)
            {
                return (from a in facilities
                        where !(from b in tempFacilities select b.Id.extension).Contains(a.Id.extension)
                        select a).ToList();
            }
            else
                return facilities;
        }

        private static string GetMailMessageBody(object request, string orderType, II vistaSiteId, TimeZoneInfo timeZoneInfo, AdmissionEvent admission, out string subject)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                string bodyFormat = string.Empty;
                string body = string.Empty;
                subject = string.Empty;
                OrderAction order = null;

                switch (orderType)
                {
                    case Constants.ADMISSION_ORDER:
                        order = null;
                        order = request as OrderAction;
                        if (order != null)
                        {
                            subject = "NEW ADMISSION ORDER";
                            bodyFormat = "ORDER ID: {0}" + Environment.NewLine +
                                         "Location:{1}" + Environment.NewLine +
                                         "Date Ordered:{2}" + Environment.NewLine +
                                         "Signed:{3}" + Environment.NewLine +
                                         "Date Signed:{4}" + Environment.NewLine +
                                         "Date Released:{5}";
                            body = string.Format(bodyFormat,
                                order.OrderId,
                                (order.Order != null && order.Order.HospitalLocation != null) ? order.Order.HospitalLocation.Name : String.Empty,
                                order.DateTimeOrdered.ToString("MM/dd/yy hh:mm"),
                                order.SignedBy != null ? order.SignedBy.Name : string.Empty,
                                (order.DateTimeSigned.HasValue ? order.DateTimeSigned.Value : DateTime.UtcNow).ToString("MM/dd/yy hh:mm"),
                                (order.ReleaseDateTime.HasValue ? order.ReleaseDateTime.Value : DateTime.UtcNow).ToString("MM/dd/yy hh:mm"));
                        }
                        break;
                    case Constants.DISCH_ORDER:
                        order = null;
                        order = request as OrderAction;
                        if (order != null)
                        {
                            subject = "NEW DISCHARGE ORDER";
                            bodyFormat = "ORDER ID: {0}" + Environment.NewLine +
                                         "Location: {1}" + Environment.NewLine +
                                         "DT Ordered: {2}" + Environment.NewLine +
                                         "Signed: {3}" + Environment.NewLine +
                                         "DT Signed: {4}" + Environment.NewLine +
                                         "DT Released: {5}";
                            body = string.Format(bodyFormat,
                                order.OrderId,
                                (order.Order != null && order.Order.HospitalLocation != null) ? order.Order.HospitalLocation.Name : String.Empty,
                                order.DateTimeOrdered.ToString("MM/dd/yy hh:mm"),
                                order.SignedBy != null ? order.SignedBy.Name : string.Empty,
                                (order.DateTimeSigned.HasValue ? order.DateTimeSigned.Value : DateTime.UtcNow).ToString("MM/dd/yy hh:mm"),
                                (order.ReleaseDateTime.HasValue ? order.ReleaseDateTime.Value : DateTime.UtcNow).ToString("MM/dd/yy hh:mm"));
                        }
                        break;
                    case Constants.TRANSFER_ORDER:
                        order = null;
                        order = request as OrderAction;
                        if (order != null)
                        {
                            subject = "NEW TRANSFER ORDER";
                            bodyFormat = "ORDER ID: {0}" + Environment.NewLine +
                                         "Location: {1}" + Environment.NewLine +
                                         "DT Ordered: {2}" + Environment.NewLine +
                                         "Signed: {3}" + Environment.NewLine +
                                         "DT Signed: {4}" + Environment.NewLine +
                                         "DT Released: {5}";
                            body = string.Format(bodyFormat,
                                order.OrderId,
                                (order.Order != null && order.Order.HospitalLocation != null) ? order.Order.HospitalLocation.Name : String.Empty,
                                order.DateTimeOrdered.ToString("MM/dd/yy hh:mm"),
                                order.SignedBy != null ? order.SignedBy.Name : string.Empty,
                                (order.DateTimeSigned.HasValue ? order.DateTimeSigned.Value : DateTime.UtcNow).ToString("MM/dd/yy hh:mm"),
                                (order.ReleaseDateTime.HasValue ? order.ReleaseDateTime.Value : DateTime.UtcNow).ToString("MM/dd/yy hh:mm"));
                        }
                        break;
                    case Constants.ANTICIPATED_DISCHARGE_ORDER:
                        order = null;
                        order = request as OrderAction;
                        if (order != null)
                        {
                            subject = "NEW ANTICIPATED DISCHARGE ORDER";
                            bodyFormat = "ORDER ID: {0}" + Environment.NewLine +
                                         "DT Ordered: {2}" + Environment.NewLine +
                                         "Signed: {3}" + Environment.NewLine +
                                         "DT Signed: {4}" + Environment.NewLine +
                                         "DT Released: {5}" + Environment.NewLine +
                                         "Ward: {1}";
                            body = string.Format(bodyFormat,
                                order.OrderId,
                                (order.Order != null && order.Order.HospitalLocation != null) ? order.Order.HospitalLocation.Name : String.Empty,
                                order.DateTimeOrdered.ToString("MM/dd/yy hh:mm"),
                                order.SignedBy != null ? order.SignedBy.Name : string.Empty,
                                (order.DateTimeSigned.HasValue ? order.DateTimeSigned.Value : DateTime.UtcNow).ToString("MM/dd/yy hh:mm"),
                                (order.ReleaseDateTime.HasValue ? order.ReleaseDateTime.Value : DateTime.UtcNow).ToString("MM/dd/yy hh:mm"));
                        }
                        break;
                    case Constants.BED_SWITCH:
                        BedSwitch bedSwitch = null;
                        bedSwitch = request as BedSwitch;
                        if (bedSwitch != null)
                        {
                            subject = "BED SWITCH";
                            bodyFormat = "Old Room Bed: {2}" + Environment.NewLine +
                                         "New Room Bed: {0}" + Environment.NewLine +
                                         "Ward: {1}";

                            Bed bed = EISFactory.InstanceWindows.GetBed(bedSwitch.BedId, vistaSiteId);
                            Bed oldBed = EISFactory.InstanceWindows.GetBed(bedSwitch.OldBedId, vistaSiteId);
                            Ward ward = EISFactory.InstanceWindows.GetWard(bedSwitch.WardId);
                            body = string.Format(bodyFormat, 
                                bed != null ? bed.Name : string.Empty,
                                ward != null ? ward.Name : string.Empty,
                                oldBed != null ? oldBed.Name : string.Empty);
                        }
                        break;
                    case Constants.DISCHARGE_APPOINTMENT:
                        PatientAppointment appointment = null;
                        appointment = request as PatientAppointment;
                        if (appointment != null)
                        {
                            subject = "NEW DISCHARGE APPOINTMENT ORDER";
                            bodyFormat = "Status: {0}" + Environment.NewLine +
                                         "Appt Date: {1}" + Environment.NewLine +
                                         "Clinic: {2}" + Environment.NewLine +
                                         "Room Bed: {3}" + Environment.NewLine +
                                         "Ward: {4}";
                            Bed bedInt = null; Ward wardInt = null;
                            if (admission != null)
                            {
                                bedInt = EISFactory.InstanceWindows.GetBed(admission.BedId, vistaSiteId);
                                wardInt = EISFactory.InstanceWindows.GetWard(admission.WardId);
                            }
                            body = string.Format(bodyFormat,
                                appointment.CurrentStatus,
                                appointment.AppointmentDateTime.ToString("MM/dd/yy hh:mm"),
                                appointment.HospitalLocation != null ? appointment.HospitalLocation.Name : string.Empty,
                                bedInt != null ? bedInt.Name : string.Empty,
                                wardInt != null ? wardInt.Name : string.Empty);
                        }
                        break;
                }
                return body;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
