﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using InfoWorld.HL7.ITS;
using BMS.Facade.Data;
using BMS.Utils;
using BMS.ServicesWrapper.EVS;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete.EVS
{
    /// <summary>
    /// Medical Center division writer class.
    /// </summary>
    class MedicalCenterDivisionWriter : BaseEvsWriter<MedicalCenterDivision>
    {

        protected override string CodeSystem
        {
            get { return Constants.MedicalCenterDivisionCodeSystem; }
        }

        protected override string CodeSystemName
        {
            get { return Util.Vocabulary.VistaMedicalCenterDivision.ToString(); }
        }


        protected override IEntityDal<CD> Dal
        {
            get { return Data.MedicalCenterDivisionDal; }
        }

        public override void InitCache()
        {
            Data.SetCacheForMedicalCenterDivision();
        }
    }
}
